<?php

/**
 * Class BaseDataExporter
 */
abstract class BaseDataExporter implements ExportDataInterface
{
    protected $username;
    protected $ci;
    protected $db;
    protected $settingsDb;
    protected $restClient;
    protected $phar;
    protected $exportOnlyUserItems;
    protected $isAdmin;
    protected $encryptionKey;

    public function __construct()
    {
        $this->ci = get_instance();
    }

    public function setEncryptionKey($v)
    {
        $this->encryptionKey = $v;
        return $this;
    }

    public function setIsAdmin($v)
    {
        $this->isAdmin = $v;
        return $this;
    }

    public function setUsername($username)
    {
        $this->username = $username;
        return $this;
    }

    public function setDbInstance($instance)
    {
        $this->db = $instance;
        return $this;
    }

    public function setSettingsDbInstance($instance)
    {
        $this->settingsDb = $instance;
        return $this;
    }

    public function setPharObject($object)
    {
        $this->phar = $object;
        return $this;
    }

    public function setExportOnlyUserItems($exportOnlyUserItems)
    {
        $this->exportOnlyUserItems = $exportOnlyUserItems;
        return $this;
    }

    protected function addScriptsToArchive()
    {
        $scriptsDir = '/opt/cfengine/notification_scripts/';
        if (!is_dir($scriptsDir) || is_dir_empty($scriptsDir) || !$this->isAdmin) {
            return false;
        }
        $scripts = scandir($scriptsDir);
        $scripts = array_diff($scripts, ['.', '..']);
        foreach ($scripts as $script) {
            $this->phar->addFile($scriptsDir . $script, 'notification_scripts/' . $script);
        }
    }
}
