<?php

/**
 * Class hub_management
 */
class Hub_management extends Cf_Controller
{
    public function __construct()
    {
        parent::__construct();
        setCurrentApplication('hub_management');
        $this->load->helper('url');
    }

    public function index()
    {
        if (str_ends_with(uri_string(), 'hub_management')) {
            redirect('hub-management', 'refresh');
        }
        $requiredcss = [['../../../themes/default/css/angularjs-ui/angular-ui.css']];

        $this->carabiner->css($requiredcss);

        $requiredAngularjs = [['dist/angular-base.bundle.js']];

        $requiredjs = [
            ['hubManagement/app.js'],
            ['hubManagement/controllers/hubManagementController.js'],
            ['hubManagement/services/hubManagementService.js'],
            ['hubManagement/directives/sshKeyLoader.js'],

            // action service to trigger an agent run after enabling the Policy analyzer
            ['common_directives/actions/actionService.js'],
            ['common_directives/actions/actionHelper.js'],
        ];

        $this->carabiner->js($requiredAngularjs, $requiredAngularjs, $combine = true, $minify = false);
        $this->carabiner->js($requiredjs, $requiredjs, $combine = true, $minify = true);

        $data = ['title' => 'Mission Portal - Hub management'];

        $this->template->load('template', 'hub_management/index', $data);
    }
}
