<?php

class Analyzer extends Cf_Controller
{
    public function __construct()
    {
        parent::__construct();
        setCurrentApplication('policy');
        $this->load->library('ion_auth');
    }

    /**
     * @rbacName View policy analyzer page
     * @rbacGroup Policy analyzer
     * @rbacAlias analyzer.index
     */
    public function index()
    {
        $requiredcss = [['../../../themes/default/css/angularjs-ui/angular-ui.css']];

        $this->carabiner->css($requiredcss);

        $requiredAngularjs = [['dist/angular-base.bundle.js'], ['dist/ace-editor.bundle.js']];

        $requiredjs = [
            ['common_directives/hostsInclude/services/paginationService.js'],
            ['common_directives/environment/services/naviTreeService.js'],
            ['policyAnalyzer/app.js'],
            ['policyAnalyzer/controllers/analyzerController.js'],
            ['policyAnalyzer/services/policyService.js'],
            ['policyAnalyzer/services/policySummaryService.js'],
            ['advancedreports/services/reportService.js'],
            ['policyAnalyzer/directives/policyFileExplorer.js'],
            ['policyAnalyzer/directives/policyEditor.js'],
            ['policyAnalyzer/directives/policySummary.js'],
            ['policyAnalyzer/directives/policyFilter.js'],

            // dependencies for inventory filter
            ['groups/services/sharedGroupsService.js'],
            ['groups/services/personalGroupsService.js'],

            //inventory directive (for filter)
            ['advancedreports/dca.js'],
            ['advancedreports/services/notificationService.js'],
            ['common_directives/inventory/services/inventoryDataService.js'],
            ['common_directives/inventory/services/inventoryFilterService.js'],
            ['common_directives/inventory/inventory_dca.js'],
            ['common_directives/inventory/services/inventoryService.js'],
            ['common_directives/inventory/helpers/inventoryHelper.js'],
            ['common_directives/inventory/directives/inventoryFilterDirectiveCtrl.js'],
            ['common_directives/inventory/directives/inventoryFilter_directive.js'],
            ['common_directives/objectsFilter.js'],

            // hosts include exclude selector
            ['dashboard/helpers/commonHelper.js'],
            ['common_directives/hostsInclude/services/paginationService.js'],
            ['common_directives/hostsInclude/services/includeExcludeService.js'],
            ['common_directives/hostsInclude/services/autocompleteService.js'],
            ['common_directives/hostsInclude/services/naviTreeService.js'],
            ['common_directives/hostsInclude/directives/include_exclude_directive.js'],
            ['common_directives/hostsInclude/directives/includeExcludeSelectionDirective.js'],

            // action service to trigger an agent run after enabling the Policy analyzer
            ['common_directives/actions/actionService.js'],
            ['common_directives/actions/actionHelper.js'],
        ];

        $this->carabiner->js($requiredAngularjs, $requiredAngularjs, $combine = true, $minify = false);
        $this->carabiner->js($requiredjs, $requiredjs, $combine = true, $minify = true);

        $data = ['title' => 'Mission Portal - Policy analyzer'];

        $this->template->load('template', 'policy/analyzer', $data);
    }

    public function partials($partial)
    {
        $view = 'partials/' . $partial . '.php';
        $this->load->view($view);
    }
}
