/*jslint node: true */
/*jslint browser: true*/
/*jslint nomen: true*/
/*global Class, MP_SITE_URL, angular*/
'use strict';

var cmdbServiceClass = Class.extend({
    MODULE_URL: MP_SITE_URL + '/cmdb',

    setUrl: function (url) {
        this.MODULE_URL = MP_SITE_URL + "/" + url
    },
    buildEntry: function ({ name, type, value = null, description = '', tags = [], meta = {} }) {
        return {
            type,
            name,
            description,
            tags,
            meta,
            "entries": [{
                "item_name": name,
                "item_value": value,
                "item_type": type
            }]
        };
    },
    createItem: function (identifier, entry) {
        let url = `${this.MODULE_URL}/item/${identifier}/`;
        return this.$http({
            method: 'POST',
            data: $.param({ data: JSON.stringify(entry) }),
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
            },
            url: url
        });
    },
    deleteItem: function (id) {
        let url = `${this.MODULE_URL}/item/${id}/`;
        return this.$http({
            method: 'DELETE',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
            },
            url: url,
            transformRequest: angular.identity
        });
    },
    getItem: function (identifier, type, name) {
        let url = `${this.MODULE_URL}/item/${identifier}/${type}/${name}/`;
        return this.$http({
            method: 'GET',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
            },
            url: url,
            transformRequest: angular.identity
        });
    }
});

(function () {
    var cmdbServiceServiceProvider = Class.extend({
        instance: new cmdbServiceClass(),
        $get: ['$http', '$httpParamSerializer', function ($http, $httpParamSerializerJQLike) {
            this.instance.$http = $http;
            this.instance.$httpParamSerializerJQLike = $httpParamSerializerJQLike;
            return this.instance;
        }]
    });

    angular.module('cmdbServiceModule', [])
        .provider('cmdbService', cmdbServiceServiceProvider);
}());
