import { createRoot } from 'react-dom/client';

import Cmdb from '../components/Cmdb';
import { ThemeListener } from '../components/ThemeListener/ThemeListener';
import { Provider } from 'react-redux';
import '../styles.scss';
import { store } from '../components/Cmdb/store';

const el = document.getElementById('cmdb-root');

if (el) {
  let root = null;

  const renderApp = () => {
    let data;
    try {
      data = JSON.parse(el.dataset.props || '{}');
    } catch (e) {
     return;
    }
    
    if (!root) {
      root = createRoot(el as HTMLElement);
    }
    
    root.render(
      <Provider store={store}>
        <ThemeListener>
          <Cmdb 
            identifier={data?.identifier} 
            displayShowJson={data?.displayShowJson} 
            ishub={data?.ishub} 
            cmdbServiceUrl={data?.cmdbServiceUrl || ''} 
          />
        </ThemeListener>
      </Provider>
    );
  };

  // initial render
  renderApp();

  // watch for changes to data-props attribute
  const observer = new MutationObserver((mutations) => {
    mutations.forEach((mutation) => {
      if (mutation.type === 'attributes' && mutation.attributeName === 'data-props') {
        renderApp();
      }
    });
  });

  observer.observe(el, { attributes: true, attributeFilter: ['data-props'] });
}
