angular.module('dashboardApp.filters', []).
        filter('startFrom', function() {
            return function(input, start) {
                    if (input instanceof Array) {
                        start = +start; //parse to int
                        return input.slice(start);
                    }
                };
        }).
        filter('DCATimeToString', function() {
            return function(input) {
                var output = input;
                if (input) {
                    input = input.toString()
                    angular.forEach(DCA.Pause_dropDown, function(data, index) {
                        if (data.value === input) {
                            output = data.label;
                        }
                    });
                }
                return output;
            };

        }).filter('toHHMMSS', function() {
    /**
     * Convert seconds to human-readable, used to display paused for next time
     *
     * @param {string} input - number of seconds
     */
                return function(input) {
                var sec_num = parseInt(input, 10);
                var hours = '';
                var minutes = Math.floor((sec_num - (hours * 3600)) / 60);
                var seconds = sec_num - (hours * 3600) - (minutes * 60);

                var time = '';

                if (seconds >= 3600)
                {
                    hours = Math.floor(sec_num / 3600);
                    if (hours < 10) {
                        hours = "0" + hours;
                    }
                     time += hours + ':';
                }

                if (minutes < 10) {
                    minutes = "0" + minutes;
                }
                if (seconds < 10) {
                    seconds = "0" + seconds;
                }

                time += minutes + ':' + seconds;

                return time;
                };
        }).
                filter('convertTime', function() {
                    /**
                     * return date + time, used to display last check info
                     *
                     * @param {string} input - unix timestamp
                     */
                    return function(input) {
                        if (input) {
                           var timestamp = common.unixTimeToJavascriptTime(input);
                           return common.time.format(timestamp);
                        } else {
                            return null;
                        }

                    };
            }).filter('DCA_ValueToString', function() {
            return function(input, DCAType) {
                var output = input;
                if (input) {
                    input = input.toString();
                    angular.forEach(DCA[DCAType], function(data, index) {
                        if (data.value === input) {
                            output = data.label;
                        }
                    });
                }
                return output;
            };

        }).filter('sortArrayAlphabet', function() {
              return function(input) {
                return input.sort();
              };
        })
        .filter('truncateString', ['commonHelper', function (commonHelper) {
        return function (value, wordwise, max, tail) {
            return commonHelper.truncateString(value, wordwise, max, tail);
            };
        }])
        .filter('alertsFilter', function() {
            return function(input, cats) {

                var newArray = [];

                for (var i=0;i<input.length;i++) {
                    if (cats.triggered) {
                        if (input[i].failHosts && input[i].failHosts>0 && !input[i].paused) {

                             newArray.push(input[i]);
                        }
                    }
                    if (cats.ok) {
                        if ((!input[i].failHosts || input[i].failHosts===0)&&!input[i].paused) {
                             newArray.push(input[i]);
                        }
                    }
                    if (cats.paused) {
                        if (input[i].paused) {
                              newArray.push(input[i]);
                        }
                    }
                }

                return newArray;

            };
        })
        .filter('alertSearchFilter', function() {
            return function(input, searchTerm) {
                if (!searchTerm) {
                    return input;
                }

                var searchLow = searchTerm.toLowerCase();

                return input.filter(function(element,index,array) {
                    return (element.name.toLowerCase().indexOf(searchLow)!==-1 || element.rule.name.toLowerCase().indexOf(searchLow)!==-1);
              });
            };
        }).filter('ruleSearchFilter', function() {
            return function(input, searchTerm) {
                if (!searchTerm) {
                    return input;
                }

                var searchLow = searchTerm.toLowerCase();

                return input.filter(function(element,index,array) {
                    return element.name.toLowerCase().indexOf(searchLow)!==-1;
              });
            };
        }).filter('FilterConditionLabel', function() {
            return function(input, field) {
                  var conditionList = [];
                  var output;

                  switch(field.type) {
                      case 'string':
                          conditionList = STRING_CONDITION;
                          break;

                      case 'int':
                          conditionList = NUMERIC_CONDITION;
                          break;

                      case 'slist':
                          conditionList = LIST_CONDITION;
                          break;

                      case 'context':
                          conditionList = CONTEXT_CONDITION;
                          break;
                      default: conditionList = [];
                  }


                  if (!conditionList.length) {
                      return input;
                  }

                   angular.forEach(conditionList, function(data, index) {
                        if (data.value === input) {
                            output = data.label;
                        }
                    });
                return output;
            };
        })
    .filter('FilterByObject', function () {
        return function (input, search, conditionShouldBeMet = true) {
            if (!input || !search) {
                return input;
            }

            let result = [];
            angular.forEach(input, function (value) {
                let include = true;
                angular.forEach(search, function (searchValue, searchKey) {
                    if (!value.hasOwnProperty(searchKey) || (searchValue !== undefined && value[searchKey] != searchValue)) {
                        include = false;
                    }
                });
                if (conditionShouldBeMet && include) {
                    result.push(value);
                } else if(!conditionShouldBeMet && !include){
                    result.push(value);
                }
            });
            return result;
        }
    })
    .filter('arrayOrderBy', function () {
        return function (input, property, reverseSort) {
            if (!input || !property) {
                return input;
            }

            const sortFn = function (prop, reverseSort) {
                let sortDirection = reverseSort ? -1 : 1;
                return (a, b) => ((a[prop] < b[prop]) ? -1 : (a[prop] > b[prop]) ? 1 : 0) * sortDirection;
            }
            return input.sort(sortFn(property, reverseSort));
        }
    });
