<?php

/**
 * Class ContextImplementation
 */
class ContextImplementation implements FormatInventoryFilterInterface
{
    /**
     * @param $value
     * @param $operator
     * @return mixed|string
     */
    public function getValueForWhere($value, $operator, \PDO $pdo)
    {
        switch ($operator) {
            case InventoryLib::MATCHES_OPERATOR:
            case InventoryLib::NOT_MATCH_OPERATOR:
                $value = $pdo->quote("%" . $value . "%");
                break;

            case InventoryLib::EQUAL_OPERATOR:
            case InventoryLib::NOT_EQUAL_OPERATOR:
                $value = $pdo->quote($value);
                break;
            case InventoryLib::IS_REPORTED_OPERATOR:
            case InventoryLib::IS_NOT_REPORTED_OPERATOR:
                $value = null;
                break;
        }
        return $value;
    }

}
