<base href="/build/">
<div ng-app="buildApp" id="ng-app">
    <div id="buildApp" class="contentWrapper" ng-view></div>
    <script type="text/ng-template" id="localDeployModal.html">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal"  ng-click="close()">
                <i class="bi bi-x"></i>
            </button>
            <h2>Deploy local project</h2>
        </div>
        <div class="modal-body">
            This action will update your VCS settings and change which policy set is running on this hub. Are you sure?
        </div>
        <div class="modal-footer">
            <button ng-disabled="isSpinnerOn" class="btn btn-large btn-primary pull-right" ng-click="pushAndDeploy()">
                Yes, deploy
            </button>
            <button class="btn btn-large btn-info pull-left" type="button" class="close" data-dismiss="modal"
                     ng-click="close()">
                No, cancel
            </button>
        </div>
    </script>
    <script type="text/ng-template" id="deployModal.html">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal"  ng-click="close()">
                <i class="bi bi-x"></i>
            </button>
            <h2>Deploy project</h2>
        </div>
        <div class="modal-body">
            Pushing these changes will not result in them being deployed on this hub,
            since it’s not set up to use the same git repository as this project.
            Do you want to change the version control settings to deploy to this hub?
        </div>
        <div class="modal-footer">
            <button ng-disabled="isSpinnerOn" class="btn btn-large btn-primary pull-right" ng-click="push()">
                No, just push
            </button>
            <button ng-disabled="isSpinnerOn" class="btn btn-large btn-primary pull-right" ng-click="pushAndDeploy()">
                Yes, push and deploy to this hub
            </button>
            <button class="btn btn-large btn-info pull-left" type="button" class="close" data-dismiss="modal"
                     ng-click="close()">
                Cancel
            </button>
        </div>
    </script>
    <script type="text/ng-template" id="diverged.html">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal"  ng-click="close()">
                <i class="bi bi-x"></i>
            </button>
            <h2>The remote git repository for this project has changed</h2>
        </div>
        <div class="modal-body">
            To ensure we don’t delete any history,
            CFEngine Build will never force push. What do you want to do?
        </div>
        <div class="modal-footer">
            <button class="btn btn-large btn-info pull-left" type="button" class="close" data-dismiss="modal"
                     ng-click="close()">
                Nothing
            </button>
            <button ng-disabled="isSpinnerOn" class="btn btn-large btn-primary pull-right" ng-click="forceRebaseAndPush()">
                Push local changes in a new commit
            </button>
            <button ng-disabled="isSpinnerOn" class="btn btn-large btn-primary pull-right" ng-click="forcePull()">
                Discard local changes
            </button>
        </div>
    </script>
    <script type="text/ng-template" id="masterfilesVesions.html">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal"  ng-click="close()">
                <i class="bi bi-x"></i>
            </button>
            <h2>Which version of masterfiles would you like to use?</h2>
        </div>
        <div class="modal-body">
            <div>
                <div class='controls'>
                    <div class="radio margin-bottom-small" ng-repeat="version in versions track by $index">
                        <label>
                            <input
                                    type="radio"
                                    name="starting"
                                    ng-model="data.selected"
                                    ng-value="version"
                            />
                            {{ version.label }}
                        </label>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button class="btn btn-large btn-info pull-left" type="button" class="close" data-dismiss="modal"
                     ng-click="close()">
                Close
            </button>
            <button class="btn btn-large btn-primary pull-right" ng-click="confirm()">
                Confirm
            </button>
        </div>
    </script>
</div>
