(function($) {
    $.widget('ui.hostsConnectivity', {
        options: {
            baseUrl: '../',
            defaultbehaviour: true
        },
        ajaxloader: $('<span class="loadinggif"></span>'),
        header:'',
        colorEntryWrapper: $('<div class="warning-box"><h5>Warning</h5>' +
            '<span><span class="totalNumberOfHost">0</span> of your hosts currently contain(s) incomplete data; they might not be included correctly.</span>' +
            '<a href="#" class="missingHostData">List hosts with missing data.</a></div>'),
        _create: function() {
            var $self = this;

            $self.element.append($self.header);
            $self.ajaxloader.prependTo($self.header);
            $self.ajaxloader.hide();
            $self.element.append($self.colorEntryWrapper);

        },

        _init: function() {
            var $self = this;
            $self._active = true;
            $self.element.find('.missingHostData').click(function(e) {

                e.preventDefault();
                $self._trigger("colorentryclicked", e, {
                    'color': 'bb',
                    'includes': $self._context.includes,
                    'excludes': $self._context.excludes
                });
            });
             $self.element.hide();
        },

        setContext: function(includes, excludes) {
            var $self = this;

            $self._context.includes = includes;
            $self._context.excludes = excludes;

            if ($self._active) $self.refresh();
        },

        setActive: function(state) {
            var $self = this;
            $self._active = state;
        },

        refresh: function() {
            var $self = this;
            $self.ajaxloader.show();
            $self.element.find('.colourEntryLabel').html('');
            $.getJSON($self._requestUrls.hostCountAll($self, $self._context.includes), function(data) {
                var totalHost = data.blue + data.black;
                if (totalHost > 0) {
                    $self.element.find('.totalNumberOfHost').html(totalHost);
                    $self.element.show();
                } else {
                     $self.element.hide();
                }
                $self.ajaxloader.hide();
            }).fail(function(jqXHR, textStatus, errorThrown) {
                var opt = {
                    statusCode: jqXHR.status,
                    targetDiv: $self.colorEntryWrapper
                };
                common.showAjaxError(opt);
                $self.ajaxloader.hide();
            });
        },

        _setHostCount: function($entry, count, label) {
            var $countLabel = $entry.children('.label');
            $countLabel.html(count);

            var $linkLable = $entry.children('.colourEntryLabel');
            $linkLable.html(label);
        },

        _context: {
            includes: [],
            excludes: []
        },

        _requestUrls: {

            blueHostThreshold: function(self) {

                return self.options.baseUrl + '/appsettings/bluehostthreshold';
            },

            hostCountAll: function(self, includes) {
                return self.options.baseUrl + '/host/countConnectivity?' + 'includes=' + encodeURIComponent(includes);
            }
        }
    });

    $.extend($.ui.hostsCompliance, {
        instances: []
    });

})(jQuery);