'use strict';

var personalGroupsServiceClass = Class.extend({
    PERSONAL_GROUP_URL: MP_SITE_URL + '/groups_app/personalGroups',

    create: function (data) {
        return this.$http.post(this.PERSONAL_GROUP_URL + '/group', data, {cache: false});
    },

    update: function (id, data) {
        return this.$http.put(`${this.PERSONAL_GROUP_URL}/group/${id}`, data, {cache: false});
    },

    addGroup: function () {
        return this.$http.post(`${this.PERSONAL_GROUP_URL}/new_group`, [], {cache: false});
    },

    remove: function (id) {
        return this.$http.delete(`${this.PERSONAL_GROUP_URL}/group/${id}`, {cache: false});
    },

    get: function (id) {
        return this.$http.get(`${this.PERSONAL_GROUP_URL}/group/${id}`, {cache: false});
    },

    list: function (params) {
        return this.$http.get(`${this.PERSONAL_GROUP_URL}/list?${params}`, {cache: false});
    },

    makeShared: function (id) {
        return this.$http.post(`${this.PERSONAL_GROUP_URL}/shared/${id}`, {cache: false});
    },

    addToFavorites: function (id) {
        return this.$http.post(`${this.PERSONAL_GROUP_URL}/favorite/${id}`, {cache: false});
    },

    removeFromFavorites: function (id) {
        return this.$http.delete(`${this.PERSONAL_GROUP_URL}/favorite/${id}`, {cache: false});
    },
});

(function () {
    const personalGroupsServiceClassProvider = Class.extend({
        instance: new personalGroupsServiceClass(),
        $get: ['$http',
            function ($http) {
                this.instance.$http = $http;
                return this.instance;
        }]
    });

    angular.module('personalGroupsServiceModule', []).provider('personalGroupsService', personalGroupsServiceClassProvider);
}());
