#!/usr/bin/env bash
# PHPUnit Selenium Tests Runner
# This script runs the selenium tests for mission-portal

# Set SELENIUM flag for this script
export SELENIUM=1

# Source common setup
SCRIPT_DIR=$(dirname "$0")
source "${SCRIPT_DIR}/common-setup.sh"

# Start Selenium server and run selenium tests
selenium_log="${NTECH_ROOT}/artifacts/selenium.log"
result=running

sudo systemctl daemon-reload
sudo systemctl restart xvfb
seljar=selenium-server-standalone-3.4.0.jar
if [ ! -f $seljar ]; then
  sudo wget --quiet http://selenium-release.storage.googleapis.com/3.4/$seljar
fi
export DISPLAY=:1
sudo pkill -9 firefox || true
sudo pkill -9 geckodriver || true
sudo pkill -9 java || true # clean up previous run in case of iterative development
sudo java -jar ./$seljar 2>&1 | sudo tee "$selenium_log" >/dev/null &
# Give Selenium time to start
sleep 10

# example of running one or more specific test is using --filter argument
# sudo --preserve-env=GITLAB_BUILD_REPOSITORY_TOKEN ./vendor/phpunit/phpunit/phpunit --configuration phpunit_selenium.xml --filter RedirectAfterLoginTest || result=fail

sleep 10

sudo COMPOSER_ALLOW_SUPERUSER=1 /usr/local/bin/composer run db-fixtures

if [ -n "$RUN_IN_PARALLEL" ]; then
  # Run tests in parallel using groups
  PARALLEL_GROUPS=${PARALLEL_GROUPS:-2}

  for i in $(seq 1 $PARALLEL_GROUPS); do
    sudo --preserve-env=GITLAB_BUILD_REPOSITORY_TOKEN ./vendor/phpunit/phpunit/phpunit \
      --group "group$i" \
      --log-junit "${NTECH_ROOT}/artifacts/phpunit-selenium-report-group_$i.xml" \
      --debug --verbose \
      --configuration phpunit_selenium.xml &
    pids[$i]=$!
  done

  # Wait for all test processes to complete
  for pid in ${pids[*]}; do
    wait $pid || result=fail
  done

  sudo --preserve-env=GITLAB_BUILD_REPOSITORY_TOKEN ./vendor/phpunit/phpunit/phpunit \
      --log-junit "${NTECH_ROOT}/artifacts/phpunit-selenium-report-group_0.xml" \
      --debug --verbose \
      --configuration phpunit_selenium.xml \
      selenium/xAuditLogTest.php || result=fail
else
  # Run tests sequentially
  sudo --preserve-env=GITLAB_BUILD_REPOSITORY_TOKEN ./vendor/phpunit/phpunit/phpunit \
      --log-junit "${NTECH_ROOT}/artifacts/phpunit-selenium-report.xml" \
      --debug --verbose \
      --configuration phpunit_selenium.xml || result=fail
fi

# Process selenium log for JavaScript errors
sudo chmod +x "${NTECH_ROOT}/mission-portal/ci/selenium-log-to-javascript-errors-junit-report.sh"
sudo "${NTECH_ROOT}/mission-portal/ci/selenium-log-to-javascript-errors-junit-report.sh" "$selenium_log" "${NTECH_ROOT}/artifacts/js-errors-report.xml"

if [ "$result" = "fail" ]; then
  ps -efl | grep java
  sudo systemctl status xvfb
  ps -efl | grep firefox
  ps -efl | grep gecko
  ls -l $(which firefox)
  firefox --version
  ls -l $(which geckodriver)
  geckodriver --version
  failure
  exit 1
fi
