import * as redux from 'redux';
import * as _reduxjs_toolkit from '@reduxjs/toolkit';
import { PayloadAction } from '@reduxjs/toolkit';
import * as immer from 'immer';
import { SortCriteria, DeviceDeviceauth, DeviceConfiguration, DeviceStateDeviceconnect, MonitorConfiguration, DeviceState } from '@northern.tech/types/MenderTypes';
import { DeviceIssueOptionKey, SortOptions, ALL_DEVICE_STATES } from '@northern.tech/utils/constants';
import { FilterOperator } from '../commonConstants.js';
import { DeviceAuthState } from './constants.js';
import { DeviceDeployment } from '../deploymentsSlice/index.js';
import 'react/jsx-runtime';

declare const sliceName = "devices";
type DeviceSelectedAttribute = {
    attribute: string;
    scope: string;
};
type DeviceListState = {
    detailsTab: string;
    deviceIds: string[];
    isLoading: boolean;
    open?: boolean;
    page: number;
    perPage: number;
    refreshTrigger: boolean;
    selectedAttributes: DeviceSelectedAttribute[];
    selectedId?: string;
    selectedIssues: DeviceIssueOptionKey[];
    selection: number[];
    setOnly?: boolean;
    sort: SortOptions & Partial<SortCriteria>;
    state?: DeviceAuthState | typeof ALL_DEVICE_STATES;
    total: number;
};
type DeviceReport = {
    items: {
        count: number;
        key: string;
    }[];
    otherCount: number;
    total: number;
};
type DeviceGroup = {
    deviceIds?: string[];
    filters?: DeviceFilter[];
    id?: string;
    total?: number;
};
type InventoryAttributes = {
    [key: string]: string | string[];
    artifact_name: string;
    device_type: string[];
};
type UiDeviceAttributes = {
    attributes: InventoryAttributes;
    identity?: Record<string, string>;
    monitor?: Record<string, string>;
    system: Record<string, string>;
    tags?: Record<string, string>;
};
type Device = DeviceDeviceauth & UiDeviceAttributes & {
    check_in_time_exact?: string;
    check_in_time_rounded?: string;
    config?: DeviceConfiguration;
    connect_status?: DeviceStateDeviceconnect['status'];
    connect_updated_ts?: string;
    deploymentsCount?: number;
    deviceDeployments?: DeviceDeployment;
    etag?: string;
    gatewayIds?: string[];
    group?: string;
    id: string;
    isNew?: boolean;
    isOffline?: boolean;
    monitors?: MonitorConfiguration[];
    status: DeviceDeviceauth.status;
    twinsByIntegration?: Record<string, DeviceState & {
        twinError?: string;
    }>;
};
type DeviceFilter = {
    key: string;
    operator: FilterOperator;
    scope: string;
    value: string | string[];
};
type FilteringAttributes = {
    identityAttributes: string[];
    inventoryAttributes: string[];
    systemAttributes: string[];
    tagAttributes: string[];
};
type FilteringAttributesConfig = {
    attributes: Record<string, string[]>;
    count: number;
    limit: number;
};
type DeviceStatus = DeviceAuthState | 'active' | 'inactive';
type DeviceGroups = {
    byId: Record<string, DeviceGroup>;
    selectedGroup?: string;
};
type DeviceSliceType = {
    byId: Record<string, Device>;
    byStatus: Record<DeviceStatus, {
        deviceIds: string[];
        total: number;
    }>;
    deviceList: DeviceListState;
    filteringAttributes: FilteringAttributes;
    filteringAttributesConfig: FilteringAttributesConfig;
    filteringAttributesLimit: number;
    filters: DeviceFilter[];
    groups: DeviceGroups;
    limit: number;
    reports: DeviceReport[];
    total: number;
};
declare const initialState: DeviceSliceType;
declare const devicesSlice: _reduxjs_toolkit.Slice<DeviceSliceType, {
    receivedGroups: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<Record<string, DeviceGroup>>) => void;
    addToGroup: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<{
        deviceIds: string[];
        group: string;
    }>) => void;
    removeFromGroup: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<{
        deviceIds: string[];
        group: string;
    }>) => void;
    addGroup: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<{
        group: DeviceGroup;
        groupName: string;
    }>) => void;
    selectGroup: (state: immer.WritableDraft<DeviceSliceType>, { payload: group }: PayloadAction<string | undefined>) => void;
    removeGroup: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<string>) => void;
    setDeviceListState: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<Partial<DeviceListState>>) => void;
    setFilterAttributes: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<FilteringAttributes>) => void;
    setFilterablesConfig: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<FilteringAttributesConfig>) => void;
    receivedDevices: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<Record<string, Device>>) => void;
    setDeviceFilters: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<DeviceFilter[]>) => void;
    setInactiveDevices: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<{
        activeDeviceTotal: number;
        inactiveDeviceTotal: number;
    }>) => void;
    setDeviceReports: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<DeviceReport[]>) => void;
    setDevicesByStatus: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<{
        deviceIds: string[];
        forceUpdate?: boolean;
        status: DeviceStatus;
        total: number;
    }>) => void;
    setDevicesCountByStatus: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<{
        count: number;
        status: DeviceStatus;
    }>) => void;
    setDeviceLimit: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<number>) => void;
    receivedDevice: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<{
        id: string;
    } & Partial<Device>>) => void;
    maybeUpdateDevicesByStatus: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<{
        authId?: string;
        deviceId: string;
    }>) => void;
}, "devices", "devices", _reduxjs_toolkit.SliceSelectors<DeviceSliceType>>;
declare const actions: _reduxjs_toolkit.CaseReducerActions<{
    receivedGroups: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<Record<string, DeviceGroup>>) => void;
    addToGroup: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<{
        deviceIds: string[];
        group: string;
    }>) => void;
    removeFromGroup: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<{
        deviceIds: string[];
        group: string;
    }>) => void;
    addGroup: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<{
        group: DeviceGroup;
        groupName: string;
    }>) => void;
    selectGroup: (state: immer.WritableDraft<DeviceSliceType>, { payload: group }: PayloadAction<string | undefined>) => void;
    removeGroup: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<string>) => void;
    setDeviceListState: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<Partial<DeviceListState>>) => void;
    setFilterAttributes: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<FilteringAttributes>) => void;
    setFilterablesConfig: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<FilteringAttributesConfig>) => void;
    receivedDevices: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<Record<string, Device>>) => void;
    setDeviceFilters: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<DeviceFilter[]>) => void;
    setInactiveDevices: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<{
        activeDeviceTotal: number;
        inactiveDeviceTotal: number;
    }>) => void;
    setDeviceReports: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<DeviceReport[]>) => void;
    setDevicesByStatus: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<{
        deviceIds: string[];
        forceUpdate?: boolean;
        status: DeviceStatus;
        total: number;
    }>) => void;
    setDevicesCountByStatus: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<{
        count: number;
        status: DeviceStatus;
    }>) => void;
    setDeviceLimit: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<number>) => void;
    receivedDevice: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<{
        id: string;
    } & Partial<Device>>) => void;
    maybeUpdateDevicesByStatus: (state: immer.WritableDraft<DeviceSliceType>, action: PayloadAction<{
        authId?: string;
        deviceId: string;
    }>) => void;
}, "devices">;
declare const _default: redux.Reducer<DeviceSliceType>;

export { type Device, type DeviceFilter, type DeviceGroup, type DeviceGroups, type DeviceListState, type DeviceSelectedAttribute, type DeviceSliceType, type DeviceStatus, type InventoryAttributes, actions, _default as default, devicesSlice, initialState, sliceName };
