"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/monitorSlice/thunks.ts
var thunks_exports = {};
__export(thunks_exports, {
  changeNotificationSetting: () => changeNotificationSetting,
  getDeviceAlerts: () => getDeviceAlerts,
  getDeviceMonitorConfig: () => getDeviceMonitorConfig,
  getIssueCountsByType: () => getIssueCountsByType2,
  getLatestDeviceAlerts: () => getLatestDeviceAlerts
});
module.exports = __toCommonJS(thunks_exports);

// src/monitorSlice/index.ts
var import_toolkit = require("@reduxjs/toolkit");

// src/constants.ts
var import_constants3 = require("@northern.tech/utils/constants");

// src/appSlice/constants.ts
var import_icons_material = require("@mui/icons-material");
var startingDeviceCount = {
  os: "for first 50 devices",
  professional: "for first 250 devices"
};
var chartTypes = {
  bar: { key: "bar", Icon: import_icons_material.BarChart },
  pie: { key: "pie", Icon: import_icons_material.PieChartOutline }
};
var emptyChartSelection = { software: "", group: "", chartType: chartTypes.bar.key, attribute: "artifact_name" };
var defaultReportType = "distribution";
var defaultReports = [{ ...emptyChartSelection, group: null, attribute: "artifact_name", type: defaultReportType }];
var PLANS = {
  os: {
    id: "os",
    name: "Basic",
    minimalDeviceCount: 50,
    offer: true,
    price: "$34 / month",
    deviceCount: startingDeviceCount.os,
    description: "The core features of Mender. To continue using Enterprise Trial features\u2014like Delta updates, scheduled deployments, phased rollouts, device filtering, dynamic groups, RBAC, audit logs, and more\u2014please upgrade to a higher plan.",
    features: ["Access to core features of Mender", "Basic support"]
  },
  professional: {
    id: "professional",
    name: "Professional",
    minimalDeviceCount: 250,
    offer: true,
    price: "$291 / month",
    deviceCount: startingDeviceCount.professional,
    description: "Everything in Basic, plus enhanced update management and automation features.",
    features: ["Advanced OTA features", "Higher priority support"]
  },
  enterprise: {
    id: "enterprise",
    name: "Enterprise",
    minimalDeviceCount: 1e3,
    price: "Custom pricing",
    deviceCount: "Unlimited devices",
    description: "Every advanced feature of Mender, tailored for complex and large-scale deployments. Not available as a monthly subscription \u2014 ask us for a quote.",
    features: ["All Mender features", "Advanced security features", "SLA-backed support"]
  }
};
var ADDONS = {
  configure: {
    id: "configure",
    title: "Configure",
    description: "Expand your plan with device configuration features",
    needs: ["hasDeviceConfig"],
    os: {
      price: "$11/month",
      deviceCount: startingDeviceCount.os
    },
    professional: {
      price: "$65/month",
      deviceCount: startingDeviceCount.professional
    },
    eligible: ["os", "professional", "enterprise"]
  },
  monitor: {
    id: "monitor",
    title: "Monitor",
    description: "Expand your plan with device monitoring features",
    needs: ["hasMonitor"],
    os: {
      price: "-",
      deviceCount: "-"
    },
    professional: {
      price: "$86/month",
      deviceCount: startingDeviceCount.professional
    },
    eligible: ["professional", "enterprise"]
  },
  troubleshoot: {
    id: "troubleshoot",
    title: "Troubleshoot",
    description: "Expand your plan with device troubleshooting features",
    needs: ["hasDeviceConnect"],
    os: {
      price: "$27/month",
      deviceCount: startingDeviceCount.os
    },
    professional: {
      price: "$72/month",
      deviceCount: startingDeviceCount.professional
    },
    eligible: ["os", "professional", "enterprise"]
  }
};
var BENEFITS = {
  auditlog: { id: "auditlog", benefit: "trace change across your devices and access troubleshooting session replay", requiredPlan: PLANS.professional.id },
  dashboard: { id: "dashboard", benefit: "actionable insights into the devices you are updating with Mender", requiredPlan: PLANS.enterprise.id },
  deltaGeneration: {
    id: "deltaGeneration",
    benefit: "automatic delta artifacts generation to minimize data transfer and improve the update delivery",
    requiredPlan: PLANS.enterprise.id
  },
  deviceConfiguration: { id: "deviceConfiguration", benefit: "device configuration features", requiredAddon: ADDONS.configure.id },
  deviceMonitor: { id: "deviceMonitor", benefit: "device monitoring features", requiredAddon: ADDONS.monitor.id, requiredPlan: PLANS.professional.id },
  deviceTroubleshoot: { id: "deviceTroubleshoot", benefit: "device troubleshooting features", requiredAddon: ADDONS.troubleshoot.id },
  dynamicGroups: { id: "dynamicGroups", benefit: "create dynamic groups to ease device management", requiredPlan: PLANS.enterprise.id },
  fullFiltering: { id: "fullFiltering", benefit: "filtering by multiple attributes to improve the device overview", requiredPlan: PLANS.professional.id },
  gateway: { id: "gateway", benefit: "see devices connected to your gateway device for easy access", requiredPlans: PLANS.professional.id },
  pausedDeployments: {
    id: "pausedDeployments",
    benefit: "granular control about update rollout to allow synchronization across your fleet",
    requiredPlan: PLANS.enterprise.id
  },
  phasedDeployments: { id: "phasedDeployments", benefit: "choose to roll out deployments in multiple phases", requiredPlan: PLANS.enterprise.id },
  rbac: { id: "rbac", benefit: "granular role based access control", requiredPlan: PLANS.enterprise.id },
  retryDeployments: { id: "retryDeployments", benefit: "optional retries for failed rollout attempts", requiredPlan: PLANS.professional.id },
  scheduledDeployments: {
    id: "scheduledDeployments",
    benefit: "scheduled deployments to steer the distribution of your updates.",
    requiredPlan: PLANS.professional.id
  },
  webhookEvents: {
    id: "webhookEvents",
    benefit: "receive inventory events and select which type(s) of events the webhook will receive",
    requiredPlan: PLANS.professional.id
  },
  default: { id: "default", benefit: "gain access to this feature", requiredPlan: PLANS.enterprise.id }
};
var DARK_MODE = "dark";

// src/commonConstants.tsx
var import_js = require("@mdi/js");
var import_MenderTypes = require("@northern.tech/types/MenderTypes");
var import_jsx_runtime = require("react/jsx-runtime");
var timeUnits = {
  days: "days",
  minutes: "minutes",
  hours: "hours"
};
var UNGROUPED_GROUP = { id: "*|=ungrouped=|*", name: "Unassigned" };
var DEVICE_LIST_MAXIMUM_LENGTH = 50;
var oneSecond = 1e3;
var TIMEOUTS = {
  debounceDefault: 700,
  debounceShort: 300,
  halfASecond: 0.5 * oneSecond,
  oneSecond,
  twoSeconds: 2 * oneSecond,
  threeSeconds: 3 * oneSecond,
  fiveSeconds: 5 * oneSecond,
  refreshDefault: 10 * oneSecond,
  refreshLong: 60 * oneSecond
};
var DEVICE_ONLINE_CUTOFF = { interval: 1, intervalName: timeUnits.days };
var defaultIdAttribute = Object.freeze({ attribute: "id", scope: import_constants3.ATTRIBUTE_SCOPES.identity });
var credentialTypes = {
  aws: import_MenderTypes.Credentials.type.AWS,
  http: import_MenderTypes.Credentials.type.HTTP,
  sas: import_MenderTypes.Credentials.type.SAS,
  x509: "x509"
};
var EXTERNAL_PROVIDER = {
  "iot-core": {
    credentialsType: credentialTypes.aws,
    icon: import_js.mdiAws,
    title: "AWS IoT Core",
    twinTitle: "Device Shadow",
    provider: "iot-core",
    enabled: true,
    deviceTwin: true,
    configHint: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_jsx_runtime.Fragment, { children: "For help finding your AWS IoT Core connection string, check the AWS IoT documentation." })
  },
  "iot-hub": {
    credentialsType: credentialTypes.sas,
    icon: import_js.mdiMicrosoftAzure,
    title: "Azure IoT Hub",
    twinTitle: "Device Twin",
    provider: "iot-hub",
    enabled: true,
    deviceTwin: true,
    configHint: /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("span", { children: [
      "For help finding your Azure IoT Hub connection string, look under 'Shared access policies' in the Microsoft Azure UI as described",
      " ",
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
        "a",
        {
          href: "https://devblogs.microsoft.com/iotdev/understand-different-connection-strings-in-azure-iot-hub/#iothubconn",
          target: "_blank",
          rel: "noopener noreferrer",
          children: "here"
        }
      ),
      "."
    ] })
  },
  webhook: {
    credentialsType: credentialTypes.http,
    deviceTwin: false,
    twinTitle: "",
    // disable the webhook provider here, since it is treated different than other integrations, with a custom configuration & management view, etc.
    enabled: false,
    provider: "webhook"
  }
};
var emptyWebhook = {
  description: "",
  provider: import_MenderTypes.Integration.provider.WEBHOOK,
  credentials: {
    type: EXTERNAL_PROVIDER.webhook.credentialsType,
    [EXTERNAL_PROVIDER.webhook.credentialsType]: {
      secret: "",
      url: ""
    }
  }
};
var regionNames = new Intl.DisplayNames(["en"], { type: "region" });
var countries = [
  "AD",
  "AE",
  "AF",
  "AG",
  "AI",
  "AL",
  "AM",
  "AO",
  "AQ",
  "AR",
  "AS",
  "AT",
  "AU",
  "AW",
  "AX",
  "AZ",
  "BA",
  "BB",
  "BD",
  "BE",
  "BF",
  "BG",
  "BH",
  "BI",
  "BJ",
  "BL",
  "BM",
  "BN",
  "BO",
  "BR",
  "BS",
  "BT",
  "BV",
  "BW",
  "BY",
  "BZ",
  "CA",
  "CC",
  "CD",
  "CF",
  "CG",
  "CH",
  "CI",
  "CK",
  "CL",
  "CM",
  "CN",
  "CO",
  "CR",
  "CU",
  "CV",
  "CW",
  "CX",
  "CY",
  "CZ",
  "DE",
  "DJ",
  "DK",
  "DM",
  "DO",
  "DZ",
  "EC",
  "EE",
  "EG",
  "EH",
  "ER",
  "ES",
  "ET",
  "FI",
  "FJ",
  "FK",
  "FM",
  "FO",
  "FR",
  "GA",
  "GB",
  "GD",
  "GE",
  "GF",
  "GG",
  "GH",
  "GI",
  "GL",
  "GM",
  "GN",
  "GP",
  "GQ",
  "GR",
  "GS",
  "GT",
  "GU",
  "GW",
  "GY",
  "HK",
  "HM",
  "HN",
  "HR",
  "HT",
  "HU",
  "ID",
  "IE",
  "IL",
  "IM",
  "IN",
  "IO",
  "IQ",
  "IR",
  "IS",
  "IT",
  "JE",
  "JM",
  "JO",
  "JP",
  "KE",
  "KG",
  "KH",
  "KI",
  "KM",
  "KN",
  "KP",
  "KR",
  "KW",
  "KY",
  "KZ",
  "LA",
  "LB",
  "LC",
  "LI",
  "LK",
  "LR",
  "LS",
  "LT",
  "LU",
  "LV",
  "LY",
  "MA",
  "MC",
  "MD",
  "ME",
  "MF",
  "MG",
  "MH",
  "MK",
  "ML",
  "MM",
  "MN",
  "MO",
  "MP",
  "MQ",
  "MR",
  "MS",
  "MT",
  "MU",
  "MV",
  "MW",
  "MX",
  "MY",
  "MZ",
  "NA",
  "NC",
  "NE",
  "NF",
  "NG",
  "NI",
  "NL",
  "NO",
  "NP",
  "NR",
  "NU",
  "NZ",
  "OM",
  "PA",
  "PE",
  "PF",
  "PG",
  "PH",
  "PK",
  "PL",
  "PM",
  "PN",
  "PR",
  "PS",
  "PT",
  "PW",
  "PY",
  "QA",
  "RE",
  "RO",
  "RS",
  "RU",
  "RW",
  "SA",
  "SB",
  "SC",
  "SD",
  "SE",
  "SG",
  "SH",
  "SI",
  "SJ",
  "SK",
  "SL",
  "SM",
  "SN",
  "SO",
  "SR",
  "SS",
  "ST",
  "SV",
  "SX",
  "SY",
  "SZ",
  "TC",
  "TD",
  "TF",
  "TG",
  "TH",
  "TJ",
  "TK",
  "TL",
  "TM",
  "TN",
  "TO",
  "TR",
  "TT",
  "TV",
  "TW",
  "TZ",
  "UA",
  "UG",
  "US",
  "UY",
  "UZ",
  "VA",
  "VC",
  "VE",
  "VG",
  "VI",
  "VN",
  "VU",
  "WF",
  "WS",
  "XK",
  "YE",
  "YT",
  "ZA",
  "ZM",
  "ZW"
].map((code) => ({ code, label: regionNames.of(code) })).sort((a, b) => a.label.localeCompare(b.label));

// src/deploymentsSlice/constants.ts
var alreadyInstalled = "already-installed";
var deploymentSubstates = {
  aborted: "aborted",
  alreadyInstalled,
  decommissioned: "decommissioned",
  downloading: "downloading",
  failure: "failure",
  installing: "installing",
  noartifact: "noartifact",
  pause_before_committing: "pause_before_committing",
  pause_before_installing: "pause_before_installing",
  pause_before_rebooting: "pause_before_rebooting",
  pending: "pending",
  rebooting: "rebooting",
  success: "success"
};
var deploymentStatesToSubstates = {
  failures: [deploymentSubstates.failure, deploymentSubstates.aborted, deploymentSubstates.decommissioned],
  inprogress: [deploymentSubstates.downloading, deploymentSubstates.installing, deploymentSubstates.rebooting],
  paused: [deploymentSubstates.pause_before_installing, deploymentSubstates.pause_before_rebooting, deploymentSubstates.pause_before_committing],
  pending: [deploymentSubstates.pending],
  successes: [deploymentSubstates.success, deploymentSubstates.alreadyInstalled, deploymentSubstates.noartifact]
};
var deploymentStatesToSubstatesWithSkipped = {
  ...deploymentStatesToSubstates,
  failures: [deploymentSubstates.failure],
  skipped: [deploymentSubstates.aborted, deploymentSubstates.noartifact, deploymentSubstates.alreadyInstalled, deploymentSubstates.decommissioned],
  successes: [deploymentSubstates.success]
};
var installationSubstatesMap = {
  download: {
    title: "download",
    done: "downloaded",
    successIndicators: [deploymentSubstates.installing, deploymentSubstates.rebooting, ...deploymentStatesToSubstates.paused, deploymentSubstates.success],
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: "ArtifactInstall_Enter"
  },
  install: {
    title: "install",
    done: "installed",
    successIndicators: [
      deploymentSubstates.rebooting,
      deploymentSubstates.pause_before_rebooting,
      deploymentSubstates.pause_before_committing,
      deploymentSubstates.success
    ],
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: "ArtifactReboot_Enter"
  },
  reboot: {
    title: "reboot",
    done: "rebooted",
    successIndicators: [deploymentSubstates.pause_before_committing, deploymentSubstates.success],
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: "ArtifactCommit_Enter"
  },
  commit: {
    title: "commit",
    done: "committed",
    successIndicators: deploymentStatesToSubstates.successes,
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: void 0
  }
};
var DEPLOYMENT_STATES = {
  finished: "finished",
  inprogress: "inprogress",
  pending: "pending",
  scheduled: "scheduled"
};
var listDefaultsByState = {
  [DEPLOYMENT_STATES.inprogress]: { page: 1, perPage: 10 },
  [DEPLOYMENT_STATES.pending]: { page: 1, perPage: 10 },
  [DEPLOYMENT_STATES.scheduled]: { ...import_constants3.DEVICE_LIST_DEFAULTS },
  [DEPLOYMENT_STATES.finished]: { ...import_constants3.DEVICE_LIST_DEFAULTS },
  sort: { direction: import_constants3.SORTING_OPTIONS.desc }
};
var DEFAULT_PENDING_INPROGRESS_COUNT = 10;
var DEPLOYMENT_ROUTES = {
  active: {
    key: "active",
    route: "/deployments/active",
    states: [DEPLOYMENT_STATES.pending, DEPLOYMENT_STATES.inprogress],
    title: "Active"
  },
  finished: {
    key: "finished",
    route: "/deployments/finished",
    states: [DEPLOYMENT_STATES.finished],
    title: "Finished"
  },
  scheduled: {
    key: "scheduled",
    route: "/deployments/scheduled",
    states: [DEPLOYMENT_STATES.scheduled],
    title: "Scheduled"
  }
};
var defaultStats = {
  [deploymentSubstates.aborted]: 0,
  [deploymentSubstates.alreadyInstalled]: 0,
  [deploymentSubstates.decommissioned]: 0,
  [deploymentSubstates.downloading]: 0,
  [deploymentSubstates.failure]: 0,
  [deploymentSubstates.installing]: 0,
  [deploymentSubstates.noartifact]: 0,
  [deploymentSubstates.pause_before_committing]: 0,
  [deploymentSubstates.pause_before_installing]: 0,
  [deploymentSubstates.pause_before_rebooting]: 0,
  [deploymentSubstates.pending]: 0,
  [deploymentSubstates.rebooting]: 0,
  [deploymentSubstates.success]: 0
};
var deploymentPrototype = {
  devices: {},
  name: void 0,
  statistics: { status: {} }
};
var pauseMap = {
  [deploymentSubstates.pause_before_installing]: {
    title: installationSubstatesMap.download.done,
    followUp: installationSubstatesMap.download.pauseConfigurationIndicator
  },
  [deploymentSubstates.pause_before_rebooting]: {
    title: installationSubstatesMap.install.done,
    followUp: installationSubstatesMap.install.pauseConfigurationIndicator
  },
  [deploymentSubstates.pause_before_committing]: {
    title: installationSubstatesMap.reboot.done,
    followUp: installationSubstatesMap.reboot.pauseConfigurationIndicator
  }
};

// src/onboardingSlice/constants.ts
var onboardingSteps = {
  ONBOARDING_START: "onboarding-start",
  DEVICES_PENDING_ONBOARDING_START: "devices-pending-onboarding-start",
  DASHBOARD_ONBOARDING_START: "dashboard-onboarding-start",
  DASHBOARD_ONBOARDING_PENDINGS: "dashboard-onboarding-pendings",
  DEVICES_DELAYED_ONBOARDING: "devices-delayed-onboarding",
  DEVICES_PENDING_ONBOARDING: "devices-pending-onboarding",
  DEVICES_ACCEPTED_ONBOARDING: "devices-accepted-onboarding",
  DEVICES_PENDING_ACCEPTING_ONBOARDING: "devices-pending-accepting-onboarding",
  DEVICES_DEPLOY_RELEASE_ONBOARDING: "devices-deploy-release-onboarding",
  SCHEDULING_ARTIFACT_SELECTION: "scheduling-artifact-selection",
  SCHEDULING_ALL_DEVICES_SELECTION: "scheduling-all-devices-selection",
  SCHEDULING_GROUP_SELECTION: "scheduling-group-selection",
  SCHEDULING_RELEASE_TO_DEVICES: "scheduling-release-to-devices",
  DEPLOYMENTS_INPROGRESS: "deployments-inprogress",
  DEPLOYMENTS_COMPLETED: "deployments-completed",
  DEPLOYMENTS_PAST: "deployments-past",
  DEPLOYMENTS_PAST_COMPLETED: "deployments-past-completed",
  DEPLOYMENTS_PAST_COMPLETED_FAILURE: "deployments-past-completed-failure",
  ONBOARDING_CANCELED: "onboarding-canceled"
};
var orderedOnboardingSteps = [
  onboardingSteps.DASHBOARD_ONBOARDING_START,
  onboardingSteps.DEVICES_PENDING_ONBOARDING_START,
  onboardingSteps.DEVICES_DELAYED_ONBOARDING,
  onboardingSteps.DEVICES_PENDING_ONBOARDING,
  onboardingSteps.DEVICES_PENDING_ACCEPTING_ONBOARDING,
  onboardingSteps.DASHBOARD_ONBOARDING_PENDINGS,
  onboardingSteps.DEVICES_ACCEPTED_ONBOARDING,
  onboardingSteps.DEVICES_DEPLOY_RELEASE_ONBOARDING,
  onboardingSteps.SCHEDULING_ALL_DEVICES_SELECTION,
  onboardingSteps.SCHEDULING_GROUP_SELECTION,
  onboardingSteps.SCHEDULING_ARTIFACT_SELECTION,
  onboardingSteps.SCHEDULING_RELEASE_TO_DEVICES,
  onboardingSteps.DEPLOYMENTS_INPROGRESS,
  onboardingSteps.DEPLOYMENTS_PAST,
  onboardingSteps.DEPLOYMENTS_PAST_COMPLETED,
  onboardingSteps.DEPLOYMENTS_PAST_COMPLETED_FAILURE,
  onboardingSteps.ONBOARDING_CANCELED
];

// src/organizationSlice/constants.ts
var auditlogTypes = {
  artifact: { title: "Artifact", queryParameter: "object_type", value: "artifact" },
  deployment: { title: "Deployment", queryParameter: "object_deployment_name", value: "deployment" },
  device: { title: "Device", queryParameter: "object_id", value: "device" },
  user_access_token: { title: "Personal Access Token", queryParameter: "user_access_token", value: "user_access_token" },
  user: { title: "User", queryParameter: "object_id", value: "user" },
  tenant: { title: "Tenant", queryParameter: "object_id", value: "tenant" }
};
var AUDIT_LOGS_TYPES = [auditlogTypes.artifact, auditlogTypes.deployment, auditlogTypes.device, auditlogTypes.user_access_token, auditlogTypes.user];
var SP_AUDIT_LOGS_TYPES = [auditlogTypes.user, auditlogTypes.tenant];
var TENANT_LIST_DEFAULT = {
  page: 1,
  perPage: 20
};

// src/usersSlice/constants.ts
var USER_LOGOUT = "USER_LOGOUT";
var settingsKeys = { initialized: "settings-initialized" };
var READ_STATES = {
  read: "read",
  seen: "seen",
  unread: "unread"
};

// src/monitorSlice/index.ts
var sliceName = "monitor";
var initialState = {
  alerts: {
    alertList: { ...import_constants3.DEVICE_LIST_DEFAULTS, total: 0 },
    byDeviceId: {}
  },
  issueCounts: {
    byType: Object.keys(import_constants3.DEVICE_ISSUE_OPTIONS).reduce((accu, key) => ({ ...accu, [key]: { filtered: 0, total: 0 } }), {})
  },
  settings: {
    global: {
      channels: {
        ...Object.keys(import_constants3.alertChannels).reduce((accu, item) => ({ ...accu, [item]: { enabled: true } }), {})
      }
    }
  }
};
var monitorSlice = (0, import_toolkit.createSlice)({
  name: sliceName,
  initialState,
  reducers: {
    changeAlertChannel: (state, action) => {
      const { channel, enabled } = action.payload;
      state.settings.global.channels[channel] = { enabled };
    },
    receiveDeviceAlerts: (state, action) => {
      const { deviceId, alerts } = action.payload;
      state.alerts.byDeviceId[deviceId] = { alerts };
    },
    receiveLatestDeviceAlerts: (state, action) => {
      const { deviceId, alerts } = action.payload;
      state.alerts.byDeviceId[deviceId] = { ...state.alerts.byDeviceId[deviceId], latest: alerts };
    },
    receiveDeviceIssueCounts: (state, action) => {
      const { issueType, counts } = action.payload;
      state.issueCounts.byType[issueType] = counts;
    },
    setAlertListState: (state, action) => {
      state.alerts.alertList = { ...state.alerts.alertList, ...action.payload };
    }
  }
});
var actions = monitorSlice.actions;
var monitorSlice_default = monitorSlice.reducer;

// src/appSlice/index.ts
var import_toolkit2 = require("@reduxjs/toolkit");
var sliceName2 = "app";
var getYesterday = () => {
  const today = /* @__PURE__ */ new Date();
  today.setDate(today.getDate() - 1);
  return today.toISOString();
};
var initialState2 = {
  cancelSource: void 0,
  commit: "",
  demoArtifactLink: "https://dgsbl4vditpls.cloudfront.net/mender-demo-artifact.mender",
  hostAddress: null,
  snackbar: {
    action: void 0,
    autoHideDuration: void 0,
    message: "",
    open: false,
    preventClickToCopy: false
  },
  // return boolean rather than organization details
  features: {
    hasAuditlogs: false,
    hasDeltaProgress: false,
    hasMultitenancy: false,
    hasDeviceConfig: false,
    hasDeviceConnect: false,
    hasFeedbackEnabled: false,
    hasMonitor: false,
    hasReporting: false,
    isHosted: true,
    isEnterprise: false
  },
  feedbackProbability: 0.3,
  firstLoginAfterSignup: false,
  hostedAnnouncement: "",
  docsVersion: "",
  recaptchaSiteKey: "",
  searchState: {
    deviceIds: [],
    searchTerm: "",
    searchTotal: 0,
    isSearching: false,
    sort: {
      direction: import_constants3.SORTING_OPTIONS.desc
      // key: null,
      // scope: null
    }
  },
  sentry: {
    location: "",
    replaysSessionSampleRate: 0.1,
    tracesSampleRate: 1
  },
  stripeAPIKey: "",
  trackerCode: "",
  uploadsById: {
    // id: { progress: 0, cancelSource: undefined }
  },
  newThreshold: getYesterday(),
  offlineThreshold: getYesterday(),
  versionInformation: {
    Integration: "",
    "Mender-Client": "",
    "Mender-Artifact": "",
    "Meta-Mender": ""
  },
  yesterday: void 0
};
var appSlice = (0, import_toolkit2.createSlice)({
  name: sliceName2,
  initialState: initialState2,
  reducers: {
    setFeatures: (state, action) => {
      state.features = {
        ...state.features,
        ...action.payload
      };
    },
    setSnackbar: (state, { payload }) => {
      if (typeof payload === "string" || payload instanceof String) {
        state.snackbar = {
          ...initialState2.snackbar,
          message: payload,
          open: !!payload
        };
        return;
      }
      const { message, autoHideDuration, action, preventClickToCopy = false } = payload;
      state.snackbar = {
        message,
        autoHideDuration,
        action,
        preventClickToCopy,
        open: !!message
      };
    },
    setFirstLoginAfterSignup: (state, action) => {
      state.firstLoginAfterSignup = action.payload;
    },
    setAnnouncement: (state, action) => {
      state.hostedAnnouncement = action.payload;
    },
    setSearchState: (state, action) => {
      state.searchState = {
        ...state.searchState,
        ...action.payload
      };
    },
    setOfflineThreshold: (state, action) => {
      state.offlineThreshold = action.payload;
    },
    initUpload: (state, action) => {
      const { id, upload } = action.payload;
      state.uploadsById[id] = upload;
    },
    uploadProgress: (state, action) => {
      const { id, progress } = action.payload;
      state.uploadsById[id] = {
        ...state.uploadsById[id],
        progress
      };
    },
    cleanUpUpload: (state, action) => {
      const { [action.payload]: current, ...remainder } = state.uploadsById;
      state.uploadsById = remainder;
    },
    setVersionInformation: (state, action) => {
      state.versionInformation = {
        ...state.versionInformation,
        ...action.payload
      };
    },
    setEnvironmentData: (state, action) => ({ ...state, ...action.payload })
  }
});
var actions2 = appSlice.actions;
var appSlice_default = appSlice.reducer;

// src/deploymentsSlice/index.ts
var import_toolkit3 = require("@reduxjs/toolkit");
var sliceName3 = "deployments";
var initialState3 = {
  byId: {
    // [id]: { statistics: { status: {}, total_size }, devices: { [deploymentId]: { id, log } }, totalDeviceCount }
  },
  byStatus: {
    finished: { deploymentIds: [], total: 0 },
    inprogress: { deploymentIds: [], total: 0 },
    pending: { deploymentIds: [], total: 0 },
    scheduled: { deploymentIds: [], total: 0 }
  },
  config: {
    binaryDelta: {
      timeout: -1,
      duplicatesWindow: -1,
      compressionLevel: -1,
      disableChecksum: false,
      disableDecompression: false,
      inputWindow: -1,
      instructionBuffer: -1,
      sourceWindow: -1
    },
    binaryDeltaLimits: {
      timeout: { ...import_constants3.limitDefault, default: 60, max: 3600, min: 60 },
      sourceWindow: import_constants3.limitDefault,
      inputWindow: import_constants3.limitDefault,
      duplicatesWindow: import_constants3.limitDefault,
      instructionBuffer: import_constants3.limitDefault
    }
  },
  deploymentDeviceLimit: 5e3,
  selectedDeviceIds: [],
  selectionState: {
    finished: { ...import_constants3.DEVICE_LIST_DEFAULTS, endDate: void 0, search: "", selection: [], startDate: void 0, total: 0, type: "" },
    inprogress: { ...import_constants3.DEVICE_LIST_DEFAULTS, perPage: DEFAULT_PENDING_INPROGRESS_COUNT, selection: [] },
    pending: { ...import_constants3.DEVICE_LIST_DEFAULTS, perPage: DEFAULT_PENDING_INPROGRESS_COUNT, selection: [] },
    scheduled: { ...import_constants3.DEVICE_LIST_DEFAULTS, selection: [] },
    general: {
      state: DEPLOYMENT_ROUTES.active.key,
      showCreationDialog: false,
      showReportDialog: false,
      reportType: null
      // DeploymentConstants.DEPLOYMENT_TYPES.configuration|DeploymentConstants.DEPLOYMENT_TYPES.software
    },
    selectedId: void 0
  }
};
var deploymentsSlice = (0, import_toolkit3.createSlice)({
  name: sliceName3,
  initialState: initialState3,
  reducers: {
    createdDeployment: (state, action) => {
      state.byId[action.payload.id] = {
        ...deploymentPrototype,
        ...action.payload
      };
      state.byStatus[DEPLOYMENT_STATES.pending].total = state.byStatus[DEPLOYMENT_STATES.pending].total + 1;
      state.byStatus[DEPLOYMENT_STATES.pending].deploymentIds = [...state.byStatus.pending.deploymentIds, action.payload.id];
      state.selectionState[DEPLOYMENT_STATES.pending].selection = [action.payload.id, ...state.selectionState[DEPLOYMENT_STATES.pending].selection];
      state.selectionState[DEPLOYMENT_STATES.pending].total = (state.selectionState[DEPLOYMENT_STATES.pending].total || 0) + 1;
    },
    removedDeployment: (state, action) => {
      const { [action.payload]: removedDeployment, ...remainder } = state.byId;
      state.byId = remainder;
    },
    receivedDeployment: (state, action) => {
      state.byId[action.payload.id] = {
        ...state.byId[action.payload.id] || {},
        ...action.payload
      };
    },
    receivedDeploymentDeviceLog: (state, action) => {
      const { id, deviceId, log } = action.payload;
      const deployment = {
        ...deploymentPrototype,
        ...state.byId[id]
      };
      state.byId[id] = {
        ...deployment,
        devices: {
          ...deployment.devices,
          [deviceId]: {
            ...deployment.devices[deviceId],
            log
          }
        }
      };
    },
    receivedDeploymentDevices: (state, action) => {
      const { id, devices, selectedDeviceIds, totalDeviceCount } = action.payload;
      state.byId[id] = {
        ...state.byId[id],
        devices,
        totalDeviceCount
      };
      state.selectedDeviceIds = selectedDeviceIds;
    },
    receivedDeployments: (state, action) => {
      state.byId = {
        ...state.byId,
        ...action.payload
      };
    },
    receivedDeploymentsForStatus: (state, action) => {
      const { status, deploymentIds, total } = action.payload;
      state.byStatus[status].deploymentIds = deploymentIds;
      state.byStatus[status].total = total;
    },
    selectDeploymentsForStatus: (state, action) => {
      const { status, deploymentIds, total } = action.payload;
      state.selectionState[status].selection = deploymentIds;
      state.selectionState[status].total = total;
    },
    setDeploymentsState: (state, action) => {
      state.selectionState = action.payload;
    },
    setDeploymentsConfig: (state, action) => {
      state.config = action.payload;
    }
  }
});
var actions3 = deploymentsSlice.actions;
var deploymentsSlice_default = deploymentsSlice.reducer;

// src/devicesSlice/index.ts
var import_helpers = require("@northern.tech/utils/helpers");
var import_toolkit4 = require("@reduxjs/toolkit");
var sliceName4 = "devices";
var initialState4 = {
  byId: {
    // [deviceId]: {
    //   ...,
    //   twinsByIntegration: { [external.provider.id]: twinData }
    // }
  },
  byStatus: {
    [import_constants3.DEVICE_STATES.accepted]: { deviceIds: [], total: 0 },
    active: { deviceIds: [], total: 0 },
    inactive: { deviceIds: [], total: 0 },
    [import_constants3.DEVICE_STATES.pending]: { deviceIds: [], total: 0 },
    [import_constants3.DEVICE_STATES.preauth]: { deviceIds: [], total: 0 },
    [import_constants3.DEVICE_STATES.rejected]: { deviceIds: [], total: 0 }
  },
  deviceList: {
    deviceIds: [],
    ...import_constants3.DEVICE_LIST_DEFAULTS,
    selectedAttributes: [],
    selectedIssues: [],
    selection: [],
    sort: {
      direction: import_constants3.SORTING_OPTIONS.desc
      // key: null,
      // scope: null
    },
    state: import_constants3.DEVICE_STATES.accepted,
    total: 0,
    refreshTrigger: false,
    isLoading: false,
    detailsTab: "",
    open: false
  },
  filters: [
    // { key: 'device_type', value: 'raspberry', operator: '$eq', scope: 'inventory' }
  ],
  filteringAttributes: { identityAttributes: [], inventoryAttributes: [], systemAttributes: [], tagAttributes: [] },
  filteringAttributesLimit: 10,
  filteringAttributesConfig: {
    attributes: {
      // inventory: ['some_attribute']
    },
    count: 0,
    limit: 100
  },
  reports: [
    // { items: [{ key: "someKey", count: 42  }], otherCount: 123, total: <otherCount + itemsCount> }
  ],
  total: 0,
  limit: 0,
  groups: {
    byId: {
      // groupName: { deviceIds: [], total: 0, filters: [] },
      // dynamo: { deviceIds: [], total: 3, filters: [{ a: 1 }] }
    },
    selectedGroup: void 0
  }
};
var devicesSlice = (0, import_toolkit4.createSlice)({
  name: sliceName4,
  initialState: initialState4,
  reducers: {
    receivedGroups: (state, action) => {
      state.groups.byId = action.payload;
    },
    addToGroup: (state, action) => {
      const { group, deviceIds } = action.payload;
      const maybeExistingGroup = {
        filters: [],
        deviceIds: [],
        ...state.groups.byId[group]
      };
      state.groups.byId[group] = {
        ...maybeExistingGroup,
        deviceIds: [...maybeExistingGroup.deviceIds, ...deviceIds].filter(import_helpers.duplicateFilter),
        total: (maybeExistingGroup.total || 0) + 1
      };
    },
    removeFromGroup: (state, action) => {
      const { group, deviceIds: removedIds } = action.payload;
      const { deviceIds = [], total = 0, ...maybeExistingGroup } = state.groups.byId[group] || {};
      const changedGroup = {
        ...maybeExistingGroup,
        deviceIds: deviceIds.filter((id) => !removedIds.includes(id)),
        total: Math.max(total - removedIds.length, 0)
      };
      if (changedGroup.total || changedGroup.deviceIds.length) {
        state.groups.byId[group] = changedGroup;
        return;
      } else if (state.groups.selectedGroup === group) {
        state.groups.selectedGroup = void 0;
      }
      const { [group]: removal, ...remainingById } = state.groups.byId;
      state.groups.byId = remainingById;
    },
    addGroup: (state, action) => {
      const { groupName, group } = action.payload;
      state.groups.byId[groupName] = {
        ...state.groups.byId[groupName],
        ...group
      };
    },
    selectGroup: (state, { payload: group }) => {
      state.deviceList.deviceIds = group && state.groups.byId[group] && state.groups.byId[group].deviceIds && state.groups.byId[group].deviceIds.length > 0 ? state.groups.byId[group].deviceIds : [];
      state.groups.selectedGroup = group;
    },
    removeGroup: (state, action) => {
      const { [action.payload]: removal, ...remainingById } = state.groups.byId;
      state.groups.byId = remainingById;
      state.groups.selectedGroup = state.groups.selectedGroup === action.payload ? void 0 : state.groups.selectedGroup;
    },
    setDeviceListState: (state, action) => {
      state.deviceList = {
        ...state.deviceList,
        ...action.payload,
        sort: {
          ...state.deviceList.sort,
          ...action.payload.sort
        }
      };
    },
    setFilterAttributes: (state, action) => {
      state.filteringAttributes = action.payload;
    },
    setFilterablesConfig: (state, action) => {
      state.filteringAttributesConfig = action.payload;
    },
    receivedDevices: (state, action) => {
      state.byId = {
        ...state.byId,
        ...action.payload
      };
    },
    setDeviceFilters: (state, action) => {
      if ((0, import_helpers.deepCompare)(action.payload, state.filters)) {
        return;
      }
      state.filters = action.payload.filter((filter) => filter.key && filter.operator && filter.scope && typeof filter.value !== "undefined");
    },
    setInactiveDevices: (state, action) => {
      const { activeDeviceTotal, inactiveDeviceTotal } = action.payload;
      state.byStatus.active.total = activeDeviceTotal;
      state.byStatus.inactive.total = inactiveDeviceTotal;
    },
    setDeviceReports: (state, action) => {
      state.reports = action.payload;
    },
    setDevicesByStatus: (state, action) => {
      const { forceUpdate, status, total, deviceIds } = action.payload;
      state.byStatus[status] = total || forceUpdate ? { deviceIds, total } : state.byStatus[status];
    },
    setDevicesCountByStatus: (state, action) => {
      const { count, status } = action.payload;
      state.byStatus[status].total = count;
    },
    setDeviceLimit: (state, action) => {
      state.limit = action.payload;
    },
    receivedDevice: (state, action) => {
      state.byId[action.payload.id] = {
        ...state.byId[action.payload.id],
        ...action.payload
      };
    },
    maybeUpdateDevicesByStatus: (state, action) => {
      const { deviceId, authId } = action.payload;
      const device = state.byId[deviceId];
      const hasMultipleAuthSets = authId && device.auth_sets ? device.auth_sets.filter((authset) => authset.id !== authId).length > 0 : false;
      if (!hasMultipleAuthSets && Object.values(import_constants3.DEVICE_STATES).includes(device.status)) {
        const deviceIds = state.byStatus[device.status].deviceIds.filter((id) => id !== deviceId);
        state.byStatus[device.status] = { deviceIds, total: Math.max(0, state.byStatus[device.status].total - 1) };
      }
    }
  }
});
var actions4 = devicesSlice.actions;
var devicesSlice_default = devicesSlice.reducer;

// src/onboardingSlice/index.ts
var import_toolkit5 = require("@reduxjs/toolkit");
var sliceName5 = "onboarding";
var initialState5 = {
  approach: null,
  complete: false,
  deviceType: null,
  demoArtifactPort: 85,
  progress: null,
  showTips: null,
  showTipsDialog: false
};
var onboardingSlice = (0, import_toolkit5.createSlice)({
  name: sliceName5,
  initialState: initialState5,
  reducers: {
    setOnboardingState: (state, action) => ({ ...state, ...action.payload }),
    setDemoArtifactPort: (state, action) => {
      state.demoArtifactPort = action.payload;
    },
    setShowOnboardingHelp: (state, action) => {
      state.showTips = action.payload;
    },
    setShowDismissOnboardingTipsDialog: (state, action) => {
      state.showTipsDialog = action.payload;
    },
    setOnboardingComplete: (state, action) => {
      state.complete = action.payload;
    },
    setOnboardingProgress: (state, action) => {
      state.progress = action.payload;
    },
    setOnboardingDeviceType: (state, action) => {
      state.deviceType = action.payload;
    },
    setOnboardingApproach: (state, action) => {
      state.approach = action.payload;
    }
  }
});
var actions5 = onboardingSlice.actions;
var onboardingSlice_default = onboardingSlice.reducer;

// src/organizationSlice/index.ts
var import_toolkit6 = require("@reduxjs/toolkit");
var sliceName6 = "organization";
var initialState6 = {
  card: {
    last4: "",
    expiration: { month: 1, year: 2020 },
    brand: ""
  },
  intentId: null,
  tenantList: {
    ...TENANT_LIST_DEFAULT,
    total: 0,
    tenants: [],
    selectedTenant: null,
    sort: {
      direction: import_constants3.SORTING_OPTIONS.desc,
      key: "name"
    }
  },
  organization: {
    // id, name, status, tenant_token, plan
  },
  auditlog: {
    events: [],
    selectionState: {
      ...import_constants3.DEVICE_LIST_DEFAULTS,
      detail: void 0,
      endDate: void 0,
      selectedIssue: void 0,
      sort: { direction: import_constants3.SORTING_OPTIONS.desc },
      startDate: void 0,
      total: 0,
      type: void 0,
      user: void 0,
      isLoading: false
    }
  },
  externalDeviceIntegrations: [
    // { <connection_string|x509|...>, id, provider }
  ],
  ssoConfigs: [],
  webhooks: {
    // [id]: { events: [] }
    // for now:
    events: [],
    eventsTotal: 0
  }
};
var organizationSlice = (0, import_toolkit6.createSlice)({
  name: sliceName6,
  initialState: initialState6,
  reducers: {
    receiveAuditLogs: (state, action) => {
      const { events, total } = action.payload;
      state.auditlog.events = events;
      state.auditlog.selectionState.total = total;
    },
    setAuditLogState: (state, action) => {
      state.auditlog.selectionState = {
        ...state.auditlog.selectionState,
        ...action.payload
      };
    },
    receiveCurrentCard: (state, action) => {
      state.card = action.payload;
    },
    receiveSetupIntent: (state, action) => {
      state.intentId = action.payload;
    },
    setOrganization: (state, action) => {
      state.organization = { ...state.organization, ...action.payload };
    },
    setSubscription: (state, action) => {
      state.organization.subscription = { ...state.organization.subscription, ...action.payload };
    },
    setBillingProfile: (state, action) => {
      state.organization.billing_profile = action.payload;
    },
    setTenantListState: (state, action) => {
      state.tenantList = action.payload;
    },
    receiveExternalDeviceIntegrations: (state, action) => {
      state.externalDeviceIntegrations = action.payload;
    },
    receiveSsoConfigs: (state, action) => {
      state.ssoConfigs = action.payload;
    },
    receiveWebhookEvents: (state, action) => {
      const { value, total } = action.payload;
      state.webhooks.events = value;
      state.webhooks.eventsTotal = total;
    }
  }
});
var actions6 = organizationSlice.actions;
var organizationSlice_default = organizationSlice.reducer;

// src/releasesSlice/index.ts
var import_toolkit7 = require("@reduxjs/toolkit");
var sliceName7 = "releases";
var initialState7 = {
  /*
   * Return list of saved artifacts objects
   */
  /*
   * return list of artifacts where duplicate names are collated with device compatibility lists combined
   */
  // artifacts: AppStore.getCollatedArtifacts(AppStore.getArtifactsRepo()),
  artifacts: [],
  /*
   * Return list of saved release objects
   */
  byId: {
    /*
    [releaseName]: {
      artifacts: [
        {
          id: '',
          name: '',
          description: '',
          device_types_compatible: [],
          ...
          updates: [{
            files: [
              { size: 123, name: '' }
            ],
            type_info: { type: '' }
          }],
          url: '' // optional
        }
      ],
      modified: ''
      device_types_compatible,
      name: '',
      tags: ['something'],
      notes: ''
    }
    */
  },
  releasesList: {
    ...import_constants3.DEVICE_LIST_DEFAULTS,
    searchedIds: [],
    releaseIds: [],
    selection: [],
    sort: {
      direction: import_constants3.SORTING_OPTIONS.desc,
      key: "modified"
    },
    isLoading: void 0,
    searchTerm: "",
    searchTotal: 0,
    selectedTags: [],
    total: 0,
    type: ""
  },
  tags: [],
  updateTypes: [],
  /*
   * Return single release with corresponding Artifacts
   */
  selectedRelease: null
};
var releaseSlice = (0, import_toolkit7.createSlice)({
  name: sliceName7,
  initialState: initialState7,
  reducers: {
    receiveRelease: (state, action) => {
      const { name } = action.payload;
      state.byId[name] = action.payload;
    },
    receiveReleases: (state, action) => {
      state.byId = action.payload;
    },
    receiveReleaseTags: (state, action) => {
      state.tags = action.payload;
    },
    receiveReleaseTypes: (state, action) => {
      state.updateTypes = action.payload;
    },
    removeRelease: (state, action) => {
      const { [action.payload]: toBeRemoved, ...byId } = state.byId;
      state.byId = byId;
      state.selectedRelease = action.payload === state.selectedRelease ? null : state.selectedRelease;
    },
    selectedRelease: (state, action) => {
      state.selectedRelease = action.payload;
    },
    setReleaseListState: (state, action) => {
      state.releasesList = action.payload;
    }
  }
});
var actions7 = releaseSlice.actions;
var releasesSlice_default = releaseSlice.reducer;

// src/usersSlice/index.ts
var import_toolkit8 = require("@reduxjs/toolkit");
var sliceName8 = "users";
var initialState8 = {
  activationCode: void 0,
  byId: {},
  currentUser: null,
  currentSession: {
    // { token: window.localStorage.getItem('JWT'), expiresAt: '2023-01-01T00:15:00.000Z' | undefined }, // expiresAt depending on the stay logged in setting
  },
  customColumns: [],
  qrCode: null,
  globalSettings: {
    id_attribute: void 0,
    previousFilters: [],
    previousPhases: [],
    retries: 0
  },
  permissionSetsById: {
    ...import_constants3.defaultPermissionSets
  },
  rolesById: {
    ...import_constants3.rolesById
  },
  rolesInitialized: false,
  settingsInitialized: false,
  showConnectDeviceDialog: false,
  showFeedbackDialog: false,
  showStartupNotification: false,
  tooltips: {
    byId: {
      // <id>: { readState: <read|unread> } // this object is getting enhanced by the tooltip texts in the app constants
    }
  },
  userSettings: {
    columnSelection: [],
    onboarding: {}
  },
  userSettingsInitialized: false
};
var usersSlice = (0, import_toolkit8.createSlice)({
  name: sliceName8,
  initialState: initialState8,
  reducers: {
    receivedQrCode: (state, action) => {
      state.qrCode = action.payload;
    },
    successfullyLoggedIn: (state, action) => {
      state.currentSession = action.payload;
    },
    receivedUserList: (state, action) => {
      state.byId = action.payload;
    },
    receivedActivationCode: (state, action) => {
      state.activationCode = action.payload;
    },
    receivedUser: (state, action) => {
      state.byId[action.payload.id] = action.payload;
      state.currentUser = action.payload.id;
    },
    removedUser: (state, action) => {
      const { [action.payload]: removedUser, ...byId } = state.byId;
      state.byId = byId;
      state.currentUser = state.currentUser === action.payload ? null : state.currentUser;
    },
    updatedUser: (state, action) => {
      state.byId[action.payload.id] = {
        ...state.byId[action.payload.id],
        ...action.payload
      };
    },
    receivedPermissionSets: (state, action) => {
      state.permissionSetsById = action.payload;
    },
    receivedRoles: (state, action) => {
      state.rolesById = action.payload;
      state.rolesInitialized = true;
    },
    finishedRoleInitialization: (state, action) => {
      state.rolesInitialized = action.payload;
    },
    createdRole: (state, action) => {
      state.rolesById[action.payload.name] = {
        ...state.rolesById[action.payload.name],
        ...action.payload
      };
    },
    removedRole: (state, action) => {
      const { [action.payload]: toBeRemoved, ...rolesById2 } = state.rolesById;
      state.rolesById = rolesById2;
    },
    setCustomColumns: (state, action) => {
      state.customColumns = action.payload;
    },
    setGlobalSettings: (state, action) => {
      state.settingsInitialized = true;
      state.globalSettings = {
        ...state.globalSettings,
        ...action.payload
      };
    },
    setUserSettings: (state, action) => {
      state.userSettingsInitialized = true;
      state.userSettings = {
        ...state.userSettings,
        ...action.payload
      };
    },
    setTooltipState: (state, action) => {
      const { id, readState = READ_STATES.read } = action.payload;
      state.tooltips.byId[id] = { ...state.tooltips.byId[id], readState };
    },
    setTooltipsState: (state, action) => {
      state.tooltips.byId = {
        ...state.tooltips.byId,
        ...action.payload
      };
    },
    setShowFeedbackDialog: (state, action) => {
      state.showFeedbackDialog = action.payload;
    },
    setShowConnectingDialog: (state, action) => {
      state.showConnectDeviceDialog = action.payload;
    },
    setShowStartupNotification: (state, action) => {
      state.showStartupNotification = action.payload;
    }
  }
});
var actions8 = usersSlice.actions;
var usersSlice_default = usersSlice.reducer;

// src/actions.ts
var actions_default = {
  ...actions2,
  ...actions3,
  ...actions4,
  ...actions,
  ...actions5,
  ...actions6,
  ...actions7,
  ...actions8
};

// src/api/general-api.ts
var import_axios = __toESM(require("axios"), 1);

// src/auth.ts
var import_universal_cookie = __toESM(require("universal-cookie"), 1);
var cookies = new import_universal_cookie.default();
var emptySession = Object.freeze({ token: "", expiresAt: void 0 });
var tokenCache = "";
var getSessionInfo = () => {
  let sessionInfo = { ...emptySession };
  try {
    sessionInfo = JSON.parse(window.localStorage.getItem("JWT") ?? "");
  } catch {
  }
  if (sessionInfo.expiresAt && new Date(sessionInfo.expiresAt) < /* @__PURE__ */ new Date()) {
    cleanUp();
    return { ...emptySession };
  }
  if (!sessionInfo.token) {
    const jwtTokenFromCookie = cookies.get("JWT", { doNotParse: true }) ?? "";
    if (jwtTokenFromCookie) {
      setSessionInfo({ token: jwtTokenFromCookie });
      sessionInfo.token = jwtTokenFromCookie;
      cookies.remove("JWT");
      cookies.remove("JWT", { path: "/" });
    }
  }
  sessionInfo.token = sessionInfo.token || "";
  tokenCache = sessionInfo.token;
  return sessionInfo;
};
var getToken = () => tokenCache ? tokenCache : getSessionInfo().token;
var setSessionInfo = ({ token, expiresAt }) => {
  tokenCache = token;
  window.localStorage.setItem("JWT", JSON.stringify({ token, expiresAt }));
};
var cleanUp = () => {
  tokenCache = "";
  cookies.remove("JWT");
  cookies.remove("JWT", { path: "/" });
  window.localStorage.removeItem("JWT");
  window.localStorage.removeItem("oauth");
};

// src/api/general-api.ts
var unauthorizedRedirect = (error) => {
  if (!(0, import_axios.isCancel)(error) && error.response?.status === 401 && getToken()) {
    cleanUp();
    window.location.replace("/ui/");
  }
  return Promise.reject(error);
};
var commonRequestConfig = { timeout: TIMEOUTS.refreshDefault, headers: { "Content-Type": "application/json" } };
var authenticatedRequest = import_axios.default.create(commonRequestConfig);
authenticatedRequest.interceptors.response.use((res) => res, unauthorizedRedirect);
authenticatedRequest.interceptors.request.use(
  (config) => ({ ...config, headers: { ...config.headers, Authorization: `Bearer ${getToken()}` } }),
  (error) => Promise.reject(error)
);
var Api = {
  get: authenticatedRequest.get,
  delete: (url, data) => authenticatedRequest.request({ method: "delete", url, data }),
  patch: authenticatedRequest.patch,
  post: authenticatedRequest.post,
  postUnauthorized: (url, data, config = {}) => import_axios.default.post(url, data, { ...commonRequestConfig, ...config }),
  put: authenticatedRequest.put,
  upload: (url, formData, progress, cancelSignal) => authenticatedRequest.post(url, formData, {
    headers: { "Content-Type": "multipart/form-data" },
    onUploadProgress: progress,
    timeout: 0,
    signal: cancelSignal
  }),
  uploadPut: (url, formData, progress, cancelSignal) => authenticatedRequest.put(url, formData, {
    headers: { "Content-Type": "multipart/form-data" },
    onUploadProgress: progress,
    timeout: 0,
    signal: cancelSignal
  })
};
var general_api_default = Api;

// src/appSlice/selectors.ts
var import_helpers2 = require("@northern.tech/utils/helpers");
var import_toolkit9 = require("@reduxjs/toolkit");
var getFeatures = (state) => state.app.features;
var getFullVersionInformation = (state) => state.app.versionInformation;
var getSearchState = (state) => state.app.searchState;
var getUploads = (state) => state.app.uploadsById;
var getIsUploading = (0, import_toolkit9.createSelector)([getUploads], (uploadsById) => !!Object.keys(uploadsById).length);
var getSearchedDevices = (0, import_toolkit9.createSelector)([getSearchState], ({ deviceIds }) => deviceIds);
var getVersionInformation = (0, import_toolkit9.createSelector)(
  [getFullVersionInformation, getFeatures],
  ({ Integration: Integration2, ...remainder }, { isHosted }) => isHosted && Integration2 !== "next" ? remainder : { ...remainder, Integration: Integration2 }
);
var getIsPreview = (0, import_toolkit9.createSelector)([getFullVersionInformation], ({ Integration: Integration2 }) => (0, import_helpers2.versionCompare)(Integration2, "next") > -1);

// src/commonSelectors.ts
var import_helpers5 = require("@northern.tech/utils/helpers");
var import_toolkit15 = require("@reduxjs/toolkit");

// src/deploymentsSlice/selectors.ts
var import_toolkit10 = require("@reduxjs/toolkit");
var getDeploymentsById = (state) => state.deployments.byId;
var getDeploymentsByStatus = (state) => state.deployments.byStatus;
var getSelectedDeploymentDeviceIds = (state) => state.deployments.selectedDeviceIds;
var getDeploymentsSelectionState = (state) => state.deployments.selectionState;
var getMappedDeploymentSelection = (0, import_toolkit10.createSelector)(
  [getDeploymentsSelectionState, (_, deploymentsState) => deploymentsState, getDeploymentsById],
  (selectionState, deploymentsState, deploymentsById) => {
    const { selection = [] } = selectionState[deploymentsState] ?? {};
    return selection.reduce((accu, id) => {
      if (deploymentsById[id]) {
        accu.push(deploymentsById[id]);
      }
      return accu;
    }, []);
  }
);
var relevantDeploymentStates = [DEPLOYMENT_STATES.pending, DEPLOYMENT_STATES.inprogress, DEPLOYMENT_STATES.finished];
var DEPLOYMENT_CUTOFF = 3;
var getRecentDeployments = (0, import_toolkit10.createSelector)(
  [getDeploymentsById, getDeploymentsByStatus],
  (deploymentsById, deploymentsByStatus) => Object.entries(deploymentsByStatus).reduce(
    (accu, [state, byStatus]) => {
      if (!relevantDeploymentStates.includes(state) || !byStatus.deploymentIds.length) {
        return accu;
      }
      accu[state] = byStatus.deploymentIds.reduce((accu2, id) => {
        if (deploymentsById[id]) {
          accu2.push(deploymentsById[id]);
        }
        return accu2;
      }, []).slice(0, DEPLOYMENT_CUTOFF);
      accu.total += byStatus.total;
      return accu;
    },
    { total: 0 }
  )
);

// src/devicesSlice/selectors.ts
var import_helpers3 = require("@northern.tech/utils/helpers");
var import_toolkit11 = require("@reduxjs/toolkit");
var getAcceptedDevices = (state) => state.devices.byStatus.accepted;
var getDevicesByStatus = (state) => state.devices.byStatus;
var getDevicesById = (state) => state.devices.byId;
var getGroupsById = (state) => state.devices.groups.byId;
var getSelectedGroup = (state) => state.devices.groups.selectedGroup;
var getListedDevices = (state) => state.devices.deviceList.deviceIds;
var getFilteringAttributes = (state) => state.devices.filteringAttributes;
var getDeviceFilters = (state) => state.devices.filters || [];
var getFilteringAttributesFromConfig = (state) => state.devices.filteringAttributesConfig.attributes;
var getSortedFilteringAttributes = (0, import_toolkit11.createSelector)([getFilteringAttributes], (filteringAttributes) => ({
  ...filteringAttributes,
  identityAttributes: [...filteringAttributes.identityAttributes, "id"]
}));
var getDeviceLimit = (state) => state.devices.limit;
var getFilteringAttributesLimit = (state) => state.devices.filteringAttributesLimit;
var getDeviceIdentityAttributes = (0, import_toolkit11.createSelector)(
  [getFilteringAttributes, getFilteringAttributesLimit],
  ({ identityAttributes }, filteringAttributesLimit) => {
    const attributes = identityAttributes.slice(0, filteringAttributesLimit);
    return attributes.reduce(
      (accu, value) => {
        accu.push({ value, label: value, scope: "identity" });
        return accu;
      },
      [
        { value: "name", label: "Name", scope: "tags" },
        { value: "id", label: "Device ID", scope: "identity" }
      ]
    );
  }
);
var getDeviceCountsByStatus = (0, import_toolkit11.createSelector)(
  [getDevicesByStatus],
  (byStatus) => Object.values(import_constants3.DEVICE_STATES).reduce((accu, state) => {
    accu[state] = byStatus[state].total || 0;
    return accu;
  }, {})
);
var getDeviceById = (0, import_toolkit11.createSelector)([getDevicesById, (_, deviceId) => deviceId], (devicesById, deviceId = "") => devicesById[deviceId] ?? {});
var getSelectedGroupInfo = (0, import_toolkit11.createSelector)(
  [getAcceptedDevices, getGroupsById, getSelectedGroup],
  ({ total: acceptedDeviceTotal }, groupsById, selectedGroup) => {
    let groupCount = acceptedDeviceTotal;
    let groupFilters = [];
    if (selectedGroup && groupsById[selectedGroup]) {
      groupCount = groupsById[selectedGroup].total || 0;
      groupFilters = groupsById[selectedGroup].filters || [];
    }
    return { groupCount, selectedGroup, groupFilters };
  }
);
var getLimitMaxed = (0, import_toolkit11.createSelector)(
  [getAcceptedDevices, getDeviceLimit],
  ({ total: acceptedDevices = 0 }, deviceLimit) => Boolean(deviceLimit && deviceLimit <= acceptedDevices)
);
var getGroupsByIdWithoutUngrouped = (0, import_toolkit11.createSelector)([getGroupsById], ({ [UNGROUPED_GROUP.id]: ungrouped, ...groups }) => groups);
var getGroupData = (0, import_toolkit11.createSelector)([getGroupsByIdWithoutUngrouped], (groups) => {
  const createdGroup = Object.keys(groups).length ? Object.keys(groups)[0] : void 0;
  const hasDynamicGroups = Object.values(groups).some((group) => !!group.id);
  return { createdGroup, hasDynamicGroups, groups };
});
var getGroups = (0, import_toolkit11.createSelector)([getGroupsById], (groupsById) => {
  const groupNames = Object.keys(groupsById).sort();
  const groupedGroups = Object.entries(groupsById).sort((a, b) => a[0].localeCompare(b[0])).reduce(
    (accu, [groupname, group]) => {
      const name = groupname === UNGROUPED_GROUP.id ? UNGROUPED_GROUP.name : groupname;
      const groupItem = { ...group, groupId: name, name: groupname };
      if ((group.filters ?? []).length > 0) {
        if (groupname !== UNGROUPED_GROUP.id) {
          accu.dynamic.push(groupItem);
        } else {
          accu.ungrouped.push(groupItem);
        }
      } else {
        accu.static.push(groupItem);
      }
      return accu;
    },
    { dynamic: [], static: [], ungrouped: [] }
  );
  return { groupNames, ...groupedGroups };
});
var getAttributesList = (0, import_toolkit11.createSelector)(
  [getFilteringAttributes, getFilteringAttributesFromConfig],
  ({ identityAttributes = [], inventoryAttributes = [] }, { identity = [], inventory = [] }) => [...identityAttributes, ...inventoryAttributes, ...identity, ...inventory].filter(import_helpers3.duplicateFilter)
);
var getDeviceTypes = (0, import_toolkit11.createSelector)(
  [getAcceptedDevices, getDevicesById],
  ({ deviceIds = [] }, devicesById) => Object.keys(
    deviceIds.slice(0, 200).reduce((accu, item) => {
      const { device_type: deviceTypes = [] } = devicesById[item] ? devicesById[item].attributes : {};
      accu = deviceTypes.reduce((deviceTypeAccu, deviceType) => {
        if (deviceType.length > 1) {
          deviceTypeAccu[deviceType] = deviceTypeAccu[deviceType] ? deviceTypeAccu[deviceType] + 1 : 1;
        }
        return deviceTypeAccu;
      }, accu);
      return accu;
    }, {})
  )
);

// src/monitorSlice/selectors.ts
var getIssueCountsByType = (state) => state.monitor.issueCounts.byType;

// src/onboardingSlice/selectors.ts
var getOnboarding = (state) => state.onboarding;

// src/organizationSlice/selectors.ts
var import_toolkit12 = require("@reduxjs/toolkit");
var import_dayjs = __toESM(require("dayjs"), 1);
var import_relativeTime = __toESM(require("dayjs/plugin/relativeTime.js"), 1);
var getOrganization = (state) => state.organization.organization;
var getExternalIntegrations = (state) => state.organization.externalDeviceIntegrations;
var getAuditLog = (state) => state.organization.auditlog.events;
var getAuditLogSelectionState = (state) => state.organization.auditlog.selectionState;
var getWebhookEvents = (state) => state.organization.webhooks.events;
var getWebhookEventTotal = (state) => state.organization.webhooks.eventsTotal;
var getDeviceTwinIntegrations = (0, import_toolkit12.createSelector)(
  [getExternalIntegrations],
  (integrations) => integrations.filter((integration) => integration.id && EXTERNAL_PROVIDER[integration.provider]?.deviceTwin)
);
var getIsServiceProvider = (state) => state.organization.organization.service_provider;
var getWebhooks = (0, import_toolkit12.createSelector)(
  [getExternalIntegrations],
  (integrations) => integrations.filter((integration) => integration.id && integration.provider === EXTERNAL_PROVIDER.webhook.provider)
);
var getWebhookEventInfo = (0, import_toolkit12.createSelector)(
  [getWebhooks, getWebhookEvents, getWebhookEventTotal],
  (webhooks, events, eventTotal) => webhooks.length ? { events, eventTotal } : { events: [], eventTotal: 0 }
);
var getAuditLogEntry = (0, import_toolkit12.createSelector)([getAuditLog, getAuditLogSelectionState], (events, { selectedId }) => {
  if (!selectedId) {
    return;
  }
  const [eventAction, eventTime] = atob(selectedId).split("|");
  return events.find((item) => item.action === eventAction && item.time === eventTime);
});
import_dayjs.default.extend(import_relativeTime.default);
var newPricingIntroduction = (0, import_dayjs.default)("2025-06-03T00:00");
var getHasCurrentPricing = (0, import_toolkit12.createSelector)(
  [getOrganization],
  ({ id }) => !!id && (0, import_dayjs.default)(parseInt(id.substring(0, 8), 16) * 1e3) >= newPricingIntroduction
);

// src/releasesSlice/selectors.ts
var import_toolkit13 = require("@reduxjs/toolkit");

// src/utils.ts
var import_helpers4 = require("@northern.tech/utils/helpers");
var filterProcessors = {
  [import_constants3.DEVICE_FILTERING_OPTIONS.$gt.key]: (val) => Number(val) || val,
  [import_constants3.DEVICE_FILTERING_OPTIONS.$gte.key]: (val) => Number(val) || val,
  [import_constants3.DEVICE_FILTERING_OPTIONS.$lt.key]: (val) => Number(val) || val,
  [import_constants3.DEVICE_FILTERING_OPTIONS.$lte.key]: (val) => Number(val) || val,
  [import_constants3.DEVICE_FILTERING_OPTIONS.$ltne.key]: (val) => Number(val) || val,
  [import_constants3.DEVICE_FILTERING_OPTIONS.$in.key]: (val) => ("" + val).split(",").map((i) => i.trim()),
  [import_constants3.DEVICE_FILTERING_OPTIONS.$nin.key]: (val) => ("" + val).split(",").map((i) => i.trim()),
  [import_constants3.DEVICE_FILTERING_OPTIONS.$exists.key]: import_helpers4.yes,
  [import_constants3.DEVICE_FILTERING_OPTIONS.$nexists.key]: () => false
};
var filterAliases = {
  $nexists: { alias: import_constants3.DEVICE_FILTERING_OPTIONS.$exists.key, value: false }
};
var mapFiltersToTerms = (filters) => filters.map((filter) => ({
  scope: filter.scope,
  attribute: filter.key,
  type: filterAliases[filter.operator]?.alias || filter.operator,
  value: filterProcessors.hasOwnProperty(filter.operator) ? filterProcessors[filter.operator](filter.value) : filter.value
}));
var convertIssueOptionsToFilters = (issuesSelection, filtersState = {}) => issuesSelection.map((item) => {
  if (typeof import_constants3.DEVICE_ISSUE_OPTIONS[item].filterRule.value === "function") {
    return { ...import_constants3.DEVICE_ISSUE_OPTIONS[item].filterRule, value: import_constants3.DEVICE_ISSUE_OPTIONS[item].filterRule.value(filtersState) };
  }
  return import_constants3.DEVICE_ISSUE_OPTIONS[item].filterRule;
});
var convertDeviceListStateToFilters = ({
  filters = [],
  group,
  groups = { byId: {} },
  offlineThreshold,
  selectedIssues = [],
  status
}) => {
  let applicableFilters = [...filters];
  if (typeof group === "string" && !(groups.byId[group]?.filters || applicableFilters).length) {
    applicableFilters.push({ key: "group", value: group, operator: import_constants3.DEVICE_FILTERING_OPTIONS.$eq.key, scope: "system" });
  }
  const nonMonitorFilters = applicableFilters.filter(
    (filter) => !Object.values(import_constants3.DEVICE_ISSUE_OPTIONS).some(
      ({ filterRule }) => filter.scope !== "inventory" && filterRule.scope === filter.scope && filterRule.key === filter.key
    )
  );
  const deviceIssueFilters = convertIssueOptionsToFilters(selectedIssues, { offlineThreshold });
  applicableFilters = [...nonMonitorFilters, ...deviceIssueFilters];
  const effectiveFilters = status ? [...applicableFilters, { key: "status", value: status, operator: import_constants3.DEVICE_FILTERING_OPTIONS.$eq.key, scope: "identity" }] : applicableFilters;
  return { applicableFilters: nonMonitorFilters, filterTerms: mapFiltersToTerms(effectiveFilters) };
};
var listItemMapper = (byId, ids, { cutOffSize = DEVICE_LIST_MAXIMUM_LENGTH, defaultObject = {} }) => ids.slice(0, cutOffSize).reduce((accu, id) => {
  if (id && byId[id]) {
    accu.push({ ...defaultObject, ...byId[id] });
  }
  return accu;
}, []);
var mergePermissions = (existingPermissions = { ...import_constants3.emptyUiPermissions }, addedPermissions) => Object.entries(existingPermissions).reduce(
  (accu, [key, value]) => {
    let values;
    if (!accu[key]) {
      accu[key] = value;
      return accu;
    }
    if (Array.isArray(value)) {
      values = [...value, ...accu[key]].filter(import_helpers4.duplicateFilter);
    } else {
      values = mergePermissions(accu[key], { ...value });
    }
    accu[key] = values;
    return accu;
  },
  { ...addedPermissions }
);
var mapUserRolesToUiPermissions = (userRoles, roles) => userRoles.reduce(
  (accu, roleId) => {
    if (!(roleId && roles[roleId])) {
      return accu;
    }
    return mergePermissions(accu, roles[roleId].uiPermissions);
  },
  { ...import_constants3.emptyUiPermissions }
);
var isDarkMode = (mode) => mode === DARK_MODE;

// src/releasesSlice/selectors.ts
var getSelectedReleaseId = (state) => state.releases.selectedRelease;
var getReleasesById = (state) => state.releases.byId;
var getReleaseTags = (state) => state.releases.tags;
var getReleaseListState = (state) => state.releases.releasesList;
var getListedReleases = (state) => state.releases.releasesList.releaseIds;
var releaseDefaults = {};
var getReleaseMappingDefaults = () => releaseDefaults;
var getReleasesList = (0, import_toolkit13.createSelector)([getReleasesById, getListedReleases, getReleaseMappingDefaults], listItemMapper);
var getReleaseTagsById = (0, import_toolkit13.createSelector)([getReleaseTags], (releaseTags) => releaseTags.reduce((accu, key) => ({ ...accu, [key]: key }), {}));
var getHasReleases = (0, import_toolkit13.createSelector)(
  [getReleaseListState, getReleasesById],
  ({ searchTotal, total }, byId) => !!(Object.keys(byId).length || total || searchTotal)
);
var getSelectedRelease = (0, import_toolkit13.createSelector)([getReleasesById, getSelectedReleaseId], (byId, id) => byId[id || ""] ?? {});
var getSelectedReleases = (0, import_toolkit13.createSelector)([getReleaseListState, getReleasesList], ({ selection }, releases) => selection.map((index) => releases[index]));

// src/usersSlice/selectors.ts
var import_toolkit14 = require("@reduxjs/toolkit");
var emptyObject = {};
var getRolesById = (state) => state.users.rolesById;
var getTooltipsById = (state) => state.users.tooltips.byId;
var getGlobalSettings = (state) => state.users.globalSettings;
var getCurrentUserId = (state) => state.users.currentUser;
var getUsersById = (state) => state.users.byId;
var getUsersList = (0, import_toolkit14.createSelector)([getUsersById], (usersById) => Object.values(usersById));
var getCurrentUser = (0, import_toolkit14.createSelector)(
  [getUsersById, getCurrentUserId],
  (usersById, userId) => userId ? usersById[userId] ?? emptyObject : emptyObject
);
var getUserSettings = (state) => state.users.userSettings;
var getSelectedDeviceAttribute = (0, import_toolkit14.createSelector)(
  [getUserSettings],
  ({ columnSelection }) => columnSelection.map((attribute) => ({ attribute: attribute.key, scope: attribute.scope }))
);
var getIsDarkMode = (0, import_toolkit14.createSelector)([getUserSettings], ({ mode }) => isDarkMode(mode));
var getReadAllHelptips = (0, import_toolkit14.createSelector)(
  [getTooltipsById],
  (tooltips) => Object.values(tooltips).every(({ readState }) => readState === READ_STATES.read)
);
var getTooltipsState = (0, import_toolkit14.createSelector)(
  [getTooltipsById, getUserSettings],
  (byId, { tooltips = {} }) => Object.entries(byId).reduce(
    (accu, [id, value]) => {
      accu[id] = { ...accu[id], ...value };
      return accu;
    },
    { ...tooltips }
  )
);
var getHas2FA = (0, import_toolkit14.createSelector)(
  [getCurrentUser],
  (currentUser) => currentUser.hasOwnProperty("tfa_status") && currentUser.tfa_status === import_constants3.twoFAStates.enabled
);
var getIdAttribute = (0, import_toolkit14.createSelector)([getGlobalSettings], ({ id_attribute = { ...defaultIdAttribute } }) => id_attribute);
var getOfflineThresholdSettings = (0, import_toolkit14.createSelector)([getGlobalSettings], ({ offlineThreshold }) => ({
  interval: offlineThreshold?.interval || DEVICE_ONLINE_CUTOFF.interval,
  intervalUnit: offlineThreshold?.intervalUnit || DEVICE_ONLINE_CUTOFF.intervalName
}));
var getRolesList = (0, import_toolkit14.createSelector)([getRolesById], (rolesById2) => Object.entries(rolesById2).map(([value, role]) => ({ value, ...role })));

// src/commonSelectors.ts
var getIsEnterprise = (0, import_toolkit15.createSelector)(
  [getOrganization, getFeatures],
  ({ plan = PLANS.os.id }, { isEnterprise, isHosted }) => isEnterprise || isHosted && plan === PLANS.enterprise.id
);
var getAttrsEndpoint = (0, import_toolkit15.createSelector)(
  [getFeatures],
  ({ hasReporting }) => hasReporting ? `${import_constants3.reportingApiUrl}/devices/search/attributes` : `${import_constants3.inventoryApiUrlV2}/filters/attributes`
);
var getSearchEndpoint = (0, import_toolkit15.createSelector)(
  [getFeatures],
  ({ hasReporting }) => hasReporting ? `${import_constants3.reportingApiUrl}/devices/search` : `${import_constants3.inventoryApiUrlV2}/filters/search`
);
var getUserRoles = (0, import_toolkit15.createSelector)([getCurrentUser, getRolesById, getIsEnterprise], (currentUser, rolesById2, isEnterprise) => {
  const isAdmin = currentUser.roles?.length ? currentUser.roles.some((role) => role === import_constants3.rolesByName.admin) : !isEnterprise;
  const uiPermissions = isAdmin ? mapUserRolesToUiPermissions([import_constants3.rolesByName.admin], rolesById2) : mapUserRolesToUiPermissions(currentUser.roles || [], rolesById2);
  return { isAdmin, uiPermissions };
});
var hasPermission = (thing, permission) => Object.values(thing).some((permissions) => permissions.includes(permission));
var getUserCapabilities = (0, import_toolkit15.createSelector)([getUserRoles, getIsServiceProvider], ({ uiPermissions }, isServiceProvider) => {
  const canManageReleases = hasPermission(uiPermissions.releases, import_constants3.uiPermissionsById.manage.value);
  const canReadReleases = canManageReleases || hasPermission(uiPermissions.releases, import_constants3.uiPermissionsById.read.value);
  const canUploadReleases = canManageReleases || hasPermission(uiPermissions.releases, import_constants3.uiPermissionsById.upload.value);
  const canAuditlog = uiPermissions.auditlog.includes(import_constants3.uiPermissionsById.read.value);
  const canReadUsers = uiPermissions.userManagement.includes(import_constants3.uiPermissionsById.read.value);
  const canManageUsers = uiPermissions.userManagement.includes(import_constants3.uiPermissionsById.manage.value);
  const canReadDevices = hasPermission(uiPermissions.groups, import_constants3.uiPermissionsById.read.value);
  const canWriteDevices = Object.values(uiPermissions.groups).some(
    (groupPermissions) => groupPermissions.includes(import_constants3.uiPermissionsById.read.value) && groupPermissions.length > 1
  );
  const canTroubleshoot = hasPermission(uiPermissions.groups, import_constants3.uiPermissionsById.connect.value);
  const canManageDevices = hasPermission(uiPermissions.groups, import_constants3.uiPermissionsById.manage.value);
  const canConfigure = hasPermission(uiPermissions.groups, import_constants3.uiPermissionsById.configure.value);
  const canDeploy = uiPermissions.deployments.includes(import_constants3.uiPermissionsById.deploy.value) || hasPermission(uiPermissions.groups, import_constants3.uiPermissionsById.deploy.value);
  const canReadDeployments = uiPermissions.deployments.includes(import_constants3.uiPermissionsById.read.value);
  return {
    canAuditlog,
    canConfigure,
    canDeploy,
    canManageDevices,
    canManageReleases,
    canManageUsers,
    canReadDeployments,
    canReadDevices,
    canReadReleases,
    canReadUsers,
    canTroubleshoot,
    canUploadReleases,
    canWriteDevices,
    groupsPermissions: uiPermissions.groups,
    releasesPermissions: uiPermissions.releases,
    SPTenant: isServiceProvider
  };
});
var getTenantCapabilities = (0, import_toolkit15.createSelector)(
  [getFeatures, getOrganization, getIsEnterprise],
  ({
    hasAuditlogs: isAuditlogEnabled,
    hasDeviceConfig: isDeviceConfigEnabled,
    hasDeviceConnect: isDeviceConnectEnabled,
    hasMonitor: isMonitorEnabled,
    isHosted
  }, { addons = [], plan = PLANS.os.id }, isEnterprise) => {
    const canDelta = isEnterprise || plan === PLANS.professional.id;
    const hasAuditlogs = isAuditlogEnabled && isEnterprise;
    const hasDeviceConfig = addons.some((addon) => addon.name === ADDONS.configure.id && addon.enabled) || isDeviceConfigEnabled && !isHosted;
    const hasDeviceConnect = addons.some((addon) => addon.name === ADDONS.troubleshoot.id && addon.enabled) || isDeviceConnectEnabled && !isHosted;
    const hasMonitor = isMonitorEnabled && addons.some((addon) => addon.name === ADDONS.monitor.id && addon.enabled);
    return {
      canDelta,
      canRetry: canDelta,
      canSchedule: canDelta,
      hasAuditlogs,
      hasDeviceConfig,
      hasDeviceConnect,
      hasFullFiltering: canDelta,
      hasMonitor,
      isEnterprise,
      plan
    };
  }
);
var getFilterAttributes = (0, import_toolkit15.createSelector)(
  [getGlobalSettings, getFilteringAttributes],
  ({ previousFilters }, { identityAttributes, inventoryAttributes, systemAttributes, tagAttributes }) => {
    const deviceNameAttribute = { key: "name", value: "Name", scope: import_constants3.ATTRIBUTE_SCOPES.tags, category: import_constants3.ATTRIBUTE_SCOPES.tags, priority: 1 };
    const deviceIdAttribute = { key: "id", value: "Device ID", scope: import_constants3.ATTRIBUTE_SCOPES.identity, category: import_constants3.ATTRIBUTE_SCOPES.identity, priority: 1 };
    const checkInAttribute = { key: "check_in_time", value: "Latest activity", scope: import_constants3.ATTRIBUTE_SCOPES.system, category: import_constants3.ATTRIBUTE_SCOPES.system, priority: 4 };
    const updateAttribute = { ...checkInAttribute, key: "updated_ts", value: "Last inventory update" };
    const firstRequestAttribute = { key: "created_ts", value: "First request", scope: import_constants3.ATTRIBUTE_SCOPES.system, category: import_constants3.ATTRIBUTE_SCOPES.system, priority: 4 };
    const attributes = [
      ...previousFilters.map((item) => ({
        ...item,
        value: deviceIdAttribute.key === item.key ? deviceIdAttribute.value : item.key,
        category: "recently used",
        priority: 0
      })),
      deviceNameAttribute,
      deviceIdAttribute,
      ...identityAttributes.map((item) => ({ key: item, value: item, scope: import_constants3.ATTRIBUTE_SCOPES.identity, category: import_constants3.ATTRIBUTE_SCOPES.identity, priority: 1 })),
      ...inventoryAttributes.map((item) => ({ key: item, value: item, scope: import_constants3.ATTRIBUTE_SCOPES.inventory, category: import_constants3.ATTRIBUTE_SCOPES.inventory, priority: 2 })),
      ...tagAttributes.map((item) => ({ key: item, value: item, scope: import_constants3.ATTRIBUTE_SCOPES.tags, category: import_constants3.ATTRIBUTE_SCOPES.tags, priority: 3 })),
      checkInAttribute,
      updateAttribute,
      firstRequestAttribute,
      ...systemAttributes.map((item) => ({ key: item, value: item, scope: import_constants3.ATTRIBUTE_SCOPES.system, category: import_constants3.ATTRIBUTE_SCOPES.system, priority: 4 }))
    ];
    return (0, import_helpers5.attributeDuplicateFilter)(attributes, "key");
  }
);
var getOnboardingState = (0, import_toolkit15.createSelector)([getOnboarding, getUserSettings], ({ complete, progress, showTips, ...remainder }, { onboarding = {} }) => ({
  ...remainder,
  ...onboarding,
  complete: onboarding.complete || complete,
  progress: Object.keys(onboardingSteps).findIndex((step) => step === progress) > Object.keys(onboardingSteps).findIndex((step) => step === onboarding.progress) ? progress : onboarding.progress,
  showTips: !onboarding.showTips ? onboarding.showTips : showTips
}));
var getDemoDeviceAddress = (0, import_toolkit15.createSelector)([getDevicesById, getOnboarding], (devicesById, { approach, demoArtifactPort }) => {
  const demoDeviceAddress = `http://${(0, import_helpers5.getDemoDeviceAddress)(Object.values(devicesById), approach)}`;
  return demoArtifactPort ? `${demoDeviceAddress}:${demoArtifactPort}` : demoDeviceAddress;
});
var getDeviceConfigDeployment = (0, import_toolkit15.createSelector)([getDeviceById, getDeploymentsById], (device, deploymentsById) => {
  const { config = {} } = device;
  const { deployment_id: configDeploymentId } = config;
  const deviceConfigDeployment = deploymentsById[configDeploymentId] || {};
  return { device, deviceConfigDeployment };
});
var getDeploymentRelease = (0, import_toolkit15.createSelector)(
  [getDeploymentsById, getDeploymentsSelectionState, getReleasesById],
  (deploymentsById, { selectedId }, releasesById) => {
    const deployment = deploymentsById[selectedId] || {};
    return deployment.artifact_name && releasesById[deployment.artifact_name] ? releasesById[deployment.artifact_name] : { device_types_compatible: [] };
  }
);
var getSelectedDeploymentData = (0, import_toolkit15.createSelector)(
  [getDeploymentsById, getDeploymentsSelectionState, getDevicesById, getSelectedDeploymentDeviceIds],
  (deploymentsById, { selectedId }, devicesById, selectedDeviceIds) => {
    const deployment = deploymentsById[selectedId] ?? {};
    const { devices = {} } = deployment;
    return {
      deployment,
      selectedDevices: selectedDeviceIds.map((deviceId) => ({ ...devicesById[deviceId], ...devices[deviceId] }))
    };
  }
);
var getAvailableIssueOptionsByType = (0, import_toolkit15.createSelector)(
  [getFeatures, getTenantCapabilities, getIssueCountsByType],
  ({ hasReporting }, { hasFullFiltering, hasMonitor }, issueCounts) => Object.values(import_constants3.DEVICE_ISSUE_OPTIONS).reduce((accu, { isCategory, key, needsFullFiltering, needsMonitor, needsReporting, title }) => {
    if (isCategory || needsReporting && !hasReporting || needsFullFiltering && !hasFullFiltering || needsMonitor && !hasMonitor) {
      return accu;
    }
    accu[key] = { count: issueCounts[key].filtered, key, title };
    return accu;
  }, {})
);
var getGroupNames = (0, import_toolkit15.createSelector)([getGroupsById, getUserRoles], (groupsById, { uiPermissions }) => {
  const { [UNGROUPED_GROUP.id]: ungrouped, ...groups } = groupsById;
  return Object.keys(
    Object.entries(groups).reduce((accu, [groupName, group]) => {
      if (group.filterId || uiPermissions.groups[import_constants3.ALL_DEVICES]) {
        accu[groupName] = group;
      }
      return accu;
    }, uiPermissions.groups)
  ).sort();
});
var getDeviceReportsForUser = (0, import_toolkit15.createSelector)(
  [getUserSettings, getCurrentUser, getGlobalSettings, getDevicesById],
  ({ reports }, { id: currentUserId }, globalSettings, devicesById) => reports || globalSettings[`${currentUserId}-reports`] || (Object.keys(devicesById).length ? defaultReports : [])
);
var listTypeDeviceIdMap = {
  deviceList: getListedDevices,
  search: getSearchedDevices
};
var deviceMapDefault = { defaultObject: { auth_sets: [] }, cutOffSize: DEVICE_LIST_MAXIMUM_LENGTH };
var getDeviceMappingDefaults = () => deviceMapDefault;
var getMappedDevicesList = (0, import_toolkit15.createSelector)(
  [getDevicesById, (state, listType) => listTypeDeviceIdMap[listType](state), getDeviceMappingDefaults],
  listItemMapper
);
var getAuditlogDevice = (0, import_toolkit15.createSelector)([getAuditLogEntry, getDevicesById], (auditlogEvent, devicesById) => {
  let auditlogDevice = {};
  if (auditlogEvent) {
    const { object = {} } = auditlogEvent;
    const { device = {}, id, type } = object;
    auditlogDevice = type === "device" ? { id, ...device } : auditlogDevice;
  }
  return { ...auditlogDevice, ...devicesById[auditlogDevice.id] };
});
var getRelevantRoles = (0, import_toolkit15.createSelector)([getOrganization, getRolesList], ({ service_provider }, roles) => {
  if (service_provider) {
    return roles.reduce((accu, role) => {
      if (import_constants3.rolesById[role.value]) {
        return accu;
      }
      accu.push(role);
      return accu;
    }, Object.values(import_constants3.serviceProviderRolesById));
  }
  return Object.keys(import_constants3.rolesById).reverse().reduce((accu, key) => {
    const index = accu.findIndex(({ value }) => value === key);
    accu = [accu[index], ...accu.filter((item, itemIndex) => index !== itemIndex)];
    return accu;
  }, roles);
});

// src/store.ts
var import_react_redux = require("react-redux");
var import_helpers6 = require("@northern.tech/utils/helpers");
var import_toolkit16 = require("@reduxjs/toolkit");
var import_react = require("@sentry/react");
var { setSnackbar, uploadProgress } = actions_default;
var keys = ["sessionDeploymentChecker", settingsKeys.initialized];
var resetEnvironment = () => keys.forEach((key) => window.sessionStorage.removeItem(key));
resetEnvironment();
var commonErrorFallback = "Please check your connection.";
var commonErrorHandler = (err, errorContext, dispatch, fallback, mightBeAuthRelated = false) => {
  const errMsg = (0, import_helpers6.extractErrorMessage)(err, fallback);
  if (mightBeAuthRelated || getToken()) {
    dispatch(setSnackbar({ message: (0, import_helpers6.preformatWithRequestID)(err.response, `${errorContext} ${errMsg}`), action: "Copy to clipboard" }));
  }
  return Promise.reject(err);
};
var rootReducer = (0, import_toolkit16.combineReducers)({
  app: appSlice_default,
  devices: devicesSlice_default,
  deployments: deploymentsSlice_default,
  monitor: monitorSlice_default,
  onboarding: onboardingSlice_default,
  organization: organizationSlice_default,
  releases: releasesSlice_default,
  users: usersSlice_default
});
var sessionReducer = (state, action) => {
  if (action.type === USER_LOGOUT) {
    state = void 0;
  }
  return rootReducer(state, action);
};
var rejectionLoggerMiddleware = () => (next) => (action) => {
  if (action.type.endsWith("/rejected")) {
    const { error } = action;
    console.error("Rejection in action:", action);
    console.error(error.stack);
  }
  return next(action);
};
var tracingActionIgnoreList = [actions8.successfullyLoggedIn.type, "users/loginUser/pending", "users/loginUser/fulfilled", "users/loginUser/rejected"];
var sentryReduxEnhancer = (0, import_react.createReduxEnhancer)({
  actionTransformer: (action) => {
    if (tracingActionIgnoreList.includes(action.type)) {
      return null;
    }
    return action;
  },
  // Transform the state to remove sensitive information
  stateTransformer: (state) => {
    const transformedState = {
      ...state,
      users: { ...state.users, currentSession: null },
      organization: {
        ...state.organization,
        organization: {
          ...state.organization.organization,
          tenant_token: null
        }
      }
    };
    return transformedState;
  }
});
var getConfiguredStore = (options = {}) => {
  const { preloadedState = {}, ...config } = options;
  return (0, import_toolkit16.configureStore)({
    ...config,
    preloadedState,
    enhancers: (getDefaultEnhancers) => {
      if (window.mender_environment?.sentry?.isReduxEnabled) {
        return getDefaultEnhancers().concat(sentryReduxEnhancer);
      }
      return getDefaultEnhancers();
    },
    reducer: sessionReducer,
    middleware: (getDefaultMiddleware) => getDefaultMiddleware({
      immutableCheck: {
        ignoredPaths: ["app.uploadsById"]
      },
      serializableCheck: {
        ignoredActions: [actions6.receiveExternalDeviceIntegrations.name, uploadProgress.name],
        ignoredActionPaths: ["uploads", /payload\..*$/, "meta.arg.file", "meta.arg.integration.configHint"],
        ignoredPaths: ["app.uploadsById", "organization.externalDeviceIntegrations"]
      }
    }).concat(rejectionLoggerMiddleware)
  });
};
var store = getConfiguredStore({
  preloadedState: {}
});
var createAppAsyncThunk = import_toolkit16.createAsyncThunk.withTypes();

// src/monitorSlice/thunks.ts
var { page: defaultPage, perPage: defaultPerPage } = import_constants3.DEVICE_LIST_DEFAULTS;
var cutoffLength = 75;
var ellipsis = "...";
var longTextTrimmer = (text) => text.length >= cutoffLength + ellipsis.length ? `${text.substring(0, cutoffLength + ellipsis.length)}${ellipsis}` : text;
var sanitizeDeviceAlerts = (alerts) => alerts.map((alert) => ({ ...alert, fullName: alert.name, name: longTextTrimmer(alert.name || "") }));
var getDeviceAlerts = createAppAsyncThunk(`${sliceName}/getDeviceAlerts`, ({ id, config = {} }, { dispatch }) => {
  const { page = defaultPage, perPage = defaultPerPage, issuedBefore, issuedAfter, sortAscending = false } = config;
  const issued_after = issuedAfter ? `&issued_after=${issuedAfter}` : "";
  const issued_before = issuedBefore ? `&issued_before=${issuedBefore}` : "";
  return general_api_default.get(
    `${import_constants3.monitorApiUrlv1}/devices/${id}/alerts?page=${page}&per_page=${perPage}${issued_after}${issued_before}&sort_ascending=${sortAscending}`
  ).catch((err) => commonErrorHandler(err, `Retrieving device alerts for device ${id} failed:`, dispatch)).then(
    (res) => Promise.all([
      dispatch(actions.receiveDeviceAlerts({ deviceId: id, alerts: sanitizeDeviceAlerts(res.data) })),
      dispatch(actions.setAlertListState({ total: Number(res.headers[import_constants3.headerNames.total]) }))
    ])
  );
});
var getLatestDeviceAlerts = createAppAsyncThunk(
  `${sliceName}/getLatestDeviceAlerts`,
  ({ id, config = {} }, { dispatch }) => {
    const { page = defaultPage, perPage = 10 } = config;
    return general_api_default.get(`${import_constants3.monitorApiUrlv1}/devices/${id}/alerts/latest?page=${page}&per_page=${perPage}`).catch((err) => commonErrorHandler(err, `Retrieving device alerts for device ${id} failed:`, dispatch)).then((res) => Promise.resolve(dispatch(actions.receiveLatestDeviceAlerts({ deviceId: id, alerts: sanitizeDeviceAlerts(res.data) }))));
  }
);
var getIssueCountsByType2 = createAppAsyncThunk(
  `${sliceName}/getIssueCountsByType`,
  ({ type, options = {} }, { dispatch, getState }) => {
    const state = getState();
    const { filters = getDeviceFilters(state), group, status, ...remainder } = options;
    const { applicableFilters: nonMonitorFilters, filterTerms } = convertDeviceListStateToFilters({
      ...remainder,
      filters,
      group,
      offlineThreshold: state.app.offlineThreshold,
      selectedIssues: [type],
      status
    });
    return general_api_default.post(getSearchEndpoint(getState()), {
      page: 1,
      per_page: 1,
      filters: filterTerms,
      attributes: [{ scope: "identity", attribute: "status" }]
    }).catch((err) => commonErrorHandler(err, `Retrieving issue counts failed:`, dispatch, commonErrorFallback)).then((res) => {
      const total = nonMonitorFilters.length ? state.monitor.issueCounts.byType[type].total : Number(res.headers[import_constants3.headerNames.total]);
      const filtered = nonMonitorFilters.length ? Number(res.headers[import_constants3.headerNames.total]) : total;
      if (total === state.monitor.issueCounts.byType[type].total && filtered === state.monitor.issueCounts.byType[type].filtered) {
        return Promise.resolve();
      }
      return Promise.resolve(dispatch(actions.receiveDeviceIssueCounts({ counts: { filtered, total }, issueType: type })));
    });
  }
);
var getDeviceMonitorConfig = createAppAsyncThunk(
  `${sliceName}/getDeviceMonitorConfig`,
  (id, { dispatch }) => general_api_default.get(`${import_constants3.monitorApiUrlv1}/devices/${id}/config`).catch((err) => commonErrorHandler(err, `Retrieving device monitor config for device ${id} failed:`, dispatch)).then(({ data }) => Promise.all([dispatch(actions_default.receivedDevice({ id, monitors: data }), Promise.resolve(data))]))
);
var changeNotificationSetting = createAppAsyncThunk(
  `${sliceName}/changeNotificationSetting`,
  ({ enabled, channel = import_constants3.alertChannels.email }, { dispatch }) => general_api_default.put(`${import_constants3.monitorApiUrlv1}/settings/global/channel/alerts/${channel}/status`, { enabled }).catch((err) => commonErrorHandler(err, `${enabled ? "En" : "Dis"}abling  ${channel} alerts failed:`, dispatch)).then(
    () => Promise.all([
      dispatch(actions.changeAlertChannel({ channel, enabled })),
      dispatch(
        actions_default.setSnackbar({ message: `Successfully ${enabled ? "en" : "dis"}abled ${channel} alerts`, autoHideDuration: TIMEOUTS.fiveSeconds })
      )
    ])
  )
);
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  changeNotificationSetting,
  getDeviceAlerts,
  getDeviceMonitorConfig,
  getIssueCountsByType,
  getLatestDeviceAlerts
});
//# sourceMappingURL=thunks.cjs.map