import {
  BaseDialog
} from "./chunk-G4SBL2PI.js";
import {
  Code
} from "./chunk-SD7CDOOV.js";

// src/dialogs/Log.tsx
import { useState } from "react";
import CopyToClipboard from "react-copy-to-clipboard";
import { Button, DialogActions, DialogContent } from "@mui/material";
import { createFileDownload } from "@northern.tech/utils/helpers";
import { jsx, jsxs } from "react/jsx-runtime";
var wrapperStyle = { marginRight: 10, display: "inline-block" };
var dialogTypes = {
  "deviceLog": {
    title: "Deployment log for device",
    filename: ({ device, releaseName, date }) => `deployment-log-${device}-${releaseName}-${date}.log`
  },
  "configUpdateLog": {
    title: "Config update log for device",
    filename: () => "configuration-update.log"
  }
};
var LogDialog = ({ context = {}, logData = "", onClose, type = "deviceLog" }) => {
  const [copied, setCopied] = useState(false);
  const exportLog = () => createFileDownload(logData, dialogTypes[type].filename(context), "");
  return /* @__PURE__ */ jsxs(BaseDialog, { open: true, title: dialogTypes[type].title, maxWidth: "lg", onClose, children: [
    /* @__PURE__ */ jsxs(DialogContent, { children: [
      /* @__PURE__ */ jsx(Code, { className: "log", children: logData }),
      /* @__PURE__ */ jsx("p", { style: { marginLeft: 24 }, children: copied && /* @__PURE__ */ jsx("span", { className: "green fadeIn", children: "Copied to clipboard." }) })
    ] }),
    /* @__PURE__ */ jsxs(DialogActions, { children: [
      /* @__PURE__ */ jsx("div", { style: wrapperStyle, children: /* @__PURE__ */ jsx(Button, { onClick: onClose, children: "Cancel" }) }),
      /* @__PURE__ */ jsx(CopyToClipboard, { style: wrapperStyle, text: logData, onCopy: () => setCopied(true), children: /* @__PURE__ */ jsx(Button, { children: "Copy to clipboard" }) }),
      /* @__PURE__ */ jsx(Button, { variant: "contained", color: "primary", onClick: exportLog, children: "Export log" })
    ] })
  ] });
};
var Log_default = LogDialog;

export {
  LogDialog,
  Log_default
};
//# sourceMappingURL=chunk-GBFMW23T.js.map