import {
  cleanUp,
  getToken
} from "./chunk-ZJW3QIPM.js";
import {
  TIMEOUTS
} from "./chunk-7C4SQBEE.js";

// src/api/general-api.ts
import axios, { isCancel } from "axios";
var unauthorizedRedirect = (error) => {
  if (!isCancel(error) && error.response?.status === 401 && getToken()) {
    cleanUp();
    window.location.replace("/ui/");
  }
  return Promise.reject(error);
};
var commonRequestConfig = { timeout: TIMEOUTS.refreshDefault, headers: { "Content-Type": "application/json" } };
var authenticatedRequest = axios.create(commonRequestConfig);
authenticatedRequest.interceptors.response.use((res) => res, unauthorizedRedirect);
authenticatedRequest.interceptors.request.use(
  (config) => ({ ...config, headers: { ...config.headers, Authorization: `Bearer ${getToken()}` } }),
  (error) => Promise.reject(error)
);
var Api = {
  get: authenticatedRequest.get,
  delete: (url, data) => authenticatedRequest.request({ method: "delete", url, data }),
  patch: authenticatedRequest.patch,
  post: authenticatedRequest.post,
  postUnauthorized: (url, data, config = {}) => axios.post(url, data, { ...commonRequestConfig, ...config }),
  put: authenticatedRequest.put,
  upload: (url, formData, progress, cancelSignal) => authenticatedRequest.post(url, formData, {
    headers: { "Content-Type": "multipart/form-data" },
    onUploadProgress: progress,
    timeout: 0,
    signal: cancelSignal
  }),
  uploadPut: (url, formData, progress, cancelSignal) => authenticatedRequest.put(url, formData, {
    headers: { "Content-Type": "multipart/form-data" },
    onUploadProgress: progress,
    timeout: 0,
    signal: cancelSignal
  })
};
var general_api_default = Api;

export {
  commonRequestConfig,
  authenticatedRequest,
  general_api_default
};
//# sourceMappingURL=chunk-RS37Y2PQ.js.map