// src/ChipSelect.tsx
import { useState } from "react";
import { Controller, useFormContext } from "react-hook-form";
import { Cancel as CancelIcon } from "@mui/icons-material";
import { Autocomplete, Chip, TextField } from "@mui/material";
import { duplicateFilter, unionizeStrings } from "@northern.tech/utils/helpers";
import { jsx } from "react/jsx-runtime";
import { createElement } from "react";
var ChipSelect = ({ className = "", name, disabled = false, helperText, inputRef, label = "", options = [], placeholder = "" }) => {
  const [value, setValue] = useState("");
  const { control, getValues } = useFormContext();
  const onTextInputChange = (inputValue, reason, setCurrentSelection) => {
    const value2 = inputValue || "";
    if (reason === "clear") {
      setValue("");
      return setCurrentSelection([]);
    } else if (reason === "reset") {
      return setValue("");
    }
    const lastIndex = value2.lastIndexOf(",");
    const possibleSelection = value2.substring(0, lastIndex).split(",").filter(duplicateFilter);
    const currentValue = value2.substring(lastIndex + 1);
    const selection = getValues(name);
    const nextSelection = unionizeStrings(selection, possibleSelection);
    setValue(currentValue);
    setCurrentSelection(nextSelection);
  };
  const onTextInputLeave = (value2, setCurrentSelection) => {
    const selection = getValues(name);
    const nextSelection = unionizeStrings(selection, [value2]);
    setCurrentSelection(nextSelection);
    setValue("");
  };
  return /* @__PURE__ */ jsx(
    Controller,
    {
      control,
      name,
      render: ({ field: { onChange: formOnChange, value: currentSelection, ref, ...props } }) => /* @__PURE__ */ jsx(
        Autocomplete,
        {
          id: `${name}-chip-select`,
          value: currentSelection,
          className,
          filterSelectedOptions: true,
          freeSolo: true,
          includeInputInList: true,
          multiple: true,
          onChange: (e, value2) => e.key !== "Backspace" ? formOnChange(value2) : null,
          onInputChange: (e, v, reason) => onTextInputChange(null, reason, formOnChange),
          options,
          readOnly: disabled,
          ref,
          renderTags: (values, getTagProps) => values.map((option, index) => {
            const { key, onDelete, ...tagProps } = getTagProps({ index });
            return /* @__PURE__ */ jsx(Chip, { label: option, onDelete, deleteIcon: /* @__PURE__ */ jsx(CancelIcon, { onClick: onDelete, "aria-label": `${name}-delete` }), ...tagProps }, key);
          }),
          renderInput: (params) => /* @__PURE__ */ createElement(
            TextField,
            {
              ...params,
              fullWidth: true,
              slotProps: {
                htmlInput: { ...params.inputProps, value },
                input: params.InputProps
              },
              key: `${name}-input`,
              label,
              variant: disabled ? "standard" : "outlined",
              onBlur: (e) => onTextInputLeave(e.target.value, formOnChange),
              onChange: (e) => onTextInputChange(e.target.value, "input", formOnChange),
              placeholder: currentSelection.length ? "" : placeholder,
              helperText,
              inputRef
            }
          ),
          ...props
        }
      )
    }
  );
};
var ChipSelect_default = ChipSelect;

export {
  ChipSelect,
  ChipSelect_default
};
//# sourceMappingURL=chunk-SFCTPQG6.js.map