declare const DEVICE_STATES: {
    accepted: string;
    pending: string;
    preauth: string;
    rejected: string;
};
declare const ALL_DEVICE_STATES = "any";
declare const DEVICE_FILTERING_OPTIONS: {
    readonly $eq: {
        readonly key: "$eq";
        readonly title: "equals";
        readonly shortform: "=";
    };
    readonly $ne: {
        readonly key: "$ne";
        readonly title: "not equal";
        readonly shortform: "!=";
    };
    readonly $gt: {
        readonly key: "$gt";
        readonly title: ">";
        readonly shortform: ">";
        readonly help: "The \"greater than\" operator can work both on numbers and strings. In the latter case, the operator applies the lexicographical order to the value strings.";
    };
    readonly $gte: {
        readonly title: ">=";
        readonly shortform: ">=";
        readonly help: "The \"greater than or equal\" operator can work both on numbers and strings. In the latter case, the operator applies the lexicographical order to the value strings.";
    };
    readonly $lt: {
        readonly key: "$lt";
        readonly title: "<";
        readonly shortform: "<";
        readonly help: "The \"lesser than\" operator can work both on numbers and strings. In the latter case, the operator applies the lexicographical order to the value strings.";
    };
    readonly $lte: {
        readonly title: "<=";
        readonly shortform: "<=";
        readonly help: "The \"lesser than or equal\" operator can work both on numbers and strings. In the latter case, the operator applies the lexicographical order to the value strings.";
    };
    readonly $ltne: {
        readonly key: "$ltne";
        readonly title: "$ltne";
        readonly shortform: "ltne";
        readonly help: "The \"lesser than or does not exist\" operator can work both on numbers and strings. In the latter case, the operator applies the lexicographical order to the value strings.";
    };
    readonly $in: {
        readonly key: "$in";
        readonly title: "in";
        readonly shortform: "in";
        readonly help: "The \"in\" operator accepts a list of comma-separated values. It matches if the selected field is equal to one of the specified values.";
    };
    readonly $nin: {
        readonly key: "$nin";
        readonly title: "not in";
        readonly shortform: "not in";
        readonly help: "The \"not in\" operator accepts a list of comma-separated values. It matches if the selected field's value is not equal to any of the specified options.";
    };
    readonly $exists: {
        readonly key: "$exists";
        readonly title: "exists";
        readonly shortform: "exists";
        readonly value: true;
        readonly help: "The \"exists\" operator matches if the selected field's value has a value. No value needs to be provided for this operator.";
    };
    readonly $nexists: {
        readonly key: "$nexists";
        readonly title: "doesn't exist";
        readonly shortform: "doesn't exist";
        readonly value: true;
        readonly help: "The \"doesn't exist\" operator matches if the selected field's value has no value. No value needs to be provided for this operator.";
    };
    readonly $regex: {
        readonly key: "$regex";
        readonly title: "matches regular expression";
        readonly shortform: "matches";
        readonly help: "The \"regular expression\" operator matches the selected field's value with a Perl compatible regular expression (PCRE), automatically anchored by ^. If the regular expression is not valid, the filter will produce no results. If you need to specify options and flags, you can provide the full regex in the format of /regex/flags, for example.";
    };
};
declare const ATTRIBUTE_SCOPES: {
    readonly inventory: "inventory";
    readonly identity: "identity";
    readonly monitor: "monitor";
    readonly system: "system";
    readonly tags: "tags";
};
declare const ALL_DEVICES = "All devices";
type FilterRule = {
    key: string;
    operator: keyof typeof DEVICE_FILTERING_OPTIONS;
    scope: typeof ATTRIBUTE_SCOPES;
    value: () => string | string | boolean | number;
};
type DeviceIssueOption = {
    filterRule: FilterRule | object;
    isCategory?: boolean;
    key: string;
    needsFullFiltering?: boolean;
    needsMonitor?: boolean;
    needsReporting?: boolean;
    title: string;
};
declare const DEVICE_ISSUE_OPTIONS: {
    readonly issues: {
        readonly isCategory: true;
        readonly key: "issues";
        readonly title: "Devices with issues";
        readonly filterRule: {};
    };
    readonly offline: {
        readonly issueCategory: "issues";
        readonly key: "offline";
        readonly needsFullFiltering: true;
        readonly needsMonitor: false;
        readonly needsReporting: false;
        readonly filterRule: {
            readonly scope: "system";
            readonly key: "check_in_time";
            readonly operator: "$ltne";
            readonly value: ({ offlineThreshold }: {
                offlineThreshold: any;
            }) => any;
        };
        readonly title: "Offline devices";
    };
    readonly failedLastUpdate: {
        readonly issueCategory: "issues";
        readonly key: "failedLastUpdate";
        readonly needsFullFiltering: false;
        readonly needsMonitor: false;
        readonly needsReporting: true;
        readonly filterRule: {
            readonly scope: "monitor";
            readonly key: "failed_last_update";
            readonly operator: "$eq";
            readonly value: true;
        };
        readonly title: "Deployment failed";
    };
    readonly monitoring: {
        readonly issueCategory: "issues";
        readonly key: "monitoring";
        readonly needsFullFiltering: false;
        readonly needsMonitor: true;
        readonly needsReporting: false;
        readonly filterRule: {
            readonly scope: "monitor";
            readonly key: "alerts";
            readonly operator: "$eq";
            readonly value: true;
        };
        readonly title: "Monitoring alert";
    };
    readonly authRequests: {
        readonly key: "authRequests";
        readonly needsFullFiltering: false;
        readonly needsMonitor: false;
        readonly needsReporting: true;
        readonly filterRule: {
            readonly scope: "monitor";
            readonly key: "auth_requests";
            readonly operator: "$gt";
            readonly value: 1;
        };
        readonly title: "Devices with new authentication requests";
    };
    readonly gatewayDevices: {
        readonly key: "gatewayDevices";
        readonly needsFullFiltering: false;
        readonly needsMonitor: false;
        readonly needsReporting: true;
        readonly filterRule: {
            readonly scope: "inventory";
            readonly key: "mender_is_gateway";
            readonly operator: "$eq";
            readonly value: "true";
        };
        readonly title: "Gateway devices";
    };
};
type DeviceIssueOptionKey = keyof typeof DEVICE_ISSUE_OPTIONS;

export { ALL_DEVICES, ALL_DEVICE_STATES, ATTRIBUTE_SCOPES, DEVICE_FILTERING_OPTIONS, DEVICE_ISSUE_OPTIONS, DEVICE_STATES, type DeviceIssueOption, type DeviceIssueOptionKey, type FilterRule };
