import * as _northern_tech_utils_constants from '@northern.tech/utils/constants';
import { ReadState } from '../usersSlice/constants.cjs';
import { User, UserSession, CustomColumn, GlobalSettings, UserSettings } from '../usersSlice/index.cjs';
import { ReleaseSliceType } from '../releasesSlice/index.cjs';
import { OrganizationState } from '../organizationSlice/types.cjs';
import { OnboardingApproach } from '../onboardingSlice/index.cjs';
import * as _northern_tech_types_Alert from '@northern.tech/types/Alert';
import { DeviceSliceType } from '../devicesSlice/index.cjs';
import { SearchState, SentryConfig, SnackbarContent, Upload } from '../appSlice/index.cjs';
import * as reselect from 'reselect';
import { Deployment, DeploymentByStatus, SelectionState, DeploymentConfig } from './index.cjs';
import { RootState } from '../store.cjs';
import 'redux';
import '@reduxjs/toolkit';
import 'immer';
import '@northern.tech/types/MenderTypes';
import '../commonConstants.cjs';
import 'react/jsx-runtime';
import '../appSlice/constants.cjs';
import '@mui/material/OverridableComponent';
import '@mui/material';
import '../organizationSlice/constants.cjs';
import '../devicesSlice/constants.cjs';
import 'redux-thunk';

declare const getDeploymentsById: (state: RootState) => Record<string, Deployment>;
declare const getDeploymentsByStatus: (state: RootState) => DeploymentByStatus;
declare const getSelectedDeploymentDeviceIds: (state: RootState) => string[];
declare const getDeploymentsSelectionState: (state: RootState) => SelectionState;
declare const getMappedDeploymentSelection: ((state: any, deploymentsState: any) => any) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (resultFuncArgs_0: SelectionState, resultFuncArgs_1: any, resultFuncArgs_2: Record<string, Deployment>) => any;
    memoizedResultFunc: ((resultFuncArgs_0: SelectionState, resultFuncArgs_1: any, resultFuncArgs_2: Record<string, Deployment>) => any) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => any;
    dependencies: [(state: RootState) => SelectionState, (_: any, deploymentsState: any) => any, (state: RootState) => Record<string, Deployment>];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};
declare const DEPLOYMENT_CUTOFF = 3;
declare const getRecentDeployments: ((state: {
    app: {
        cancelSource: any;
        commit: string;
        demoArtifactLink: string;
        docsVersion: string;
        features: Record<string, boolean>;
        feedbackProbability: number;
        firstLoginAfterSignup: boolean;
        hostAddress: string | null;
        hostedAnnouncement: string;
        newThreshold: string;
        offlineThreshold: string;
        recaptchaSiteKey: string;
        searchState: SearchState;
        sentry: SentryConfig;
        snackbar: SnackbarContent;
        stripeAPIKey: string;
        trackerCode: string;
        uploadsById: Record<string, Upload>;
        versionInformation: {
            [key: string]: string | {
                releaseDate: string;
                repos: Record<string, string>;
            } | undefined;
            backend?: string;
            GUI?: string;
            latestRelease?: {
                releaseDate: string;
                repos: Record<string, string>;
            };
        };
        yesterday?: string;
    };
    devices: DeviceSliceType;
    deployments: {
        byId: Record<string, Deployment>;
        byStatus: DeploymentByStatus;
        config: DeploymentConfig;
        deploymentDeviceLimit: number;
        selectedDeviceIds: string[];
        selectionState: SelectionState;
    };
    monitor: {
        alerts: {
            alertList: {
                page: number;
                perPage: number;
                total: number;
            };
            byDeviceId: {
                alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
                latest?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
            };
        };
        issueCounts: {
            byType: {
                issues: {
                    filtered: number;
                    total: number;
                };
                offline: {
                    filtered: number;
                    total: number;
                };
                failedLastUpdate: {
                    filtered: number;
                    total: number;
                };
                monitoring: {
                    filtered: number;
                    total: number;
                };
                authRequests: {
                    filtered: number;
                    total: number;
                };
                gatewayDevices: {
                    filtered: number;
                    total: number;
                };
            };
        };
        settings: {
            global: {
                channels: {
                    email: {
                        enabled: boolean;
                    };
                };
            };
        };
    };
    onboarding: {
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    };
    organization: OrganizationState;
    releases: ReleaseSliceType;
    users: {
        activationCode?: string;
        byId: Record<string, User>;
        currentSession?: UserSession | object;
        currentUser: string | null;
        customColumns: CustomColumn[];
        globalSettings: GlobalSettings;
        permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
        qrCode: string | null;
        rolesById: Record<string, _northern_tech_utils_constants.Role>;
        rolesInitialized: boolean;
        settingsInitialized: boolean;
        showConnectDeviceDialog: boolean;
        showFeedbackDialog: boolean;
        showStartupNotification: boolean;
        tooltips: {
            byId: Record<string, {
                readState: ReadState;
            }>;
        };
        userSettings: UserSettings;
        userSettingsInitialized: boolean;
    };
}) => {
    total: number;
}) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (resultFuncArgs_0: Record<string, Deployment>, resultFuncArgs_1: DeploymentByStatus) => {
        total: number;
    };
    memoizedResultFunc: ((resultFuncArgs_0: Record<string, Deployment>, resultFuncArgs_1: DeploymentByStatus) => {
        total: number;
    }) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => {
        total: number;
    };
    dependencies: [(state: RootState) => Record<string, Deployment>, (state: RootState) => DeploymentByStatus];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};

export { DEPLOYMENT_CUTOFF, getDeploymentsById, getDeploymentsByStatus, getDeploymentsSelectionState, getMappedDeploymentSelection, getRecentDeployments, getSelectedDeploymentDeviceIds };
