import {
  getDeviceById
} from "./chunk-3P3IE42O.js";
import "./chunk-QKPV5RRN.js";
import "./chunk-H5FAPMJJ.js";
import {
  useAppDispatch
} from "./chunk-V3QEONX7.js";
import "./chunk-QHK7GGV4.js";
import "./chunk-RS37Y2PQ.js";
import "./chunk-F26IKSML.js";
import "./chunk-OOICURFL.js";
import "./chunk-UGSLGUS6.js";
import "./chunk-MZNANSS2.js";
import "./chunk-PGFVHKP5.js";
import "./chunk-VANBSJS5.js";
import "./chunk-VUFRP6P3.js";
import "./chunk-QYLGIR4W.js";
import "./chunk-ABJLRDCO.js";
import "./chunk-ZJW3QIPM.js";
import "./chunk-KC7SKI3U.js";
import "./chunk-NMAXZ3ZY.js";
import "./chunk-SCZLNFB5.js";
import "./chunk-MSOXMRF7.js";
import "./chunk-R6KRH2IY.js";
import "./chunk-YY6SKZDF.js";
import "./chunk-YO22XLHI.js";
import "./chunk-JIS4PA3R.js";
import {
  getDevicesById
} from "./chunk-KJNNEDRV.js";
import "./chunk-JXQUFKID.js";
import "./chunk-BYUPW7RA.js";
import "./chunk-UE5N5VO3.js";
import "./chunk-7C4SQBEE.js";
import "./chunk-2DYA3X77.js";
import "./chunk-FAJ3I2UQ.js";
import "./chunk-ZKAH3APE.js";
import "./chunk-HFOTAPIJ.js";

// src/useDeploymentDevice.ts
import { useEffect, useRef } from "react";
import { useSelector } from "react-redux";
import validator from "validator";
var { isUUID } = validator;
var useDeploymentDevice = (deploymentName) => {
  const isLoading = useRef(false);
  const dispatch = useAppDispatch();
  const devicesById = useSelector(getDevicesById);
  const hasDeviceInfo = !!devicesById[deploymentName];
  useEffect(() => {
    if (isLoading.current) {
      return;
    }
    isLoading.current = true;
    if (isUUID(deploymentName) && !hasDeviceInfo) {
      dispatch(getDeviceById(deploymentName)).then(() => isLoading.current = false);
    }
  }, [deploymentName, dispatch, hasDeviceInfo]);
};
export {
  useDeploymentDevice
};
//# sourceMappingURL=useDeploymentDevice.js.map