"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/usersSlice/selectors.ts
var selectors_exports = {};
__export(selectors_exports, {
  getCurrentSession: () => getCurrentSession,
  getCurrentUser: () => getCurrentUser,
  getGlobalSettings: () => getGlobalSettings,
  getHas2FA: () => getHas2FA,
  getIdAttribute: () => getIdAttribute,
  getIsDarkMode: () => getIsDarkMode,
  getOfflineThresholdSettings: () => getOfflineThresholdSettings,
  getReadAllHelptips: () => getReadAllHelptips,
  getRolesById: () => getRolesById,
  getRolesInitialized: () => getRolesInitialized,
  getRolesList: () => getRolesList,
  getSelectedDeviceAttribute: () => getSelectedDeviceAttribute,
  getTooltipsById: () => getTooltipsById,
  getTooltipsState: () => getTooltipsState,
  getUserSettings: () => getUserSettings,
  getUserSettingsInitialized: () => getUserSettingsInitialized,
  getUsersById: () => getUsersById,
  getUsersList: () => getUsersList
});
module.exports = __toCommonJS(selectors_exports);
var import_toolkit = require("@reduxjs/toolkit");

// src/constants.ts
var import_constants2 = require("@northern.tech/utils/constants");

// src/appSlice/constants.ts
var import_icons_material = require("@mui/icons-material");
var startingDeviceCount = {
  os: "for first 50 devices",
  professional: "for first 250 devices"
};
var chartTypes = {
  bar: { key: "bar", Icon: import_icons_material.BarChart },
  pie: { key: "pie", Icon: import_icons_material.PieChartOutline }
};
var emptyChartSelection = { software: "", group: "", chartType: chartTypes.bar.key, attribute: "artifact_name" };
var defaultReportType = "distribution";
var defaultReports = [{ ...emptyChartSelection, group: null, attribute: "artifact_name", type: defaultReportType }];
var PLANS = {
  os: {
    id: "os",
    name: "Basic",
    minimalDeviceCount: 50,
    offer: true,
    price: "$34 / month",
    deviceCount: startingDeviceCount.os,
    description: "The core features of Mender. To continue using Enterprise Trial features\u2014like Delta updates, scheduled deployments, phased rollouts, device filtering, dynamic groups, RBAC, audit logs, and more\u2014please upgrade to a higher plan.",
    features: ["Access to core features of Mender", "Basic support"]
  },
  professional: {
    id: "professional",
    name: "Professional",
    minimalDeviceCount: 250,
    offer: true,
    price: "$291 / month",
    deviceCount: startingDeviceCount.professional,
    description: "Everything in Basic, plus enhanced update management and automation features.",
    features: ["Advanced OTA features", "Higher priority support"]
  },
  enterprise: {
    id: "enterprise",
    name: "Enterprise",
    minimalDeviceCount: 1e3,
    price: "Custom pricing",
    deviceCount: "Unlimited devices",
    description: "Every advanced feature of Mender, tailored for complex and large-scale deployments. Not available as a monthly subscription \u2014 ask us for a quote.",
    features: ["All Mender features", "Advanced security features", "SLA-backed support"]
  }
};
var ADDONS = {
  configure: {
    id: "configure",
    title: "Configure",
    description: "Expand your plan with device configuration features",
    needs: ["hasDeviceConfig"],
    os: {
      price: "$11/month",
      deviceCount: startingDeviceCount.os
    },
    professional: {
      price: "$65/month",
      deviceCount: startingDeviceCount.professional
    },
    eligible: ["os", "professional", "enterprise"]
  },
  monitor: {
    id: "monitor",
    title: "Monitor",
    description: "Expand your plan with device monitoring features",
    needs: ["hasMonitor"],
    os: {
      price: "-",
      deviceCount: "-"
    },
    professional: {
      price: "$86/month",
      deviceCount: startingDeviceCount.professional
    },
    eligible: ["professional", "enterprise"]
  },
  troubleshoot: {
    id: "troubleshoot",
    title: "Troubleshoot",
    description: "Expand your plan with device troubleshooting features",
    needs: ["hasDeviceConnect"],
    os: {
      price: "$27/month",
      deviceCount: startingDeviceCount.os
    },
    professional: {
      price: "$72/month",
      deviceCount: startingDeviceCount.professional
    },
    eligible: ["os", "professional", "enterprise"]
  }
};
var BENEFITS = {
  auditlog: { id: "auditlog", benefit: "trace change across your devices and access troubleshooting session replay", requiredPlan: PLANS.professional.id },
  dashboard: { id: "dashboard", benefit: "actionable insights into the devices you are updating with Mender", requiredPlan: PLANS.enterprise.id },
  deltaGeneration: {
    id: "deltaGeneration",
    benefit: "automatic delta artifacts generation to minimize data transfer and improve the update delivery",
    requiredPlan: PLANS.enterprise.id
  },
  deviceConfiguration: { id: "deviceConfiguration", benefit: "device configuration features", requiredAddon: ADDONS.configure.id },
  deviceMonitor: { id: "deviceMonitor", benefit: "device monitoring features", requiredAddon: ADDONS.monitor.id, requiredPlan: PLANS.professional.id },
  deviceTroubleshoot: { id: "deviceTroubleshoot", benefit: "device troubleshooting features", requiredAddon: ADDONS.troubleshoot.id },
  dynamicGroups: { id: "dynamicGroups", benefit: "create dynamic groups to ease device management", requiredPlan: PLANS.enterprise.id },
  fullFiltering: { id: "fullFiltering", benefit: "filtering by multiple attributes to improve the device overview", requiredPlan: PLANS.professional.id },
  gateway: { id: "gateway", benefit: "see devices connected to your gateway device for easy access", requiredPlans: PLANS.professional.id },
  pausedDeployments: {
    id: "pausedDeployments",
    benefit: "granular control about update rollout to allow synchronization across your fleet",
    requiredPlan: PLANS.enterprise.id
  },
  phasedDeployments: { id: "phasedDeployments", benefit: "choose to roll out deployments in multiple phases", requiredPlan: PLANS.enterprise.id },
  rbac: { id: "rbac", benefit: "granular role based access control", requiredPlan: PLANS.enterprise.id },
  retryDeployments: { id: "retryDeployments", benefit: "optional retries for failed rollout attempts", requiredPlan: PLANS.professional.id },
  scheduledDeployments: {
    id: "scheduledDeployments",
    benefit: "scheduled deployments to steer the distribution of your updates.",
    requiredPlan: PLANS.professional.id
  },
  webhookEvents: {
    id: "webhookEvents",
    benefit: "receive inventory events and select which type(s) of events the webhook will receive",
    requiredPlan: PLANS.professional.id
  },
  default: { id: "default", benefit: "gain access to this feature", requiredPlan: PLANS.enterprise.id }
};
var DARK_MODE = "dark";

// src/commonConstants.tsx
var import_js = require("@mdi/js");
var import_MenderTypes = require("@northern.tech/types/MenderTypes");
var import_jsx_runtime = require("react/jsx-runtime");
var timeUnits = {
  days: "days",
  minutes: "minutes",
  hours: "hours"
};
var oneSecond = 1e3;
var TIMEOUTS = {
  debounceDefault: 700,
  debounceShort: 300,
  halfASecond: 0.5 * oneSecond,
  oneSecond,
  twoSeconds: 2 * oneSecond,
  threeSeconds: 3 * oneSecond,
  fiveSeconds: 5 * oneSecond,
  refreshDefault: 10 * oneSecond,
  refreshLong: 60 * oneSecond
};
var DEVICE_ONLINE_CUTOFF = { interval: 1, intervalName: timeUnits.days };
var defaultIdAttribute = Object.freeze({ attribute: "id", scope: import_constants2.ATTRIBUTE_SCOPES.identity });
var credentialTypes = {
  aws: import_MenderTypes.Credentials.type.AWS,
  http: import_MenderTypes.Credentials.type.HTTP,
  sas: import_MenderTypes.Credentials.type.SAS,
  x509: "x509"
};
var EXTERNAL_PROVIDER = {
  "iot-core": {
    credentialsType: credentialTypes.aws,
    icon: import_js.mdiAws,
    title: "AWS IoT Core",
    twinTitle: "Device Shadow",
    provider: "iot-core",
    enabled: true,
    deviceTwin: true,
    configHint: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_jsx_runtime.Fragment, { children: "For help finding your AWS IoT Core connection string, check the AWS IoT documentation." })
  },
  "iot-hub": {
    credentialsType: credentialTypes.sas,
    icon: import_js.mdiMicrosoftAzure,
    title: "Azure IoT Hub",
    twinTitle: "Device Twin",
    provider: "iot-hub",
    enabled: true,
    deviceTwin: true,
    configHint: /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("span", { children: [
      "For help finding your Azure IoT Hub connection string, look under 'Shared access policies' in the Microsoft Azure UI as described",
      " ",
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
        "a",
        {
          href: "https://devblogs.microsoft.com/iotdev/understand-different-connection-strings-in-azure-iot-hub/#iothubconn",
          target: "_blank",
          rel: "noopener noreferrer",
          children: "here"
        }
      ),
      "."
    ] })
  },
  webhook: {
    credentialsType: credentialTypes.http,
    deviceTwin: false,
    twinTitle: "",
    // disable the webhook provider here, since it is treated different than other integrations, with a custom configuration & management view, etc.
    enabled: false,
    provider: "webhook"
  }
};
var emptyWebhook = {
  description: "",
  provider: import_MenderTypes.Integration.provider.WEBHOOK,
  credentials: {
    type: EXTERNAL_PROVIDER.webhook.credentialsType,
    [EXTERNAL_PROVIDER.webhook.credentialsType]: {
      secret: "",
      url: ""
    }
  }
};
var regionNames = new Intl.DisplayNames(["en"], { type: "region" });
var countries = [
  "AD",
  "AE",
  "AF",
  "AG",
  "AI",
  "AL",
  "AM",
  "AO",
  "AQ",
  "AR",
  "AS",
  "AT",
  "AU",
  "AW",
  "AX",
  "AZ",
  "BA",
  "BB",
  "BD",
  "BE",
  "BF",
  "BG",
  "BH",
  "BI",
  "BJ",
  "BL",
  "BM",
  "BN",
  "BO",
  "BR",
  "BS",
  "BT",
  "BV",
  "BW",
  "BY",
  "BZ",
  "CA",
  "CC",
  "CD",
  "CF",
  "CG",
  "CH",
  "CI",
  "CK",
  "CL",
  "CM",
  "CN",
  "CO",
  "CR",
  "CU",
  "CV",
  "CW",
  "CX",
  "CY",
  "CZ",
  "DE",
  "DJ",
  "DK",
  "DM",
  "DO",
  "DZ",
  "EC",
  "EE",
  "EG",
  "EH",
  "ER",
  "ES",
  "ET",
  "FI",
  "FJ",
  "FK",
  "FM",
  "FO",
  "FR",
  "GA",
  "GB",
  "GD",
  "GE",
  "GF",
  "GG",
  "GH",
  "GI",
  "GL",
  "GM",
  "GN",
  "GP",
  "GQ",
  "GR",
  "GS",
  "GT",
  "GU",
  "GW",
  "GY",
  "HK",
  "HM",
  "HN",
  "HR",
  "HT",
  "HU",
  "ID",
  "IE",
  "IL",
  "IM",
  "IN",
  "IO",
  "IQ",
  "IR",
  "IS",
  "IT",
  "JE",
  "JM",
  "JO",
  "JP",
  "KE",
  "KG",
  "KH",
  "KI",
  "KM",
  "KN",
  "KP",
  "KR",
  "KW",
  "KY",
  "KZ",
  "LA",
  "LB",
  "LC",
  "LI",
  "LK",
  "LR",
  "LS",
  "LT",
  "LU",
  "LV",
  "LY",
  "MA",
  "MC",
  "MD",
  "ME",
  "MF",
  "MG",
  "MH",
  "MK",
  "ML",
  "MM",
  "MN",
  "MO",
  "MP",
  "MQ",
  "MR",
  "MS",
  "MT",
  "MU",
  "MV",
  "MW",
  "MX",
  "MY",
  "MZ",
  "NA",
  "NC",
  "NE",
  "NF",
  "NG",
  "NI",
  "NL",
  "NO",
  "NP",
  "NR",
  "NU",
  "NZ",
  "OM",
  "PA",
  "PE",
  "PF",
  "PG",
  "PH",
  "PK",
  "PL",
  "PM",
  "PN",
  "PR",
  "PS",
  "PT",
  "PW",
  "PY",
  "QA",
  "RE",
  "RO",
  "RS",
  "RU",
  "RW",
  "SA",
  "SB",
  "SC",
  "SD",
  "SE",
  "SG",
  "SH",
  "SI",
  "SJ",
  "SK",
  "SL",
  "SM",
  "SN",
  "SO",
  "SR",
  "SS",
  "ST",
  "SV",
  "SX",
  "SY",
  "SZ",
  "TC",
  "TD",
  "TF",
  "TG",
  "TH",
  "TJ",
  "TK",
  "TL",
  "TM",
  "TN",
  "TO",
  "TR",
  "TT",
  "TV",
  "TW",
  "TZ",
  "UA",
  "UG",
  "US",
  "UY",
  "UZ",
  "VA",
  "VC",
  "VE",
  "VG",
  "VI",
  "VN",
  "VU",
  "WF",
  "WS",
  "XK",
  "YE",
  "YT",
  "ZA",
  "ZM",
  "ZW"
].map((code) => ({ code, label: regionNames.of(code) })).sort((a, b) => a.label.localeCompare(b.label));

// src/usersSlice/constants.ts
var READ_STATES = {
  read: "read",
  seen: "seen",
  unread: "unread"
};

// src/utils.ts
var import_helpers = require("@northern.tech/utils/helpers");
var filterProcessors = {
  [import_constants2.DEVICE_FILTERING_OPTIONS.$gt.key]: (val) => Number(val) || val,
  [import_constants2.DEVICE_FILTERING_OPTIONS.$gte.key]: (val) => Number(val) || val,
  [import_constants2.DEVICE_FILTERING_OPTIONS.$lt.key]: (val) => Number(val) || val,
  [import_constants2.DEVICE_FILTERING_OPTIONS.$lte.key]: (val) => Number(val) || val,
  [import_constants2.DEVICE_FILTERING_OPTIONS.$ltne.key]: (val) => Number(val) || val,
  [import_constants2.DEVICE_FILTERING_OPTIONS.$in.key]: (val) => ("" + val).split(",").map((i) => i.trim()),
  [import_constants2.DEVICE_FILTERING_OPTIONS.$nin.key]: (val) => ("" + val).split(",").map((i) => i.trim()),
  [import_constants2.DEVICE_FILTERING_OPTIONS.$exists.key]: import_helpers.yes,
  [import_constants2.DEVICE_FILTERING_OPTIONS.$nexists.key]: () => false
};
var filterAliases = {
  $nexists: { alias: import_constants2.DEVICE_FILTERING_OPTIONS.$exists.key, value: false }
};
var isDarkMode = (mode) => mode === DARK_MODE;

// src/usersSlice/selectors.ts
var emptyObject = {};
var getRolesById = (state) => state.users.rolesById;
var getTooltipsById = (state) => state.users.tooltips.byId;
var getGlobalSettings = (state) => state.users.globalSettings;
var getUserSettingsInitialized = (state) => state.users.settingsInitialized;
var getCurrentUserId = (state) => state.users.currentUser;
var getUsersById = (state) => state.users.byId;
var getUsersList = (0, import_toolkit.createSelector)([getUsersById], (usersById) => Object.values(usersById));
var getCurrentUser = (0, import_toolkit.createSelector)(
  [getUsersById, getCurrentUserId],
  (usersById, userId) => userId ? usersById[userId] ?? emptyObject : emptyObject
);
var getUserSettings = (state) => state.users.userSettings;
var getSelectedDeviceAttribute = (0, import_toolkit.createSelector)(
  [getUserSettings],
  ({ columnSelection }) => columnSelection.map((attribute) => ({ attribute: attribute.key, scope: attribute.scope }))
);
var getIsDarkMode = (0, import_toolkit.createSelector)([getUserSettings], ({ mode }) => isDarkMode(mode));
var getReadAllHelptips = (0, import_toolkit.createSelector)(
  [getTooltipsById],
  (tooltips) => Object.values(tooltips).every(({ readState }) => readState === READ_STATES.read)
);
var getTooltipsState = (0, import_toolkit.createSelector)(
  [getTooltipsById, getUserSettings],
  (byId, { tooltips = {} }) => Object.entries(byId).reduce(
    (accu, [id, value]) => {
      accu[id] = { ...accu[id], ...value };
      return accu;
    },
    { ...tooltips }
  )
);
var getHas2FA = (0, import_toolkit.createSelector)(
  [getCurrentUser],
  (currentUser) => currentUser.hasOwnProperty("tfa_status") && currentUser.tfa_status === import_constants2.twoFAStates.enabled
);
var getIdAttribute = (0, import_toolkit.createSelector)([getGlobalSettings], ({ id_attribute = { ...defaultIdAttribute } }) => id_attribute);
var getOfflineThresholdSettings = (0, import_toolkit.createSelector)([getGlobalSettings], ({ offlineThreshold }) => ({
  interval: offlineThreshold?.interval || DEVICE_ONLINE_CUTOFF.interval,
  intervalUnit: offlineThreshold?.intervalUnit || DEVICE_ONLINE_CUTOFF.intervalName
}));
var getRolesList = (0, import_toolkit.createSelector)([getRolesById], (rolesById2) => Object.entries(rolesById2).map(([value, role]) => ({ value, ...role })));
var getCurrentSession = (state) => state.users.currentSession;
var getRolesInitialized = (state) => state.users.rolesInitialized;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  getCurrentSession,
  getCurrentUser,
  getGlobalSettings,
  getHas2FA,
  getIdAttribute,
  getIsDarkMode,
  getOfflineThresholdSettings,
  getReadAllHelptips,
  getRolesById,
  getRolesInitialized,
  getRolesList,
  getSelectedDeviceAttribute,
  getTooltipsById,
  getTooltipsState,
  getUserSettings,
  getUserSettingsInitialized,
  getUsersById,
  getUsersList
});
//# sourceMappingURL=selectors.cjs.map