"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/ExpandableAttribute.tsx
var ExpandableAttribute_exports = {};
__export(ExpandableAttribute_exports, {
  ExpandableAttribute: () => ExpandableAttribute,
  default: () => ExpandableAttribute_default
});
module.exports = __toCommonJS(ExpandableAttribute_exports);
var import_react = require("react");
var import_icons_material = require("@mui/icons-material");
var import_material = require("@mui/material");
var import_helpers = require("@northern.tech/utils/helpers");
var import_copy_to_clipboard = __toESM(require("copy-to-clipboard"), 1);
var import_jsx_runtime = require("react/jsx-runtime");
var defaultClasses = { root: "attributes" };
var ExpandableAttribute = ({
  className = "",
  copyToClipboard,
  dividerDisabled,
  onExpansion,
  primary,
  secondary,
  secondaryTypographyProps = {},
  setSnackbar,
  style,
  textClasses,
  ...remainder
}) => {
  const textContent = (0, import_react.useRef)(null);
  const [expanded, setExpanded] = (0, import_react.useState)(false);
  const [overflowActive, setOverflowActive] = (0, import_react.useState)(false);
  const [tooltipVisible, setTooltipVisible] = (0, import_react.useState)(false);
  (0, import_react.useEffect)(() => {
    if (textContent.current) {
      const overflowActiveCurrently = textContent.current.scrollWidth > textContent.current.clientWidth || textContent.current.scrollHeight > textContent.current.clientHeight;
      if (overflowActive !== overflowActiveCurrently && !expanded) {
        setOverflowActive(overflowActiveCurrently);
      }
    }
  }, [expanded, overflowActive, textContent]);
  const onClick = (0, import_react.useCallback)(() => {
    if (copyToClipboard && setSnackbar) {
      (0, import_copy_to_clipboard.default)(secondary);
      setSnackbar("Value copied to clipboard");
    }
    if (!expanded && !!onExpansion) {
      onExpansion();
    }
    setExpanded(import_helpers.toggle);
  }, [copyToClipboard, expanded, onExpansion, secondary, setSnackbar]);
  const currentTextClasses = `${textClasses ? textClasses.secondary : "inventory-text"}${expanded && overflowActive ? " expanded-attribute" : ""}`;
  const secondaryText = /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_jsx_runtime.Fragment, { children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)("span", { className: currentTextClasses, ref: textContent, children: secondary }),
    " ",
    overflowActive ? /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("a", { children: [
      "show ",
      expanded ? "less" : "more"
    ] }) : null
  ] });
  const cssClasses = { ...defaultClasses, root: `${defaultClasses.root} ${copyToClipboard ? "copy-to-clipboard" : ""}`.trim() };
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className, onClick, onMouseEnter: () => setTooltipVisible(true), onMouseLeave: () => setTooltipVisible(false), style, children: /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_material.ListItem, { classes: cssClasses, divider: !dividerDisabled, ...remainder, children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
      import_material.ListItemText,
      {
        primary,
        secondary: secondaryText,
        secondaryTypographyProps: { title: secondary, component: "div", ...secondaryTypographyProps }
      }
    ),
    copyToClipboard ? /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.Tooltip, { title: "Copy to clipboard", placement: "top", open: tooltipVisible, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_icons_material.FileCopyOutlined, { fontSize: "small" }) }) : null
  ] }) });
};
var ExpandableAttribute_default = ExpandableAttribute;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ExpandableAttribute
});
//# sourceMappingURL=ExpandableAttribute.cjs.map