"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/appSlice/mocks.ts
var mocks_exports = {};
__export(mocks_exports, {
  mockState: () => mockState
});
module.exports = __toCommonJS(mocks_exports);

// src/appSlice/index.ts
var import_toolkit = require("@reduxjs/toolkit");

// src/constants.ts
var import_constants = require("@northern.tech/utils/constants");

// src/appSlice/index.ts
var sliceName = "app";
var getYesterday = () => {
  const today = /* @__PURE__ */ new Date();
  today.setDate(today.getDate() - 1);
  return today.toISOString();
};
var initialState = {
  cancelSource: void 0,
  commit: "",
  demoArtifactLink: "https://dgsbl4vditpls.cloudfront.net/mender-demo-artifact.mender",
  hostAddress: null,
  snackbar: {
    action: void 0,
    autoHideDuration: void 0,
    message: "",
    open: false,
    preventClickToCopy: false
  },
  // return boolean rather than organization details
  features: {
    hasAuditlogs: false,
    hasDeltaProgress: false,
    hasMultitenancy: false,
    hasDeviceConfig: false,
    hasDeviceConnect: false,
    hasFeedbackEnabled: false,
    hasMonitor: false,
    hasReporting: false,
    isHosted: true,
    isEnterprise: false
  },
  feedbackProbability: 0.3,
  firstLoginAfterSignup: false,
  hostedAnnouncement: "",
  docsVersion: "",
  recaptchaSiteKey: "",
  searchState: {
    deviceIds: [],
    searchTerm: "",
    searchTotal: 0,
    isSearching: false,
    sort: {
      direction: import_constants.SORTING_OPTIONS.desc
      // key: null,
      // scope: null
    }
  },
  sentry: {
    location: "",
    replaysSessionSampleRate: 0.1,
    tracesSampleRate: 1
  },
  stripeAPIKey: "",
  trackerCode: "",
  uploadsById: {
    // id: { progress: 0, cancelSource: undefined }
  },
  newThreshold: getYesterday(),
  offlineThreshold: getYesterday(),
  versionInformation: {
    Integration: "",
    "Mender-Client": "",
    "Mender-Artifact": "",
    "Meta-Mender": ""
  },
  yesterday: void 0
};
var appSlice = (0, import_toolkit.createSlice)({
  name: sliceName,
  initialState,
  reducers: {
    setFeatures: (state, action) => {
      state.features = {
        ...state.features,
        ...action.payload
      };
    },
    setSnackbar: (state, { payload }) => {
      if (typeof payload === "string" || payload instanceof String) {
        state.snackbar = {
          ...initialState.snackbar,
          message: payload,
          open: !!payload
        };
        return;
      }
      const { message, autoHideDuration, action, preventClickToCopy = false } = payload;
      state.snackbar = {
        message,
        autoHideDuration,
        action,
        preventClickToCopy,
        open: !!message
      };
    },
    setFirstLoginAfterSignup: (state, action) => {
      state.firstLoginAfterSignup = action.payload;
    },
    setAnnouncement: (state, action) => {
      state.hostedAnnouncement = action.payload;
    },
    setSearchState: (state, action) => {
      state.searchState = {
        ...state.searchState,
        ...action.payload
      };
    },
    setOfflineThreshold: (state, action) => {
      state.offlineThreshold = action.payload;
    },
    initUpload: (state, action) => {
      const { id, upload } = action.payload;
      state.uploadsById[id] = upload;
    },
    uploadProgress: (state, action) => {
      const { id, progress } = action.payload;
      state.uploadsById[id] = {
        ...state.uploadsById[id],
        progress
      };
    },
    cleanUpUpload: (state, action) => {
      const { [action.payload]: current, ...remainder } = state.uploadsById;
      state.uploadsById = remainder;
    },
    setVersionInformation: (state, action) => {
      state.versionInformation = {
        ...state.versionInformation,
        ...action.payload
      };
    },
    setEnvironmentData: (state, action) => ({ ...state, ...action.payload })
  }
});
var actions = appSlice.actions;
var appSlice_default = appSlice.reducer;

// src/appSlice/mocks.ts
var mockState = {
  ...initialState,
  searchState: {
    ...initialState.searchState,
    deviceIds: [],
    searchTerm: "",
    searchTotal: 0,
    sort: {}
  },
  snackbar: {},
  uploadsById: {},
  versionInformation: {}
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  mockState
});
//# sourceMappingURL=mocks.cjs.map