import {
  initialState
} from "../chunk-PGFVHKP5.js";
import {
  DEVICE_ISSUE_OPTIONS,
  DEVICE_LIST_DEFAULTS
} from "../chunk-7C4SQBEE.js";
import "../chunk-2DYA3X77.js";
import "../chunk-FAJ3I2UQ.js";
import "../chunk-ZKAH3APE.js";
import "../chunk-HFOTAPIJ.js";

// src/monitorSlice/mocks.ts
var mockState = {
  ...initialState,
  alerts: {
    alertList: { ...DEVICE_LIST_DEFAULTS, total: 0 },
    byDeviceId: {
      a1: {
        alerts: [
          {
            description: "something",
            id: "31346239-3839-6262-2d63-3365622d3437",
            name: "SSH Daemon is not running",
            device_id: "a1",
            level: "CRITICAL",
            subject: {
              name: "sshd",
              type: "systemd",
              status: "not-running",
              details: { description: "Jul 22 10:40:56 raspberrypi sshd[32031]: pam_unix(sshd:session): session closed for user root" }
            },
            timestamp: "2021-07-23T12:22:36Z"
          }
        ],
        latest: []
      }
    }
  },
  issueCounts: {
    byType: Object.values(DEVICE_ISSUE_OPTIONS).reduce(
      (accu, { isCategory, key }) => {
        if (isCategory) {
          return accu;
        }
        accu[key] = accu[key] ?? { filtered: 0, total: 0 };
        return accu;
      },
      {
        [DEVICE_ISSUE_OPTIONS.authRequests.key]: { filtered: 0, total: 0 },
        [DEVICE_ISSUE_OPTIONS.monitoring.key]: { filtered: 3, total: 0 },
        [DEVICE_ISSUE_OPTIONS.offline.key]: { filtered: 0, total: 0 }
      }
    )
  },
  settings: {
    global: {
      channels: { email: { enabled: true } }
    }
  }
};
export {
  mockState
};
//# sourceMappingURL=mocks.js.map