import { SnackbarContent } from '../appSlice/index.cjs';
import * as _reduxjs_toolkit from '@reduxjs/toolkit';
import { AppDispatch, RootState } from '../store.cjs';
import { ArtifactUpdate, ReleaseUpdate, Tags } from '@northern.tech/types/MenderTypes';
import { Release, ReleasesList } from './index.cjs';
import 'redux';
import 'immer';
import '@mui/material';
import '@northern.tech/utils/constants';
import 'redux-thunk';
import '../usersSlice/constants.cjs';
import '../usersSlice/index.cjs';
import '../commonConstants.cjs';
import 'react/jsx-runtime';
import '../organizationSlice/types.cjs';
import '../appSlice/constants.cjs';
import '@mui/material/OverridableComponent';
import '../organizationSlice/constants.cjs';
import '../onboardingSlice/index.cjs';
import '@northern.tech/types/Alert';
import '../deploymentsSlice/index.cjs';
import '../devicesSlice/index.cjs';
import '../devicesSlice/constants.cjs';

declare const getArtifactInstallCount: _reduxjs_toolkit.AsyncThunk<{
    payload: Release;
    type: "releases/receiveRelease";
} | undefined, string, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getArtifactUrl: _reduxjs_toolkit.AsyncThunk<any, string, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
type ArtifactPayload = {
    file: File;
    meta: {
        args?: {
            dest_dir: string;
            filename: string;
            software_filesystem: string;
            software_name: string;
            software_version: string;
        };
        description: string;
        device_types_compatible?: string[];
        name?: string;
    };
};
declare const createArtifact: _reduxjs_toolkit.AsyncThunk<{
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}, ArtifactPayload, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const uploadArtifact: _reduxjs_toolkit.AsyncThunk<any[] | {
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}, ArtifactPayload, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const cancelFileUpload: _reduxjs_toolkit.AsyncThunk<{
    payload: string;
    type: "app/cleanUpUpload";
}, string, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const editArtifact: _reduxjs_toolkit.AsyncThunk<any, {
    body: ArtifactUpdate;
    id: string;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const removeArtifact: _reduxjs_toolkit.AsyncThunk<any, string, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const removeRelease: _reduxjs_toolkit.AsyncThunk<_reduxjs_toolkit.PayloadAction<any[], string, {
    arg: string | Release | null;
    requestId: string;
    requestStatus: "fulfilled";
}, never> | _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: string | Release | null;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError>, string, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const removeReleases: _reduxjs_toolkit.AsyncThunk<any[], string[], {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const selectRelease: _reduxjs_toolkit.AsyncThunk<any[], string | Release | null, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const setReleasesListState: _reduxjs_toolkit.AsyncThunk<any[], Partial<ReleasesList>, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getReleases: _reduxjs_toolkit.AsyncThunk<any[], Partial<ReleasesList> | undefined, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getRelease: _reduxjs_toolkit.AsyncThunk<null, string, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const updateReleaseInfo: _reduxjs_toolkit.AsyncThunk<[{
    payload: Release;
    type: "releases/receiveRelease";
}, {
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}], {
    info: ReleaseUpdate;
    name: string;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const setSingleReleaseTags: _reduxjs_toolkit.AsyncThunk<{
    payload: Release;
    type: "releases/receiveRelease";
}, {
    name: string;
    tags: Tags;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const setReleaseTags: _reduxjs_toolkit.AsyncThunk<{
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}, {
    name: string;
    tags: Tags;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const setReleasesTags: _reduxjs_toolkit.AsyncThunk<{
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}, {
    releases: Release[];
    tags: Tags;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getExistingReleaseTags: _reduxjs_toolkit.AsyncThunk<{
    payload: string[];
    type: "releases/receiveReleaseTags";
}, void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getUpdateTypes: _reduxjs_toolkit.AsyncThunk<{
    payload: string[];
    type: "releases/receiveReleaseTypes";
}, void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;

export { cancelFileUpload, createArtifact, editArtifact, getArtifactInstallCount, getArtifactUrl, getExistingReleaseTags, getRelease, getReleases, getUpdateTypes, removeArtifact, removeRelease, removeReleases, selectRelease, setReleaseTags, setReleasesListState, setReleasesTags, setSingleReleaseTags, updateReleaseInfo, uploadArtifact };
