import {
  ConfirmationButtons,
  EditButton
} from "./chunk-3VW6XNOP.js";

// src/DeviceNameInput.tsx
import { useEffect, useRef, useState } from "react";
import { InputAdornment, OutlinedInput } from "@mui/material";
import { makeStyles } from "tss-react/mui";
import { useAppDispatch } from "@northern.tech/store/store";
import { setDeviceTags } from "@northern.tech/store/thunks";
import { jsx } from "react/jsx-runtime";
var useStyles = makeStyles()((theme) => ({
  icon: {
    fontSize: "1.25rem"
  },
  input: {
    color: theme.palette.text.primary,
    fontSize: "0.8125rem"
  }
}));
var DeviceNameInput = ({ device, isHovered }) => {
  const [isEditing, setIsEditing] = useState(false);
  const [value, setValue] = useState("");
  const { classes } = useStyles();
  const inputRef = useRef(void 0);
  const dispatch = useAppDispatch();
  const { id = "", tags = {} } = device;
  const { name = "" } = tags;
  useEffect(() => {
    if (!isEditing && name !== value) {
      setValue(name);
    }
  }, [device, isEditing, name, value]);
  useEffect(() => {
    if (!isEditing || !inputRef.current) {
      return;
    }
    inputRef.current.focus();
  }, [isEditing]);
  const onSubmit = () => dispatch(setDeviceTags({ deviceId: id, tags: { ...tags, name: value } })).then(() => setIsEditing(false));
  const onCancel = () => {
    setValue(name);
    setIsEditing(false);
  };
  const onStartEdit = (e) => {
    e.stopPropagation();
    setIsEditing(true);
  };
  const onInputClick = (e) => e.stopPropagation();
  return /* @__PURE__ */ jsx(
    OutlinedInput,
    {
      id: `${device.id}-id-input`,
      className: classes.input,
      disabled: !isEditing,
      inputRef,
      value,
      placeholder: `${id.substring(0, 6)}...`,
      onClick: onInputClick,
      onChange: ({ target: { value: value2 } }) => setValue(value2),
      type: "text",
      endAdornment: (isHovered || isEditing) && /* @__PURE__ */ jsx(InputAdornment, { position: "end", children: isEditing ? /* @__PURE__ */ jsx(ConfirmationButtons, { onCancel, onConfirm: onSubmit }) : /* @__PURE__ */ jsx(EditButton, { onClick: onStartEdit }) })
    }
  );
};
var DeviceNameInput_default = DeviceNameInput;

export {
  DeviceNameInput,
  DeviceNameInput_default
};
//# sourceMappingURL=chunk-MW3FXC7K.js.map