import { UserSession } from './usersSlice/index.cjs';
import 'redux';
import '@reduxjs/toolkit';
import 'immer';
import '@northern.tech/types/MenderTypes';
import '@northern.tech/utils/constants';
import './commonConstants.cjs';
import 'react/jsx-runtime';
import './usersSlice/constants.cjs';

declare const getSessionInfo: () => UserSession;
declare const getToken: () => string;
declare const setSessionInfo: ({ token, expiresAt }: UserSession) => void;
declare const cleanUp: () => void;
declare const updateMaxAge: ({ expiresAt, token }: {
    expiresAt: any;
    token: any;
}) => void;

export { cleanUp, getSessionInfo, getToken, setSessionInfo, updateMaxAge };
