import {
  EXTERNAL_PROVIDER
} from "./chunk-7C4SQBEE.js";

// src/organizationSlice/selectors.ts
import { createSelector } from "@reduxjs/toolkit";
import dayjs from "dayjs";
import relativeTime from "dayjs/plugin/relativeTime.js";
var getOrganization = (state) => state.organization.organization;
var getExternalIntegrations = (state) => state.organization.externalDeviceIntegrations;
var getAuditlogState = (state) => state.organization.auditlog.selectionState;
var getAuditLog = (state) => state.organization.auditlog.events;
var getAuditLogSelectionState = (state) => state.organization.auditlog.selectionState;
var getBillingProfile = (state) => state.organization.organization.billing_profile;
var getSubscription = (state) => state.organization.organization.subscription;
var getCard = (state) => state.organization.card;
var getSsoConfig = ({ organization: { ssoConfigs = [] } }) => ssoConfigs[0];
var getTenantsList = (state) => state.organization.tenantList;
var getWebhookEvents = (state) => state.organization.webhooks.events;
var getWebhookEventTotal = (state) => state.organization.webhooks.eventsTotal;
var getDeviceTwinIntegrations = createSelector(
  [getExternalIntegrations],
  (integrations) => integrations.filter((integration) => integration.id && EXTERNAL_PROVIDER[integration.provider]?.deviceTwin)
);
var getIsServiceProvider = (state) => state.organization.organization.service_provider;
var getWebhooks = createSelector(
  [getExternalIntegrations],
  (integrations) => integrations.filter((integration) => integration.id && integration.provider === EXTERNAL_PROVIDER.webhook.provider)
);
var getWebhookEventInfo = createSelector(
  [getWebhooks, getWebhookEvents, getWebhookEventTotal],
  (webhooks, events, eventTotal) => webhooks.length ? { events, eventTotal } : { events: [], eventTotal: 0 }
);
var getAuditLogEntry = createSelector([getAuditLog, getAuditLogSelectionState], (events, { selectedId }) => {
  if (!selectedId) {
    return;
  }
  const [eventAction, eventTime] = atob(selectedId).split("|");
  return events.find((item) => item.action === eventAction && item.time === eventTime);
});
dayjs.extend(relativeTime);
var newPricingIntroduction = dayjs("2025-06-03T00:00");
var getHasCurrentPricing = createSelector(
  [getOrganization],
  ({ id }) => !!id && dayjs(parseInt(id.substring(0, 8), 16) * 1e3) >= newPricingIntroduction
);

export {
  getOrganization,
  getExternalIntegrations,
  getAuditlogState,
  getAuditLog,
  getAuditLogSelectionState,
  getBillingProfile,
  getSubscription,
  getCard,
  getSsoConfig,
  getTenantsList,
  getWebhookEvents,
  getWebhookEventTotal,
  getDeviceTwinIntegrations,
  getIsServiceProvider,
  getWebhooks,
  getWebhookEventInfo,
  getAuditLogEntry,
  getHasCurrentPricing
};
//# sourceMappingURL=chunk-YY6SKZDF.js.map