import { Addon } from './Addon.js';
import { Plan } from './Plan.js';
import { TenantAdditionalInfo } from './TenantAdditionalInfo.js';
import { TenantApiLimits } from './TenantApiLimits.js';
import './Features.js';
import './ApiLimits.js';
import './ApiBurst.js';
import './ApiQuota.js';

/**
 * Tenant descriptor.
 */
type TenantV1 = {
    /**
     * Tenant ID.
     */
    id: string;
    /**
     * Name of the tenant's organization.
     */
    name: string;
    /**
     * Currently used tenant token.
     */
    tenant_token: string;
    /**
     * Status of the tenant account.
     */
    status?: TenantV1.status;
    plan?: Plan;
    /**
     * Whether this account is free trial.
     */
    trial?: boolean;
    /**
     * When trial evaluation expires.
     */
    trial_expiration?: string;
    /**
     * Addons configuration.
     */
    addons?: Array<Addon>;
    /**
     * Whether this account is a service provider.
     */
    service_provider?: boolean;
    additional_info?: TenantAdditionalInfo;
    api_limits?: TenantApiLimits;
    /**
     * Creation date and time, in ISO8601 format.
     */
    created_at?: string;
};
declare namespace TenantV1 {
    /**
     * Status of the tenant account.
     */
    enum status {
        ACTIVE = "active",
        SUSPENDED = "suspended"
    }
}

export { TenantV1 };
