"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/retrytimer.ts
var retrytimer_exports = {};
__export(retrytimer_exports, {
  clearAllRetryTimers: () => clearAllRetryTimers,
  clearRetryTimer: () => clearRetryTimer,
  setRetryTimer: () => setRetryTimer
});
module.exports = __toCommonJS(retrytimer_exports);

// src/helpers.ts
var import_dayjs = __toESM(require("dayjs"), 1);
var import_utc = __toESM(require("dayjs/plugin/utc.js"), 1);
var import_pluralize = __toESM(require("pluralize"), 1);
var import_universal_cookie = __toESM(require("universal-cookie"), 1);
import_dayjs.default.extend(import_utc.default);
var cookies = new import_universal_cookie.default();
var extractErrorMessage = (err, fallback = "") => err.response?.data?.error?.message || err.response?.data?.error || err.error || err.message || fallback;
var preformatWithRequestID = (res, failMsg) => {
  if (failMsg.length > 100) failMsg = `${failMsg.substring(0, 220)}...`;
  try {
    if (res?.data && Object.keys(res.data).includes("request_id")) {
      const shortRequestUUID = res.data["request_id"].substring(0, 8);
      return `${failMsg} [Request ID: ${shortRequestUUID}]`;
    }
  } catch (e) {
    console.log("failed to extract request id:", e);
  }
  return failMsg;
};

// src/retrytimer.ts
var oneSecond = 1e3;
var timers = {};
function setRetryTimer(err, service, errorContext, timeLeft, setSnackbar) {
  if (timers[service]) {
    return;
  }
  let remaining = timeLeft - oneSecond;
  timers[service] = setInterval(() => {
    remaining -= oneSecond;
    const errMsg = extractErrorMessage(err, "Please check your connection.");
    return remaining > 0 ? setSnackbar(preformatWithRequestID(err.response, `${errorContext} ${errMsg} Retrying in ${remaining / 1e3} seconds`)) : clearRetryTimer(service, setSnackbar);
  }, oneSecond);
}
function clearRetryTimer(service, setSnackbar) {
  if (timers[service]) {
    clearInterval(timers[service]);
    delete timers[service];
    setSnackbar("");
  }
}
function clearAllRetryTimers(setSnackbar) {
  Object.keys(timers).map((service) => clearRetryTimer(service, setSnackbar));
  setSnackbar("");
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  clearAllRetryTimers,
  clearRetryTimer,
  setRetryTimer
});
//# sourceMappingURL=retrytimer.cjs.map