/**
 * Highcharts JS v12.4.0 (2025-09-04)
 * @module highcharts/modules/windbarb
 * @requires highcharts
 *
 * Wind barb series module
 *
 * (c) 2010-2025 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */import*as t from"../highcharts.js";import*as e from"./datagrouping.js";var o,r={};r.n=t=>{var e=t&&t.__esModule?()=>t.default:()=>t;return r.d(e,{a:e}),e},r.d=(t,e)=>{for(var o in e)r.o(e,o)&&!r.o(t,o)&&Object.defineProperty(t,o,{enumerable:!0,get:e[o]})},r.o=(t,e)=>Object.prototype.hasOwnProperty.call(t,e);let i=t.default;var s=r.n(i);let a=e.default.dataGrouping.approximations;var l=r.n(a);let n=t.default.Series.types.column;var p=r.n(n);let h=t.default.Series;var d=r.n(h);let{composed:u}=s(),{prototype:c}=p(),{prototype:f}=d(),{defined:g,pushUnique:b,stableSort:x}=s();var y=o||(o={});function v(t){return f.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this,t)}function m(){c.translate.apply(this);let t=this,e=t.options,o=t.chart,r=t.points,i=e.onSeries,s=i&&o.get(i),a=s&&s.options.step,l=s&&s.points,n=o.inverted,p=t.xAxis,h=t.yAxis,d=r.length-1,u,f,b=e.onKey||"y",y=l&&l.length,v=0,m,L,w,S,X;if(s&&s.visible&&y){for(v=(s.pointXOffset||0)+(s.barW||0)/2,S=s.currentDataGrouping,L=l[y-1].x+(S?S.totalRange:0),x(r,(t,e)=>t.x-e.x),b="plot"+b[0].toUpperCase()+b.substr(1);y--&&r[d];)if(m=l[y],(u=r[d]).y=m.y,m.x<=u.x&&void 0!==m[b]){if(u.x<=L&&(u.plotY=m[b],m.x<u.x&&!a&&(w=l[y+1]))&&void 0!==w[b])if(g(u.plotX)&&s.is("spline")){let t=[m.plotX||0,m.plotY||0],e=[w.plotX||0,w.plotY||0],o=m.controlPoints?.high||t,r=w.controlPoints?.low||e,i=(i,s)=>Math.pow(1-i,3)*t[s]+3*(1-i)*(1-i)*i*o[s]+3*(1-i)*i*i*r[s]+i*i*i*e[s],s=0,a=1,l;for(let t=0;t<100;t++){let t=(s+a)/2,e=i(t,0);if(null===e)break;if(.25>Math.abs(e-u.plotX)){l=t;break}e<u.plotX?s=t:a=t}g(l)&&(u.plotY=i(l,1),u.y=h.toValue(u.plotY,!0))}else X=(u.x-m.x)/(w.x-m.x),u.plotY+=X*(w[b]-m[b]),u.y+=X*(w.y-m.y);if(d--,y++,d<0)break}}r.forEach((e,o)=>{let i;e.plotX+=v,(void 0===e.plotY||n)&&(e.plotX>=0&&e.plotX<=p.len?n?(e.plotY=p.translate(e.x,0,1,0,1),e.plotX=g(e.y)?h.translate(e.y,0,0,0,1):0):e.plotY=(p.opposite?0:t.yAxis.len)+p.offset:e.shapeArgs={}),(f=r[o-1])&&f.plotX===e.plotX&&(void 0===f.stackIndex&&(f.stackIndex=0),i=f.stackIndex+1),e.stackIndex=i}),this.onSeries=s}y.compose=function(t){if(b(u,"OnSeries")){let e=t.prototype;e.getPlotBox=v,e.translate=m}return t},y.getPlotBox=v,y.translate=m;let L=o,w=t.default.SeriesRegistry;var S=r.n(w);let{isNumber:X}=s();class k extends p().prototype.pointClass{isValid(){return X(this.value)&&this.value>=0}}let{animObject:M}=s(),{column:O}=S().seriesTypes,{extend:P,merge:A,pick:Y}=s();class G extends O{init(t,e){super.init(t,e)}pointAttribs(t,e){let o=this.options,r=t.color||this.color,i=this.options.lineWidth;return e&&(r=o.states[e].color||r,i=(o.states[e].lineWidth||i)+(o.states[e].lineWidthPlus||0)),{stroke:r,"stroke-width":i}}windArrow(t){let e=t.beaufortLevel,o=this.options.vectorLength/20,r=1.943844*t.value,i,s=-10;if(t.isNull)return[];if(0===e)return this.chart.renderer.symbols.circle(-10*o,-10*o,20*o,20*o);let a=[["M",0,7*o],["L",-1.5*o,7*o],["L",0,10*o],["L",1.5*o,7*o],["L",0,7*o],["L",0,-10*o]];if((i=(r-r%50)/50)>0)for(;i--;)a.push(-10===s?["L",0,s*o]:["M",0,s*o],["L",5*o,s*o+2],["L",0,s*o+4]),r-=50,s+=7;if((i=(r-r%10)/10)>0)for(;i--;)a.push(-10===s?["L",0,s*o]:["M",0,s*o],["L",7*o,s*o]),r-=10,s+=3;if((i=(r-r%5)/5)>0)for(;i--;)a.push(-10===s?["L",0,s*o]:["M",0,s*o],["L",4*o,s*o]),r-=5,s+=3;return a}drawPoints(){let t=this.chart,e=this.yAxis,o=t.inverted,r=this.options.vectorLength/2;for(let i of this.points){let s=i.plotX,a=i.plotY;!1===this.options.clip||t.isInsidePlot(s,0)?(i.graphic||(i.graphic=this.chart.renderer.path().add(this.markerGroup).addClass("highcharts-point highcharts-color-"+Y(i.colorIndex,i.series.colorIndex))),i.graphic.attr({d:this.windArrow(i),translateX:s+this.options.xOffset,translateY:a+this.options.yOffset,rotation:i.direction}),this.chart.styledMode||i.graphic.attr(this.pointAttribs(i))):i.graphic&&(i.graphic=i.graphic.destroy()),i.tooltipPos=[s+this.options.xOffset+(o&&!this.onSeries?r:0),a+this.options.yOffset-(o?0:r+e.pos-t.plotTop)]}}animate(t){t?this.markerGroup.attr({opacity:.01}):this.markerGroup.animate({opacity:1},M(this.options.animation))}markerAttribs(){return{}}getExtremes(){return{}}shouldShowTooltip(t,e,o={}){return o.ignoreX=this.chart.inverted,o.ignoreY=!o.ignoreX,super.shouldShowTooltip(t,e,o)}}G.defaultOptions=A(O.defaultOptions,{dataGrouping:{enabled:!0,approximation:"windbarb",groupPixelWidth:30},lineWidth:2,onSeries:null,states:{hover:{lineWidthPlus:0}},tooltip:{pointFormat:'<span style="color:{point.color}">●</span> {series.name}: <b>{point.value}</b> ({point.beaufort})<br/>'},vectorLength:20,colorKey:"value",yOffset:-20,xOffset:0}),L.compose(G),P(G.prototype,{beaufortFloor:[0,.3,1.6,3.4,5.5,8,10.8,13.9,17.2,20.8,24.5,28.5,32.7],beaufortName:["Calm","Light air","Light breeze","Gentle breeze","Moderate breeze","Fresh breeze","Strong breeze","Near gale","Gale","Strong gale","Storm","Violent storm","Hurricane"],invertible:!1,parallelArrays:["x","value","direction"],pointArrayMap:["value","direction"],pointClass:k,trackerGroups:["markerGroup"],translate:function(){let t=this.beaufortFloor,e=this.beaufortName;for(let o of(L.translate.call(this),this.points)){let r=0;for(;r<t.length&&!(t[r]>o.value);r++);o.beaufortLevel=r-1,o.beaufort=e[r-1]}}}),S().registerSeriesType("windbarb",G),l().windbarb||(l().windbarb=(t,e)=>{let o=0,r=0;for(let i=0,a=t.length;i<a;i++)o+=t[i]*Math.cos(e[i]*s().deg2rad),r+=t[i]*Math.sin(e[i]*s().deg2rad);return[t.reduce((t,e)=>t+e,0)/t.length,Math.atan2(r,o)/s().deg2rad]});let I=s();export{I as default};