"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/organizationSlice/index.ts
var organizationSlice_exports = {};
__export(organizationSlice_exports, {
  actions: () => actions,
  default: () => organizationSlice_default,
  initialState: () => initialState,
  organizationSlice: () => organizationSlice,
  sliceName: () => sliceName
});
module.exports = __toCommonJS(organizationSlice_exports);
var import_toolkit = require("@reduxjs/toolkit");

// src/constants.ts
var import_constants = require("@northern.tech/utils/constants");

// src/organizationSlice/constants.ts
var auditlogTypes = {
  artifact: { title: "Artifact", queryParameter: "object_type", value: "artifact" },
  deployment: { title: "Deployment", queryParameter: "object_deployment_name", value: "deployment" },
  device: { title: "Device", queryParameter: "object_id", value: "device" },
  user_access_token: { title: "Personal Access Token", queryParameter: "user_access_token", value: "user_access_token" },
  user: { title: "User", queryParameter: "object_id", value: "user" },
  tenant: { title: "Tenant", queryParameter: "object_id", value: "tenant" }
};
var AUDIT_LOGS_TYPES = [auditlogTypes.artifact, auditlogTypes.deployment, auditlogTypes.device, auditlogTypes.user_access_token, auditlogTypes.user];
var SP_AUDIT_LOGS_TYPES = [auditlogTypes.user, auditlogTypes.tenant];
var TENANT_LIST_DEFAULT = {
  page: 1,
  perPage: 20
};

// src/organizationSlice/index.ts
var sliceName = "organization";
var initialState = {
  card: {
    last4: "",
    expiration: { month: 1, year: 2020 },
    brand: ""
  },
  intentId: null,
  tenantList: {
    ...TENANT_LIST_DEFAULT,
    total: 0,
    tenants: [],
    selectedTenant: null,
    sort: {
      direction: import_constants.SORTING_OPTIONS.desc,
      key: "name"
    }
  },
  organization: {
    // id, name, status, tenant_token, plan
  },
  auditlog: {
    events: [],
    selectionState: {
      ...import_constants.DEVICE_LIST_DEFAULTS,
      detail: void 0,
      endDate: void 0,
      selectedIssue: void 0,
      sort: { direction: import_constants.SORTING_OPTIONS.desc },
      startDate: void 0,
      total: 0,
      type: void 0,
      user: void 0,
      isLoading: false
    }
  },
  externalDeviceIntegrations: [
    // { <connection_string|x509|...>, id, provider }
  ],
  ssoConfigs: [],
  webhooks: {
    // [id]: { events: [] }
    // for now:
    events: [],
    eventsTotal: 0
  }
};
var organizationSlice = (0, import_toolkit.createSlice)({
  name: sliceName,
  initialState,
  reducers: {
    receiveAuditLogs: (state, action) => {
      const { events, total } = action.payload;
      state.auditlog.events = events;
      state.auditlog.selectionState.total = total;
    },
    setAuditLogState: (state, action) => {
      state.auditlog.selectionState = {
        ...state.auditlog.selectionState,
        ...action.payload
      };
    },
    receiveCurrentCard: (state, action) => {
      state.card = action.payload;
    },
    receiveSetupIntent: (state, action) => {
      state.intentId = action.payload;
    },
    setOrganization: (state, action) => {
      state.organization = { ...state.organization, ...action.payload };
    },
    setSubscription: (state, action) => {
      state.organization.subscription = { ...state.organization.subscription, ...action.payload };
    },
    setBillingProfile: (state, action) => {
      state.organization.billing_profile = action.payload;
    },
    setTenantListState: (state, action) => {
      state.tenantList = action.payload;
    },
    receiveExternalDeviceIntegrations: (state, action) => {
      state.externalDeviceIntegrations = action.payload;
    },
    receiveSsoConfigs: (state, action) => {
      state.ssoConfigs = action.payload;
    },
    receiveWebhookEvents: (state, action) => {
      const { value, total } = action.payload;
      state.webhooks.events = value;
      state.webhooks.eventsTotal = total;
    }
  }
});
var actions = organizationSlice.actions;
var organizationSlice_default = organizationSlice.reducer;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  actions,
  initialState,
  organizationSlice,
  sliceName
});
//# sourceMappingURL=index.cjs.map