'use strict';

var profileServiceClass = Class.extend({
    PROFILE_AP_URL: MP_SITE_URL + '/ProfileApi',
    TWO_FA_AP_URL: MP_SITE_URL + '/TwoFaApi',

    getUser: function (user) {
        return this.$http.get(`${this.PROFILE_AP_URL}/user`, {cache: false});
    },
    
    configureTwoFa: function () {
        return this.$http.get(`${this.TWO_FA_AP_URL}/configure`);
    },

    verifyTwoFaConfiguration: function (code) {
        return this.$http.post(`${this.TWO_FA_AP_URL}/verify_configuration`, {code});
    }, 
    
    disableTwoFa: function (code) {
        return this.$http.post(`${this.TWO_FA_AP_URL}/disable`, {code});
    },


});

(function () {
    const profileServiceClassProvider = Class.extend({
        instance: new profileServiceClass(),
        $get: ['$http',
            function ($http) {
                this.instance.$http = $http;
                return this.instance;
        }]
    });

    angular.module('profileServiceModule', []).provider('profileService', profileServiceClassProvider);
}());
