<div class="accordion" id="saved-search-accordion" style="min-width: 500px;">
    <?php
    if (is_array($group) && !empty($group))
    {
        $count = 0;
        foreach ((array) $group as $reportName => $savedReport)
        {
            foreach ($savedReport as $report => $item) {
                $key = preg_replace("/[^A-Za-z0-9]/",'',$item->label);
                $searches[$reportName][$key] = $item;
            }
        }

        // sort
        ksort($searches);

            foreach ((array) $searches as $index => $g)
            {
                if (!empty($g))
                {
                    foreach ((array) $g as $search)
                    {
                         $count = $count + 1;
                        ?>

                                <div class="accordion-group">
                                    <div class="accordion-heading">
                                        <div class="row-fluid">

                                            <a class="accordion-toggle collapsed pull-left span10" data-toggle="collapse" data-parent="#saved-search-accordion" href="#<?= htmlspecialchars($search->getId()) ?>">
                                                <i class="icon-chevron-<?php if ($count == 1) echo "down"; else echo "right"; ?> pull-left" style="margin-right:10px;"></i>
                                                <span class="title"><?= htmlspecialchars($search->getLabel()) ?></span>
                                            </a>
                                            <div class="span2">
                                                <p class="pull-right" >
                                                    <a class="jDelete" href="<?php echo site_url() . "/savedsearch/delete/" . htmlspecialchars($search->getId()) ?>" target="_self"><i style="padding:8px 15px 0 0" class="icon-remove"></i></a>
                                                </p>
                                                <p class="pull-right">
                                                    <a href="<?php echo $search->getUrl(); ?>" target="_blank"><i style="padding:8px 15px 0 0" class="icon-play"></i></a>
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="<?= htmlspecialchars($search->getId()) ?>" class="accordion-body collapse <?php if ($count == 1) echo " in" ?> ">
                                        <div class="accordion-inner">
                                            <p><span class="muted span3">Report type:</span> <?= htmlspecialchars($search->getReportType()) ?></p>
                                            <?php /*<p><span class="muted span2">Parameter</span> <?php echo $search->getParameters(); ?></p>*/ ?>
                                            <p><span class="muted span3">Date:</span> <?= htmlspecialchars($search->getDate()) ?></p>
                                            <?php if($search->getPromiseFilter()!=null){?>
                                               <p><span class="muted span3">Promise context:</span> <?= htmlspecialchars($search->getPromiseFilter()) ?></p>
                                            <?php }?>

                                            <?php $details=$search->getDetails();
                                                foreach($details as $key=> $value){?>
                                               <p><span class="muted span3 capitalize"><?= htmlspecialchars($key) ?>:</span> <?= $value===true?'true':($value===false?'false':htmlspecialchars($value)) ?></p>
                                             <?php }?>
                                        </div>
                                    </div>
                                </div>
            <?php   }
                }
                else
                {
                    ?>
                    <div id="no-data-row">
                        <p class="alert alert-info">No saved searches found.</p>
                    </div>
                <?php }
            }
    }
    else
    {
        ?>
        <div class="info alert alert-info">No saved search found.</div>
    <?php } ?>
</div>

<div class="modal hide" id="myModal" tabindex="-1" role="dialog" >
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" ><i class="bi bi-x"></i></button>
        <h2>Delete saved search</h2>
    </div>
    <div class="modal-body">
         <p>Are you sure you want to delete this search?</p>
    </div>
    <div class="modal-footer">
          <button id="deleteSavedSearchBtn" class="btn">Delete</button>
          <button class="btn btn-primary" data-dismiss="modal" >Cancel</button>
     </div>
</div>

<script type="text/javascript">

    $('a.jDelete').click(function(e) {
        e.preventDefault();
        $('#myModal').modal('show');
        var element=$(this);

        $("#deleteSavedSearchBtn").on('click',{element:element},function(event){
          var parent = element.closest('.accordion-group');
          var url=element.attr('href');
          $.ajax({
                type: 'get',
                url: url,
                success: function() {
                    $('#myModal').modal('hide');
                    parent.slideUp(300,function() {
                        parent.remove();
                    });
                },
                error:function(){
                    alert('Error while deletion.')
                }
            });
        });
        return false;
    });


//    $('#saved-search-accordion').on('click','.accordion-toggle',function (e) {
//        var icon =  $(this).find('i');
//        if (icon.hasClass('icon-chevron-down')) {
//            icon.removeClass('icon-chevron-down');
//            icon.addClass('icon-chevron-right');
//        } else {
//            $('#saved-search-accordion').find('i.icon-chevron-down').not(icon).each(function(){
//                $(this).removeClass('icon-chevron-down');
//                $(this).addClass('icon-chevron-right');
//            });
//            icon.removeClass('icon-chevron-right');
//            icon.addClass('icon-chevron-down');
//        }
//    });
    // fix for auto open arrow
//    $('.in').parent().find('.accordion-heading').find('i.icon-chevron-right').removeClass('icon-chevron-right').addClass('icon-chevron-down');




</script>
