<?php

namespace Controllers;

use Slim\Container;

/**
 * Class ProtectedController
 * @package Controllers
 */
class ProtectedController extends BaseController
{
    /**
     * ProtectedController constructor.
     * @param Container $container
     */
    public function __construct(Container $container)
    {
        parent::__construct($container);

        if (!$this->checkToken()) {
            throw new \Exception('Permission deny.');
        };
    }

    /**
     * @return bool
     */
    private function checkToken()
    {
        $authorizationToken = $this->container->get('request')->getHeaderLine('Authorization');
        return $this->container->get('accessToken') == $authorizationToken;
    }
}
