"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/devicesSlice/selectors.ts
var selectors_exports = {};
__export(selectors_exports, {
  getAcceptedDevices: () => getAcceptedDevices,
  getAttributesList: () => getAttributesList,
  getDeviceById: () => getDeviceById,
  getDeviceCountsByStatus: () => getDeviceCountsByStatus,
  getDeviceFilters: () => getDeviceFilters,
  getDeviceIdentityAttributes: () => getDeviceIdentityAttributes,
  getDeviceLimit: () => getDeviceLimit,
  getDeviceListState: () => getDeviceListState,
  getDeviceReports: () => getDeviceReports,
  getDeviceTypes: () => getDeviceTypes,
  getDevicesById: () => getDevicesById,
  getDevicesByStatus: () => getDevicesByStatus,
  getFilteringAttributes: () => getFilteringAttributes,
  getGroupData: () => getGroupData,
  getGroups: () => getGroups,
  getGroupsById: () => getGroupsById,
  getGroupsByIdWithoutUngrouped: () => getGroupsByIdWithoutUngrouped,
  getLimitMaxed: () => getLimitMaxed,
  getListedDevices: () => getListedDevices,
  getSelectedGroup: () => getSelectedGroup,
  getSelectedGroupInfo: () => getSelectedGroupInfo,
  getSortedFilteringAttributes: () => getSortedFilteringAttributes
});
module.exports = __toCommonJS(selectors_exports);
var import_helpers = require("@northern.tech/utils/helpers");
var import_toolkit = require("@reduxjs/toolkit");

// src/constants.ts
var import_constants2 = require("@northern.tech/utils/constants");

// src/commonConstants.tsx
var import_js = require("@mdi/js");
var import_MenderTypes = require("@northern.tech/types/MenderTypes");
var import_jsx_runtime = require("react/jsx-runtime");
var timeUnits = {
  days: "days",
  minutes: "minutes",
  hours: "hours"
};
var UNGROUPED_GROUP = { id: "*|=ungrouped=|*", name: "Unassigned" };
var oneSecond = 1e3;
var TIMEOUTS = {
  debounceDefault: 700,
  debounceShort: 300,
  halfASecond: 0.5 * oneSecond,
  oneSecond,
  twoSeconds: 2 * oneSecond,
  threeSeconds: 3 * oneSecond,
  fiveSeconds: 5 * oneSecond,
  refreshDefault: 10 * oneSecond,
  refreshLong: 60 * oneSecond
};
var DEVICE_ONLINE_CUTOFF = { interval: 1, intervalName: timeUnits.days };
var defaultIdAttribute = Object.freeze({ attribute: "id", scope: import_constants2.ATTRIBUTE_SCOPES.identity });
var credentialTypes = {
  aws: import_MenderTypes.Credentials.type.AWS,
  http: import_MenderTypes.Credentials.type.HTTP,
  sas: import_MenderTypes.Credentials.type.SAS,
  x509: "x509"
};
var EXTERNAL_PROVIDER = {
  "iot-core": {
    credentialsType: credentialTypes.aws,
    icon: import_js.mdiAws,
    title: "AWS IoT Core",
    twinTitle: "Device Shadow",
    provider: "iot-core",
    enabled: true,
    deviceTwin: true,
    configHint: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_jsx_runtime.Fragment, { children: "For help finding your AWS IoT Core connection string, check the AWS IoT documentation." })
  },
  "iot-hub": {
    credentialsType: credentialTypes.sas,
    icon: import_js.mdiMicrosoftAzure,
    title: "Azure IoT Hub",
    twinTitle: "Device Twin",
    provider: "iot-hub",
    enabled: true,
    deviceTwin: true,
    configHint: /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("span", { children: [
      "For help finding your Azure IoT Hub connection string, look under 'Shared access policies' in the Microsoft Azure UI as described",
      " ",
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
        "a",
        {
          href: "https://devblogs.microsoft.com/iotdev/understand-different-connection-strings-in-azure-iot-hub/#iothubconn",
          target: "_blank",
          rel: "noopener noreferrer",
          children: "here"
        }
      ),
      "."
    ] })
  },
  webhook: {
    credentialsType: credentialTypes.http,
    deviceTwin: false,
    twinTitle: "",
    // disable the webhook provider here, since it is treated different than other integrations, with a custom configuration & management view, etc.
    enabled: false,
    provider: "webhook"
  }
};
var emptyWebhook = {
  description: "",
  provider: import_MenderTypes.Integration.provider.WEBHOOK,
  credentials: {
    type: EXTERNAL_PROVIDER.webhook.credentialsType,
    [EXTERNAL_PROVIDER.webhook.credentialsType]: {
      secret: "",
      url: ""
    }
  }
};
var regionNames = new Intl.DisplayNames(["en"], { type: "region" });
var countries = [
  "AD",
  "AE",
  "AF",
  "AG",
  "AI",
  "AL",
  "AM",
  "AO",
  "AQ",
  "AR",
  "AS",
  "AT",
  "AU",
  "AW",
  "AX",
  "AZ",
  "BA",
  "BB",
  "BD",
  "BE",
  "BF",
  "BG",
  "BH",
  "BI",
  "BJ",
  "BL",
  "BM",
  "BN",
  "BO",
  "BR",
  "BS",
  "BT",
  "BV",
  "BW",
  "BY",
  "BZ",
  "CA",
  "CC",
  "CD",
  "CF",
  "CG",
  "CH",
  "CI",
  "CK",
  "CL",
  "CM",
  "CN",
  "CO",
  "CR",
  "CU",
  "CV",
  "CW",
  "CX",
  "CY",
  "CZ",
  "DE",
  "DJ",
  "DK",
  "DM",
  "DO",
  "DZ",
  "EC",
  "EE",
  "EG",
  "EH",
  "ER",
  "ES",
  "ET",
  "FI",
  "FJ",
  "FK",
  "FM",
  "FO",
  "FR",
  "GA",
  "GB",
  "GD",
  "GE",
  "GF",
  "GG",
  "GH",
  "GI",
  "GL",
  "GM",
  "GN",
  "GP",
  "GQ",
  "GR",
  "GS",
  "GT",
  "GU",
  "GW",
  "GY",
  "HK",
  "HM",
  "HN",
  "HR",
  "HT",
  "HU",
  "ID",
  "IE",
  "IL",
  "IM",
  "IN",
  "IO",
  "IQ",
  "IR",
  "IS",
  "IT",
  "JE",
  "JM",
  "JO",
  "JP",
  "KE",
  "KG",
  "KH",
  "KI",
  "KM",
  "KN",
  "KP",
  "KR",
  "KW",
  "KY",
  "KZ",
  "LA",
  "LB",
  "LC",
  "LI",
  "LK",
  "LR",
  "LS",
  "LT",
  "LU",
  "LV",
  "LY",
  "MA",
  "MC",
  "MD",
  "ME",
  "MF",
  "MG",
  "MH",
  "MK",
  "ML",
  "MM",
  "MN",
  "MO",
  "MP",
  "MQ",
  "MR",
  "MS",
  "MT",
  "MU",
  "MV",
  "MW",
  "MX",
  "MY",
  "MZ",
  "NA",
  "NC",
  "NE",
  "NF",
  "NG",
  "NI",
  "NL",
  "NO",
  "NP",
  "NR",
  "NU",
  "NZ",
  "OM",
  "PA",
  "PE",
  "PF",
  "PG",
  "PH",
  "PK",
  "PL",
  "PM",
  "PN",
  "PR",
  "PS",
  "PT",
  "PW",
  "PY",
  "QA",
  "RE",
  "RO",
  "RS",
  "RU",
  "RW",
  "SA",
  "SB",
  "SC",
  "SD",
  "SE",
  "SG",
  "SH",
  "SI",
  "SJ",
  "SK",
  "SL",
  "SM",
  "SN",
  "SO",
  "SR",
  "SS",
  "ST",
  "SV",
  "SX",
  "SY",
  "SZ",
  "TC",
  "TD",
  "TF",
  "TG",
  "TH",
  "TJ",
  "TK",
  "TL",
  "TM",
  "TN",
  "TO",
  "TR",
  "TT",
  "TV",
  "TW",
  "TZ",
  "UA",
  "UG",
  "US",
  "UY",
  "UZ",
  "VA",
  "VC",
  "VE",
  "VG",
  "VI",
  "VN",
  "VU",
  "WF",
  "WS",
  "XK",
  "YE",
  "YT",
  "ZA",
  "ZM",
  "ZW"
].map((code) => ({ code, label: regionNames.of(code) })).sort((a, b) => a.label.localeCompare(b.label));

// src/devicesSlice/selectors.ts
var getAcceptedDevices = (state) => state.devices.byStatus.accepted;
var getDevicesByStatus = (state) => state.devices.byStatus;
var getDevicesById = (state) => state.devices.byId;
var getDeviceReports = (state) => state.devices.reports;
var getGroupsById = (state) => state.devices.groups.byId;
var getSelectedGroup = (state) => state.devices.groups.selectedGroup;
var getDeviceListState = (state) => state.devices.deviceList;
var getListedDevices = (state) => state.devices.deviceList.deviceIds;
var getFilteringAttributes = (state) => state.devices.filteringAttributes;
var getDeviceFilters = (state) => state.devices.filters || [];
var getFilteringAttributesFromConfig = (state) => state.devices.filteringAttributesConfig.attributes;
var getSortedFilteringAttributes = (0, import_toolkit.createSelector)([getFilteringAttributes], (filteringAttributes) => ({
  ...filteringAttributes,
  identityAttributes: [...filteringAttributes.identityAttributes, "id"]
}));
var getDeviceLimit = (state) => state.devices.limit;
var getFilteringAttributesLimit = (state) => state.devices.filteringAttributesLimit;
var getDeviceIdentityAttributes = (0, import_toolkit.createSelector)(
  [getFilteringAttributes, getFilteringAttributesLimit],
  ({ identityAttributes }, filteringAttributesLimit) => {
    const attributes = identityAttributes.slice(0, filteringAttributesLimit);
    return attributes.reduce(
      (accu, value) => {
        accu.push({ value, label: value, scope: "identity" });
        return accu;
      },
      [
        { value: "name", label: "Name", scope: "tags" },
        { value: "id", label: "Device ID", scope: "identity" }
      ]
    );
  }
);
var getDeviceCountsByStatus = (0, import_toolkit.createSelector)(
  [getDevicesByStatus],
  (byStatus) => Object.values(import_constants2.DEVICE_STATES).reduce((accu, state) => {
    accu[state] = byStatus[state].total || 0;
    return accu;
  }, {})
);
var getDeviceById = (0, import_toolkit.createSelector)([getDevicesById, (_, deviceId) => deviceId], (devicesById, deviceId = "") => devicesById[deviceId] ?? {});
var getSelectedGroupInfo = (0, import_toolkit.createSelector)(
  [getAcceptedDevices, getGroupsById, getSelectedGroup],
  ({ total: acceptedDeviceTotal }, groupsById, selectedGroup) => {
    let groupCount = acceptedDeviceTotal;
    let groupFilters = [];
    if (selectedGroup && groupsById[selectedGroup]) {
      groupCount = groupsById[selectedGroup].total || 0;
      groupFilters = groupsById[selectedGroup].filters || [];
    }
    return { groupCount, selectedGroup, groupFilters };
  }
);
var getLimitMaxed = (0, import_toolkit.createSelector)(
  [getAcceptedDevices, getDeviceLimit],
  ({ total: acceptedDevices = 0 }, deviceLimit) => Boolean(deviceLimit && deviceLimit <= acceptedDevices)
);
var getGroupsByIdWithoutUngrouped = (0, import_toolkit.createSelector)([getGroupsById], ({ [UNGROUPED_GROUP.id]: ungrouped, ...groups }) => groups);
var getGroupData = (0, import_toolkit.createSelector)([getGroupsByIdWithoutUngrouped], (groups) => {
  const createdGroup = Object.keys(groups).length ? Object.keys(groups)[0] : void 0;
  const hasDynamicGroups = Object.values(groups).some((group) => !!group.id);
  return { createdGroup, hasDynamicGroups, groups };
});
var getGroups = (0, import_toolkit.createSelector)([getGroupsById], (groupsById) => {
  const groupNames = Object.keys(groupsById).sort();
  const groupedGroups = Object.entries(groupsById).sort((a, b) => a[0].localeCompare(b[0])).reduce(
    (accu, [groupname, group]) => {
      const name = groupname === UNGROUPED_GROUP.id ? UNGROUPED_GROUP.name : groupname;
      const groupItem = { ...group, groupId: name, name: groupname };
      if ((group.filters ?? []).length > 0) {
        if (groupname !== UNGROUPED_GROUP.id) {
          accu.dynamic.push(groupItem);
        } else {
          accu.ungrouped.push(groupItem);
        }
      } else {
        accu.static.push(groupItem);
      }
      return accu;
    },
    { dynamic: [], static: [], ungrouped: [] }
  );
  return { groupNames, ...groupedGroups };
});
var getAttributesList = (0, import_toolkit.createSelector)(
  [getFilteringAttributes, getFilteringAttributesFromConfig],
  ({ identityAttributes = [], inventoryAttributes = [] }, { identity = [], inventory = [] }) => [...identityAttributes, ...inventoryAttributes, ...identity, ...inventory].filter(import_helpers.duplicateFilter)
);
var getDeviceTypes = (0, import_toolkit.createSelector)(
  [getAcceptedDevices, getDevicesById],
  ({ deviceIds = [] }, devicesById) => Object.keys(
    deviceIds.slice(0, 200).reduce((accu, item) => {
      const { device_type: deviceTypes = [] } = devicesById[item] ? devicesById[item].attributes : {};
      accu = deviceTypes.reduce((deviceTypeAccu, deviceType) => {
        if (deviceType.length > 1) {
          deviceTypeAccu[deviceType] = deviceTypeAccu[deviceType] ? deviceTypeAccu[deviceType] + 1 : 1;
        }
        return deviceTypeAccu;
      }, accu);
      return accu;
    }, {})
  )
);
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  getAcceptedDevices,
  getAttributesList,
  getDeviceById,
  getDeviceCountsByStatus,
  getDeviceFilters,
  getDeviceIdentityAttributes,
  getDeviceLimit,
  getDeviceListState,
  getDeviceReports,
  getDeviceTypes,
  getDevicesById,
  getDevicesByStatus,
  getFilteringAttributes,
  getGroupData,
  getGroups,
  getGroupsById,
  getGroupsByIdWithoutUngrouped,
  getLimitMaxed,
  getListedDevices,
  getSelectedGroup,
  getSelectedGroupInfo,
  getSortedFilteringAttributes
});
//# sourceMappingURL=selectors.cjs.map