"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/tracking.ts
var tracking_exports = {};
__export(tracking_exports, {
  default: () => tracking_default
});
module.exports = __toCommonJS(tracking_exports);
var import_react_ga4 = __toESM(require("react-ga4"), 1);
var cookieConsentCSS = "https://cdn.jsdelivr.net/npm/cookieconsent@3/build/cookieconsent.min.css";
var cookieConsentJS = "https://cdn.jsdelivr.net/npm/cookieconsent@3/build/cookieconsent.min.js";
var ReactGA = import_react_ga4.default.default;
var Tracker = class {
  constructor() {
    this.initialized = false;
    this.trackingEnabled = true;
    this.currentPageView = null;
    this.currentOrganizationUser = null;
  }
  cookieconsent() {
    return new Promise((resolve) => {
      const style = document.createElement("link");
      style.href = cookieConsentCSS;
      style.rel = "stylesheet";
      style.async = true;
      document.head.appendChild(style);
      const script = document.createElement("script");
      script.src = cookieConsentJS;
      script.async = false;
      script.addEventListener("load", () => {
        window.cookieconsent.initialise({
          palette: {
            popup: {
              background: "#5d0f43",
              text: "#ffffff"
            },
            button: {
              background: "#73a4ad",
              text: "#ffffff"
            }
          },
          position: "bottom-left",
          type: "opt-out",
          content: {
            message: "We use cookies to analyze our traffic so we can improve our website and give you a better experience.",
            link: "View our cookie policy",
            href: "https://northern.tech/legal/cookies"
          },
          autoOpen: true,
          revokable: false,
          law: {
            regionalLaw: false
          },
          onStatusChange: (status) => {
            const hasConsented = status == "allow";
            resolve({ trackingConsentGiven: hasConsented });
          }
        });
      });
      document.body.appendChild(script);
    });
  }
  event(data) {
    if (this.initialized && this.trackingEnabled) {
      ReactGA.event(data);
    }
  }
  exception(error) {
    if (this.initialized && this.trackingEnabled) {
      ReactGA.event("error", error);
    }
  }
  initialize(trackingCode) {
    if (this.initialized && this.trackingEnabled) {
      return false;
    }
    ReactGA.initialize(trackingCode);
    this.initialized = true;
    return true;
  }
  pageview(data) {
    if (data) {
      this.currentPageView = data;
    }
  }
  set(value) {
    if (this.initialized && this.trackingEnabled) {
      ReactGA.set(value);
    }
  }
  setOrganizationUser(organization, user) {
    if (this.initialized && this.trackingEnabled && this.currentOrganizationUser != { organization, user }) {
      this.currentOrganizationUser = { organization, user };
      this.set({ dimension1: organization.plan });
      this.set({ dimension2: organization.id });
      this.set({ dimension3: user.id });
      this.set({ userId: user.id });
    }
  }
  setTrackingEnabled(trackingEnabled) {
    this.trackingEnabled = trackingEnabled;
  }
};
var Tracking = new Tracker();
var tracking_default = Tracking;
//# sourceMappingURL=tracking.cjs.map