import {
  DEVICE_STATES,
  UNGROUPED_GROUP
} from "./chunk-7C4SQBEE.js";

// src/devicesSlice/selectors.ts
import { duplicateFilter } from "@northern.tech/utils/helpers";
import { createSelector } from "@reduxjs/toolkit";
var getAcceptedDevices = (state) => state.devices.byStatus.accepted;
var getDevicesByStatus = (state) => state.devices.byStatus;
var getDevicesById = (state) => state.devices.byId;
var getDeviceReports = (state) => state.devices.reports;
var getGroupsById = (state) => state.devices.groups.byId;
var getSelectedGroup = (state) => state.devices.groups.selectedGroup;
var getDeviceListState = (state) => state.devices.deviceList;
var getListedDevices = (state) => state.devices.deviceList.deviceIds;
var getFilteringAttributes = (state) => state.devices.filteringAttributes;
var getDeviceFilters = (state) => state.devices.filters || [];
var getFilteringAttributesFromConfig = (state) => state.devices.filteringAttributesConfig.attributes;
var getSortedFilteringAttributes = createSelector([getFilteringAttributes], (filteringAttributes) => ({
  ...filteringAttributes,
  identityAttributes: [...filteringAttributes.identityAttributes, "id"]
}));
var getDeviceLimit = (state) => state.devices.limit;
var getFilteringAttributesLimit = (state) => state.devices.filteringAttributesLimit;
var getDeviceIdentityAttributes = createSelector(
  [getFilteringAttributes, getFilteringAttributesLimit],
  ({ identityAttributes }, filteringAttributesLimit) => {
    const attributes = identityAttributes.slice(0, filteringAttributesLimit);
    return attributes.reduce(
      (accu, value) => {
        accu.push({ value, label: value, scope: "identity" });
        return accu;
      },
      [
        { value: "name", label: "Name", scope: "tags" },
        { value: "id", label: "Device ID", scope: "identity" }
      ]
    );
  }
);
var getDeviceCountsByStatus = createSelector(
  [getDevicesByStatus],
  (byStatus) => Object.values(DEVICE_STATES).reduce((accu, state) => {
    accu[state] = byStatus[state].total || 0;
    return accu;
  }, {})
);
var getDeviceById = createSelector([getDevicesById, (_, deviceId) => deviceId], (devicesById, deviceId = "") => devicesById[deviceId] ?? {});
var getSelectedGroupInfo = createSelector(
  [getAcceptedDevices, getGroupsById, getSelectedGroup],
  ({ total: acceptedDeviceTotal }, groupsById, selectedGroup) => {
    let groupCount = acceptedDeviceTotal;
    let groupFilters = [];
    if (selectedGroup && groupsById[selectedGroup]) {
      groupCount = groupsById[selectedGroup].total || 0;
      groupFilters = groupsById[selectedGroup].filters || [];
    }
    return { groupCount, selectedGroup, groupFilters };
  }
);
var getLimitMaxed = createSelector(
  [getAcceptedDevices, getDeviceLimit],
  ({ total: acceptedDevices = 0 }, deviceLimit) => Boolean(deviceLimit && deviceLimit <= acceptedDevices)
);
var getGroupsByIdWithoutUngrouped = createSelector([getGroupsById], ({ [UNGROUPED_GROUP.id]: ungrouped, ...groups }) => groups);
var getGroupData = createSelector([getGroupsByIdWithoutUngrouped], (groups) => {
  const createdGroup = Object.keys(groups).length ? Object.keys(groups)[0] : void 0;
  const hasDynamicGroups = Object.values(groups).some((group) => !!group.id);
  return { createdGroup, hasDynamicGroups, groups };
});
var getGroups = createSelector([getGroupsById], (groupsById) => {
  const groupNames = Object.keys(groupsById).sort();
  const groupedGroups = Object.entries(groupsById).sort((a, b) => a[0].localeCompare(b[0])).reduce(
    (accu, [groupname, group]) => {
      const name = groupname === UNGROUPED_GROUP.id ? UNGROUPED_GROUP.name : groupname;
      const groupItem = { ...group, groupId: name, name: groupname };
      if ((group.filters ?? []).length > 0) {
        if (groupname !== UNGROUPED_GROUP.id) {
          accu.dynamic.push(groupItem);
        } else {
          accu.ungrouped.push(groupItem);
        }
      } else {
        accu.static.push(groupItem);
      }
      return accu;
    },
    { dynamic: [], static: [], ungrouped: [] }
  );
  return { groupNames, ...groupedGroups };
});
var getAttributesList = createSelector(
  [getFilteringAttributes, getFilteringAttributesFromConfig],
  ({ identityAttributes = [], inventoryAttributes = [] }, { identity = [], inventory = [] }) => [...identityAttributes, ...inventoryAttributes, ...identity, ...inventory].filter(duplicateFilter)
);
var getDeviceTypes = createSelector(
  [getAcceptedDevices, getDevicesById],
  ({ deviceIds = [] }, devicesById) => Object.keys(
    deviceIds.slice(0, 200).reduce((accu, item) => {
      const { device_type: deviceTypes = [] } = devicesById[item] ? devicesById[item].attributes : {};
      accu = deviceTypes.reduce((deviceTypeAccu, deviceType) => {
        if (deviceType.length > 1) {
          deviceTypeAccu[deviceType] = deviceTypeAccu[deviceType] ? deviceTypeAccu[deviceType] + 1 : 1;
        }
        return deviceTypeAccu;
      }, accu);
      return accu;
    }, {})
  )
);

export {
  getAcceptedDevices,
  getDevicesByStatus,
  getDevicesById,
  getDeviceReports,
  getGroupsById,
  getSelectedGroup,
  getDeviceListState,
  getListedDevices,
  getFilteringAttributes,
  getDeviceFilters,
  getSortedFilteringAttributes,
  getDeviceLimit,
  getDeviceIdentityAttributes,
  getDeviceCountsByStatus,
  getDeviceById,
  getSelectedGroupInfo,
  getLimitMaxed,
  getGroupsByIdWithoutUngrouped,
  getGroupData,
  getGroups,
  getAttributesList,
  getDeviceTypes
};
//# sourceMappingURL=chunk-KJNNEDRV.js.map