import {
  DetailInformation,
  DeviceDetails_default
} from "./chunk-LHTCZWYC.js";

// src/auditlogs/eventdetails/PortForward.tsx
import { useEffect, useState } from "react";
import { useDispatch, useSelector } from "react-redux";
import { useTheme } from "@mui/material/styles";
import Loader from "@northern.tech/common-ui/Loader";
import Time from "@northern.tech/common-ui/Time";
import { getAuditlogDevice, getIdAttribute, getUserCapabilities } from "@northern.tech/store/selectors";
import { getDeviceById, getSessionDetails } from "@northern.tech/store/thunks";
import dayjs from "dayjs";
import duration from "dayjs/plugin/duration.js";
import { jsx, jsxs } from "react/jsx-runtime";
dayjs.extend(duration);
var PortForward = ({ item, onClose }) => {
  const theme = useTheme();
  const [sessionDetails, setSessionDetails] = useState();
  const dispatch = useDispatch();
  const { action, actor, meta, object = {}, time } = item;
  const { canReadDevices } = useSelector(getUserCapabilities);
  const device = useSelector(getAuditlogDevice);
  const idAttribute = useSelector(getIdAttribute);
  useEffect(() => {
    if (canReadDevices) {
      dispatch(getDeviceById(object.id));
    }
    dispatch(
      getSessionDetails({
        sessionId: meta.session_id[0],
        deviceId: object.id,
        userId: actor.id,
        startDate: action.startsWith("open") ? time : void 0,
        endDate: action.startsWith("close") ? time : void 0
      })
    ).unwrap().then(setSessionDetails);
  }, [action, actor.id, canReadDevices, dispatch, meta.session_id, object.id, time]);
  if (!sessionDetails || canReadDevices && !device) {
    return /* @__PURE__ */ jsx(Loader, { show: true });
  }
  const sessionMeta = {
    "Session ID": item.meta.session_id[0],
    "Start time": /* @__PURE__ */ jsx(Time, { value: sessionDetails.start }),
    "End time": /* @__PURE__ */ jsx(Time, { value: sessionDetails.end }),
    "Duration": dayjs.duration(dayjs(sessionDetails.end).diff(sessionDetails.start)).format("HH:mm:ss:SSS"),
    User: item.actor.email
  };
  return /* @__PURE__ */ jsxs("div", { className: "flexbox column", style: { margin: theme.spacing(3), minWidth: "min-content" }, children: [
    canReadDevices && /* @__PURE__ */ jsx(DeviceDetails_default, { device, idAttribute, onClose }),
    /* @__PURE__ */ jsx(DetailInformation, { title: "port forwarding", details: sessionMeta })
  ] });
};
var PortForward_default = PortForward;

export {
  PortForward,
  PortForward_default
};
//# sourceMappingURL=chunk-53DSLQTC.js.map