import {
  ATTRIBUTE_SCOPES,
  DEPLOYMENT_STATES,
  DEVICE_FILTERING_OPTIONS,
  DEVICE_ISSUE_OPTIONS,
  DEVICE_LIST_MAXIMUM_LENGTH,
  defaultStats,
  deploymentDisplayStates,
  deploymentStatesToSubstates,
  deploymentStatesToSubstatesWithSkipped,
  emptyFilter,
  emptyUiPermissions
} from "./chunk-7C4SQBEE.js";
import {
  softwareIndicator
} from "./chunk-2DYA3X77.js";
import {
  DARK_MODE
} from "./chunk-HFOTAPIJ.js";

// src/utils.ts
import { duplicateFilter, yes } from "@northern.tech/utils/helpers";
var filterProcessors = {
  [DEVICE_FILTERING_OPTIONS.$gt.key]: (val) => Number(val) || val,
  [DEVICE_FILTERING_OPTIONS.$gte.key]: (val) => Number(val) || val,
  [DEVICE_FILTERING_OPTIONS.$lt.key]: (val) => Number(val) || val,
  [DEVICE_FILTERING_OPTIONS.$lte.key]: (val) => Number(val) || val,
  [DEVICE_FILTERING_OPTIONS.$ltne.key]: (val) => Number(val) || val,
  [DEVICE_FILTERING_OPTIONS.$in.key]: (val) => ("" + val).split(",").map((i) => i.trim()),
  [DEVICE_FILTERING_OPTIONS.$nin.key]: (val) => ("" + val).split(",").map((i) => i.trim()),
  [DEVICE_FILTERING_OPTIONS.$exists.key]: yes,
  [DEVICE_FILTERING_OPTIONS.$nexists.key]: () => false
};
var filterAliases = {
  $nexists: { alias: DEVICE_FILTERING_OPTIONS.$exists.key, value: false }
};
var mapFiltersToTerms = (filters) => filters.map((filter) => ({
  scope: filter.scope,
  attribute: filter.key,
  type: filterAliases[filter.operator]?.alias || filter.operator,
  value: filterProcessors.hasOwnProperty(filter.operator) ? filterProcessors[filter.operator](filter.value) : filter.value
}));
var mapTermsToFilters = (terms) => terms.map((term) => {
  const aliasedFilter = Object.entries(filterAliases).find(
    (aliasDefinition) => aliasDefinition[1].alias === term.type && aliasDefinition[1].value === term.value
  );
  const operator = aliasedFilter ? aliasedFilter[0] : term.type;
  return { scope: term.scope, key: term.attribute, operator, value: term.value };
});
var convertIssueOptionsToFilters = (issuesSelection, filtersState = {}) => issuesSelection.map((item) => {
  if (typeof DEVICE_ISSUE_OPTIONS[item].filterRule.value === "function") {
    return { ...DEVICE_ISSUE_OPTIONS[item].filterRule, value: DEVICE_ISSUE_OPTIONS[item].filterRule.value(filtersState) };
  }
  return DEVICE_ISSUE_OPTIONS[item].filterRule;
});
var convertDeviceListStateToFilters = ({
  filters = [],
  group,
  groups = { byId: {} },
  offlineThreshold,
  selectedIssues = [],
  status
}) => {
  let applicableFilters = [...filters];
  if (typeof group === "string" && !(groups.byId[group]?.filters || applicableFilters).length) {
    applicableFilters.push({ key: "group", value: group, operator: DEVICE_FILTERING_OPTIONS.$eq.key, scope: "system" });
  }
  const nonMonitorFilters = applicableFilters.filter(
    (filter) => !Object.values(DEVICE_ISSUE_OPTIONS).some(
      ({ filterRule }) => filter.scope !== "inventory" && filterRule.scope === filter.scope && filterRule.key === filter.key
    )
  );
  const deviceIssueFilters = convertIssueOptionsToFilters(selectedIssues, { offlineThreshold });
  applicableFilters = [...nonMonitorFilters, ...deviceIssueFilters];
  const effectiveFilters = status ? [...applicableFilters, { key: "status", value: status, operator: DEVICE_FILTERING_OPTIONS.$eq.key, scope: "identity" }] : applicableFilters;
  return { applicableFilters: nonMonitorFilters, filterTerms: mapFiltersToTerms(effectiveFilters) };
};
var filterCompare = (filter, item) => Object.keys(emptyFilter).every((key) => item[key]?.toString() === filter[key]?.toString());
var filtersFilter = (item, index, array) => {
  const firstIndex = array.findIndex((filter) => filterCompare(filter, item));
  return firstIndex === index;
};
var listItemMapper = (byId, ids, { cutOffSize = DEVICE_LIST_MAXIMUM_LENGTH, defaultObject = {} }) => ids.slice(0, cutOffSize).reduce((accu, id) => {
  if (id && byId[id]) {
    accu.push({ ...defaultObject, ...byId[id] });
  }
  return accu;
}, []);
var mergePermissions = (existingPermissions = { ...emptyUiPermissions }, addedPermissions) => Object.entries(existingPermissions).reduce(
  (accu, [key, value]) => {
    let values;
    if (!accu[key]) {
      accu[key] = value;
      return accu;
    }
    if (Array.isArray(value)) {
      values = [...value, ...accu[key]].filter(duplicateFilter);
    } else {
      values = mergePermissions(accu[key], { ...value });
    }
    accu[key] = values;
    return accu;
  },
  { ...addedPermissions }
);
var mapUserRolesToUiPermissions = (userRoles, roles) => userRoles.reduce(
  (accu, roleId) => {
    if (!(roleId && roles[roleId])) {
      return accu;
    }
    return mergePermissions(accu, roles[roleId].uiPermissions);
  },
  { ...emptyUiPermissions }
);
var progress = ({ loaded, total }) => {
  let uploadProgress = loaded / total * 100;
  return uploadProgress = uploadProgress < 50 ? Math.ceil(uploadProgress) : Math.round(uploadProgress);
};
var extractErrorMessage = (err, fallback = "") => err.response?.data?.error?.message || err.response?.data?.error || err.error || err.message || fallback;
var ensureVersionString = (software, fallback) => software.length && software !== "artifact_name" ? software.endsWith(softwareIndicator) ? software : `${software}${softwareIndicator}` : fallback;
var getComparisonCompatibleVersion = (version) => isNaN(version.charAt(0)) && version !== "next" ? "master" : version;
var stringToBoolean = (content) => {
  if (!content) {
    return false;
  }
  const string = content + "";
  switch (string.trim().toLowerCase()) {
    case "true":
    case "yes":
    case "1":
      return true;
    case "false":
    case "no":
    case "0":
    case null:
      return false;
    default:
      return Boolean(string);
  }
};
var groupDeploymentDevicesStats = (deployment) => {
  const deviceStatCollector = (deploymentStates, devices) => Object.values(devices).reduce((accu, device) => deploymentStates.includes(device.status) ? accu + 1 : accu, 0);
  const inprogress = deviceStatCollector(deploymentStatesToSubstates.inprogress, deployment.devices);
  const pending = deviceStatCollector(deploymentStatesToSubstates.pending, deployment.devices);
  const successes = deviceStatCollector(deploymentStatesToSubstates.successes, deployment.devices);
  const failures = deviceStatCollector(deploymentStatesToSubstates.failures, deployment.devices);
  const paused = deviceStatCollector(deploymentStatesToSubstates.paused, deployment.devices);
  return { inprogress, paused, pending, successes, failures };
};
var statCollector = (items, statistics) => items.reduce((accu, property) => accu + Number(statistics[property] || 0), 0);
var groupDeploymentStats = (deployment, withSkipped) => {
  const { statistics = {} } = deployment;
  const { status = {} } = statistics;
  const stats = { ...defaultStats, ...status };
  let groupStates = deploymentStatesToSubstates;
  let result = {};
  if (withSkipped) {
    groupStates = deploymentStatesToSubstatesWithSkipped;
    result.skipped = statCollector(groupStates.skipped, stats);
  }
  result = {
    ...result,
    // don't include 'pending' as inprogress, as all remaining devices will be pending - we don't discriminate based on phase membership
    inprogress: statCollector(groupStates.inprogress, stats),
    pending: statCollector(groupStates.pending, stats),
    successes: statCollector(groupStates.successes, stats),
    failures: statCollector(groupStates.failures, stats),
    paused: statCollector(groupStates.paused, stats)
  };
  return result;
};
var getDeploymentState = (deployment) => {
  const { status: deploymentStatus = DEPLOYMENT_STATES.pending } = deployment;
  const { inprogress: currentProgressCount, paused } = groupDeploymentStats(deployment);
  let status = deploymentDisplayStates[deploymentStatus];
  if (deploymentStatus === DEPLOYMENT_STATES.pending && currentProgressCount === 0) {
    status = "queued";
  } else if (paused > 0) {
    status = deploymentDisplayStates.paused;
  }
  return status;
};
var generateDeploymentGroupDetails = (filter, groupName) => filter && filter.terms?.length ? `${groupName} (${filter.terms.map((filter2) => `${filter2.attribute || filter2.key} ${DEVICE_FILTERING_OPTIONS[filter2.type || filter2.operator].shortform} ${filter2.value}`).join(", ")})` : groupName;
var mapDeviceAttributes = (attributes = []) => attributes.reduce(
  (accu, attribute) => {
    if (!(attribute.value && attribute.name) && attribute.scope === ATTRIBUTE_SCOPES.inventory) {
      return accu;
    }
    accu[attribute.scope || ATTRIBUTE_SCOPES.inventory] = {
      ...accu[attribute.scope || ATTRIBUTE_SCOPES.inventory],
      [attribute.name]: attribute.value
    };
    if (attribute.name === "device_type" && attribute.scope === ATTRIBUTE_SCOPES.inventory) {
      accu.inventory.device_type = [].concat(attribute.value);
    }
    return accu;
  },
  { inventory: { device_type: [], artifact_name: "" }, identity: {}, monitor: {}, system: {}, tags: {} }
);
var isDarkMode = (mode) => mode === DARK_MODE;
var parseSubscriptionPreview = (lines) => lines.reduce(
  (acc, { addon, amount }) => {
    const key = addon || "plan";
    if (key === "plan") {
      acc.plan += amount;
    } else {
      acc.addons[key] = (acc.addons[key] ?? 0) + amount;
    }
    return acc;
  },
  { plan: 0, addons: {} }
);

export {
  mapFiltersToTerms,
  mapTermsToFilters,
  convertDeviceListStateToFilters,
  filtersFilter,
  listItemMapper,
  mergePermissions,
  mapUserRolesToUiPermissions,
  progress,
  extractErrorMessage,
  ensureVersionString,
  getComparisonCompatibleVersion,
  stringToBoolean,
  groupDeploymentDevicesStats,
  statCollector,
  groupDeploymentStats,
  getDeploymentState,
  generateDeploymentGroupDetails,
  mapDeviceAttributes,
  isDarkMode,
  parseSubscriptionPreview
};
//# sourceMappingURL=chunk-UE5N5VO3.js.map