"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/sockethook.ts
var sockethook_exports = {};
__export(sockethook_exports, {
  useSession: () => useSession
});
module.exports = __toCommonJS(sockethook_exports);
var import_react = require("react");
var import_helpers = require("@northern.tech/utils/helpers");
var import_msgpack5 = __toESM(require("msgpack5"), 1);
var import_universal_cookie = __toESM(require("universal-cookie"), 1);

// src/constants.ts
var import_constants3 = require("@northern.tech/utils/constants");

// src/commonConstants.tsx
var import_js = require("@mdi/js");
var import_MenderTypes = require("@northern.tech/types/MenderTypes");
var import_jsx_runtime = require("react/jsx-runtime");
var timeUnits = {
  days: "days",
  minutes: "minutes",
  hours: "hours"
};
var oneSecond = 1e3;
var TIMEOUTS = {
  debounceDefault: 700,
  debounceShort: 300,
  halfASecond: 0.5 * oneSecond,
  oneSecond,
  twoSeconds: 2 * oneSecond,
  threeSeconds: 3 * oneSecond,
  fiveSeconds: 5 * oneSecond,
  refreshDefault: 10 * oneSecond,
  refreshLong: 60 * oneSecond
};
var DEVICE_ONLINE_CUTOFF = { interval: 1, intervalName: timeUnits.days };
var defaultIdAttribute = Object.freeze({ attribute: "id", scope: import_constants3.ATTRIBUTE_SCOPES.identity });
var credentialTypes = {
  aws: import_MenderTypes.Credentials.type.AWS,
  http: import_MenderTypes.Credentials.type.HTTP,
  sas: import_MenderTypes.Credentials.type.SAS,
  x509: "x509"
};
var EXTERNAL_PROVIDER = {
  "iot-core": {
    credentialsType: credentialTypes.aws,
    icon: import_js.mdiAws,
    title: "AWS IoT Core",
    twinTitle: "Device Shadow",
    provider: "iot-core",
    enabled: true,
    deviceTwin: true,
    configHint: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_jsx_runtime.Fragment, { children: "For help finding your AWS IoT Core connection string, check the AWS IoT documentation." })
  },
  "iot-hub": {
    credentialsType: credentialTypes.sas,
    icon: import_js.mdiMicrosoftAzure,
    title: "Azure IoT Hub",
    twinTitle: "Device Twin",
    provider: "iot-hub",
    enabled: true,
    deviceTwin: true,
    configHint: /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("span", { children: [
      "For help finding your Azure IoT Hub connection string, look under 'Shared access policies' in the Microsoft Azure UI as described",
      " ",
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
        "a",
        {
          href: "https://devblogs.microsoft.com/iotdev/understand-different-connection-strings-in-azure-iot-hub/#iothubconn",
          target: "_blank",
          rel: "noopener noreferrer",
          children: "here"
        }
      ),
      "."
    ] })
  },
  webhook: {
    credentialsType: credentialTypes.http,
    deviceTwin: false,
    twinTitle: "",
    // disable the webhook provider here, since it is treated different than other integrations, with a custom configuration & management view, etc.
    enabled: false,
    provider: "webhook"
  }
};
var emptyWebhook = {
  description: "",
  provider: import_MenderTypes.Integration.provider.WEBHOOK,
  credentials: {
    type: EXTERNAL_PROVIDER.webhook.credentialsType,
    [EXTERNAL_PROVIDER.webhook.credentialsType]: {
      secret: "",
      url: ""
    }
  }
};
var regionNames = new Intl.DisplayNames(["en"], { type: "region" });
var countries = [
  "AD",
  "AE",
  "AF",
  "AG",
  "AI",
  "AL",
  "AM",
  "AO",
  "AQ",
  "AR",
  "AS",
  "AT",
  "AU",
  "AW",
  "AX",
  "AZ",
  "BA",
  "BB",
  "BD",
  "BE",
  "BF",
  "BG",
  "BH",
  "BI",
  "BJ",
  "BL",
  "BM",
  "BN",
  "BO",
  "BR",
  "BS",
  "BT",
  "BV",
  "BW",
  "BY",
  "BZ",
  "CA",
  "CC",
  "CD",
  "CF",
  "CG",
  "CH",
  "CI",
  "CK",
  "CL",
  "CM",
  "CN",
  "CO",
  "CR",
  "CU",
  "CV",
  "CW",
  "CX",
  "CY",
  "CZ",
  "DE",
  "DJ",
  "DK",
  "DM",
  "DO",
  "DZ",
  "EC",
  "EE",
  "EG",
  "EH",
  "ER",
  "ES",
  "ET",
  "FI",
  "FJ",
  "FK",
  "FM",
  "FO",
  "FR",
  "GA",
  "GB",
  "GD",
  "GE",
  "GF",
  "GG",
  "GH",
  "GI",
  "GL",
  "GM",
  "GN",
  "GP",
  "GQ",
  "GR",
  "GS",
  "GT",
  "GU",
  "GW",
  "GY",
  "HK",
  "HM",
  "HN",
  "HR",
  "HT",
  "HU",
  "ID",
  "IE",
  "IL",
  "IM",
  "IN",
  "IO",
  "IQ",
  "IR",
  "IS",
  "IT",
  "JE",
  "JM",
  "JO",
  "JP",
  "KE",
  "KG",
  "KH",
  "KI",
  "KM",
  "KN",
  "KP",
  "KR",
  "KW",
  "KY",
  "KZ",
  "LA",
  "LB",
  "LC",
  "LI",
  "LK",
  "LR",
  "LS",
  "LT",
  "LU",
  "LV",
  "LY",
  "MA",
  "MC",
  "MD",
  "ME",
  "MF",
  "MG",
  "MH",
  "MK",
  "ML",
  "MM",
  "MN",
  "MO",
  "MP",
  "MQ",
  "MR",
  "MS",
  "MT",
  "MU",
  "MV",
  "MW",
  "MX",
  "MY",
  "MZ",
  "NA",
  "NC",
  "NE",
  "NF",
  "NG",
  "NI",
  "NL",
  "NO",
  "NP",
  "NR",
  "NU",
  "NZ",
  "OM",
  "PA",
  "PE",
  "PF",
  "PG",
  "PH",
  "PK",
  "PL",
  "PM",
  "PN",
  "PR",
  "PS",
  "PT",
  "PW",
  "PY",
  "QA",
  "RE",
  "RO",
  "RS",
  "RU",
  "RW",
  "SA",
  "SB",
  "SC",
  "SD",
  "SE",
  "SG",
  "SH",
  "SI",
  "SJ",
  "SK",
  "SL",
  "SM",
  "SN",
  "SO",
  "SR",
  "SS",
  "ST",
  "SV",
  "SX",
  "SY",
  "SZ",
  "TC",
  "TD",
  "TF",
  "TG",
  "TH",
  "TJ",
  "TK",
  "TL",
  "TM",
  "TN",
  "TO",
  "TR",
  "TT",
  "TV",
  "TW",
  "TZ",
  "UA",
  "UG",
  "US",
  "UY",
  "UZ",
  "VA",
  "VC",
  "VE",
  "VG",
  "VI",
  "VN",
  "VU",
  "WF",
  "WS",
  "XK",
  "YE",
  "YT",
  "ZA",
  "ZM",
  "ZW"
].map((code) => ({ code, label: regionNames.of(code) })).sort((a, b) => a.label.localeCompare(b.label));

// src/devicesSlice/constants.ts
var emptyFilter = { key: null, value: "", operator: import_constants3.DEVICE_FILTERING_OPTIONS.$eq.key, scope: "inventory" };
var DEVICE_MESSAGE_PROTOCOLS = {
  Shell: 1
};
var DEVICE_MESSAGE_TYPES = {
  Delay: "delay",
  New: "new",
  Ping: "ping",
  Pong: "pong",
  Resize: "resize",
  Shell: "shell",
  Stop: "stop"
};
var geoAttributes = ["geo-lat", "geo-lon"].map((attribute) => ({ attribute, scope: "inventory" }));

// src/sockethook.ts
var cookies = new import_universal_cookie.default();
var MessagePack = (0, import_msgpack5.default)();
var useSession = ({ onClose, onHealthCheckFailed, onMessageReceived, onNotify, onOpen, token }) => {
  const [sessionId, setSessionId] = (0, import_react.useState)();
  const healthcheckTimeout = (0, import_react.useRef)();
  const socketRef = (0, import_react.useRef)();
  const sendMessage = (0, import_react.useCallback)(({ typ, body, props }) => {
    if (!socketRef.current) {
      return;
    }
    const proto_header = { proto: DEVICE_MESSAGE_PROTOCOLS.Shell, typ, sid: socketRef.current.sessionId, props };
    const encodedData = MessagePack.encode({ hdr: proto_header, body });
    socketRef.current.send(encodedData);
  }, []);
  const close = (0, import_react.useCallback)(() => {
    if (!socketRef.current || socketRef.current?.readyState !== WebSocket.OPEN) {
      return;
    }
    sendMessage({ typ: DEVICE_MESSAGE_TYPES.Stop, body: {}, props: {} });
    socketRef.current.close();
    setSessionId();
  }, [sendMessage]);
  const healthcheckFailed = (0, import_react.useCallback)(() => {
    onHealthCheckFailed();
    close();
  }, [close, onHealthCheckFailed]);
  const onSocketMessage = (0, import_react.useCallback)(
    (event) => (0, import_helpers.blobToString)(event.data).then((data) => {
      const {
        hdr: { props = {}, proto, sid, typ },
        body
      } = MessagePack.decode(data);
      if (proto !== DEVICE_MESSAGE_PROTOCOLS.Shell) {
        return;
      }
      switch (typ) {
        case DEVICE_MESSAGE_TYPES.New: {
          if (props.status == WebSocket.CLOSING) {
            onNotify(`Error: ${(0, import_helpers.byteArrayToString)(body)}`);
            setSessionId();
            return close();
          } else {
            clearTimeout(healthcheckTimeout.current);
            healthcheckTimeout.current = setTimeout(healthcheckFailed, 65 * TIMEOUTS.oneSecond);
            socketRef.current.sessionId = sid;
            return setSessionId(sid);
          }
        }
        case DEVICE_MESSAGE_TYPES.Shell:
          return onMessageReceived(body);
        case DEVICE_MESSAGE_TYPES.Stop:
          return close();
        case DEVICE_MESSAGE_TYPES.Ping: {
          if (healthcheckTimeout.current) {
            clearTimeout(healthcheckTimeout.current);
          }
          sendMessage({ typ: DEVICE_MESSAGE_TYPES.Pong });
          const timeout = parseInt(props.timeout);
          if (timeout > 0) {
            healthcheckTimeout.current = setTimeout(healthcheckFailed, timeout * TIMEOUTS.oneSecond);
          }
          return;
        }
        default:
          break;
      }
    }),
    [close, healthcheckFailed, onMessageReceived, onNotify, sendMessage]
  );
  const onSocketError = (0, import_react.useCallback)(
    (error) => {
      onNotify(`WebSocket error: ${error.message}`);
      close();
      clearTimeout(healthcheckTimeout.current);
    },
    [close, onNotify]
  );
  const onSocketOpen = (0, import_react.useCallback)(() => {
    sendMessage({ typ: DEVICE_MESSAGE_TYPES.New, props: {} });
    onOpen(true);
  }, [onOpen, sendMessage]);
  const onSocketClose = (0, import_react.useCallback)(
    (e) => {
      console.log("closing");
      onClose(e);
      close();
    },
    [close, onClose]
  );
  const connect = (0, import_react.useCallback)(
    (deviceId) => {
      const uri = `wss://${window.location.host}${import_constants3.apiUrl.v1}/deviceconnect/devices/${deviceId}/connect`;
      setSessionId();
      cookies.set("JWT", token, { path: "/", secure: true, sameSite: "strict", maxAge: 5 });
      try {
        socketRef.current = new WebSocket(uri);
      } catch (error) {
        console.log(error);
      }
    },
    [token]
  );
  (0, import_react.useEffect)(() => {
    if (!socketRef.current) {
      return;
    }
    socketRef.current.addEventListener("close", onSocketClose);
    socketRef.current.addEventListener("error", onSocketError);
    socketRef.current.addEventListener("message", onSocketMessage);
    socketRef.current.addEventListener("open", onSocketOpen);
    return () => {
      socketRef.current.removeEventListener("close", onSocketClose);
      socketRef.current.removeEventListener("error", onSocketError);
      socketRef.current.removeEventListener("message", onSocketMessage);
      socketRef.current.removeEventListener("open", onSocketOpen);
    };
  }, [onSocketClose, onSocketError, onSocketMessage, onSocketOpen, socketRef.current?.readyState]);
  return [connect, sendMessage, close, socketRef.current?.readyState ?? WebSocket.CLOSED, sessionId];
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  useSession
});
//# sourceMappingURL=sockethook.cjs.map