import React from 'react';
import {
  Box,
  Typography
} from '@mui/material';

import { CmdbItem } from '../../../store/cmdbSlice/thunks';
import { getFirstEntryName } from '../../../utils';

interface ClassViewProps {
  item: CmdbItem;
  onValueClick?: () => void;
  classes?: Record<string, string>;
}

const ClassView: React.FC<ClassViewProps> = ({ 
  item, 
  onValueClick = () => {}, 
  classes = {} 
}) => {
  return (
    <>
      <Box className={classes.container}>
        <Typography className={classes.key}>
          Name:
        </Typography>
        <Box onClick={onValueClick} className={classes.value}>
          {getFirstEntryName(item)}
        </Box>
      </Box>
      <Box className={classes.container}>
        <Typography className={classes.key}>
          Tags:
        </Typography>
        <Box onClick={onValueClick} className={classes.value}>
          {item.tags?.join(', ')}
        </Box>
      </Box>
      <Box className={classes.container}>
        <Typography className={classes.key}>
          Description:
        </Typography>
        <Box onClick={onValueClick} className={classes.value}>
          {item.description}
        </Box>
      </Box>
    </>
  );
};

export default ClassView;
