"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/DetailsTable.tsx
var DetailsTable_exports = {};
__export(DetailsTable_exports, {
  DetailsTable: () => DetailsTable,
  default: () => DetailsTable_default
});
module.exports = __toCommonJS(DetailsTable_exports);
var import_icons_material = require("@mui/icons-material");
var import_material = require("@mui/material");
var import_mui = require("tss-react/mui");
var import_constants = require("@northern.tech/store/constants");
var import_jsx_runtime = require("react/jsx-runtime");
var useStyles = (0, import_mui.makeStyles)()(() => ({
  header: {
    ".columnHeader": {
      display: "table-cell"
    },
    ".columnHeader .sortIcon": {
      marginBottom: -6
    },
    ".nonSortable": { cursor: "initial" }
  }
}));
var DetailsTable = ({
  className = "",
  columns,
  items,
  onChangeSorting,
  onItemClick,
  sort = {},
  style = {},
  tableRef,
  onRowSelected,
  selectedRows = []
}) => {
  const { classes } = useStyles();
  const onRowSelection = (selectedRow) => {
    const updatedSelection = [...selectedRows];
    const selectedIndex = updatedSelection.indexOf(selectedRow);
    if (selectedIndex === -1) {
      updatedSelection.push(selectedRow);
    } else {
      updatedSelection.splice(selectedIndex, 1);
    }
    onRowSelected(updatedSelection);
  };
  const onSelectAllClick = () => {
    let newSelectedRows = Array.from({ length: items.length }, (_, index) => index);
    if (selectedRows.length && selectedRows.length <= items.length) {
      newSelectedRows = [];
    }
    onRowSelected(newSelectedRows);
  };
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_material.Table, { className: `margin-bottom ${className}`, style, ref: tableRef, children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.TableHead, { className: classes.header, children: /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_material.TableRow, { children: [
      onRowSelected !== void 0 && /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.TableCell, { children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.Checkbox, { indeterminate: false, checked: selectedRows.length === items.length, onChange: onSelectAllClick }) }),
      columns.map(({ extras, key, renderTitle, sortable, title }) => /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_material.TableCell, { className: `columnHeader ${sortable ? "" : "nonSortable"}`, onClick: () => sortable ? onChangeSorting(key) : null, children: [
        renderTitle ? renderTitle(extras) : title,
        sortable && /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_icons_material.Sort, { className: `sortIcon ${sort.key === key ? "selected" : ""} ${(sort.direction === import_constants.SORTING_OPTIONS.desc).toString()}` })
      ] }, key))
    ] }) }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.TableBody, { children: items.map((item, index) => /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_material.TableRow, { className: onItemClick ? "clickable" : "", hover: true, children: [
      onRowSelected !== void 0 && /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.TableCell, { children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.Checkbox, { checked: selectedRows.includes(index), onChange: () => onRowSelection(index) }) }),
      columns.map((column) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.TableCell, { className: "relative", onClick: () => onItemClick ? onItemClick(item) : null, children: column.render(item, column.extras) }, column.key))
    ] }, item.id || index)) })
  ] });
};
var DetailsTable_default = DetailsTable;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  DetailsTable
});
//# sourceMappingURL=DetailsTable.cjs.map