import * as redux from 'redux';
import * as _reduxjs_toolkit from '@reduxjs/toolkit';
import { PayloadAction } from '@reduxjs/toolkit';
import * as immer from 'immer';
import { User as User$1, TenantInfo, TenantsIdName, DeploymentPhase } from '@northern.tech/types/MenderTypes';
import { PermissionSet, Role } from '@northern.tech/utils/constants';
import { FilterOperator } from '../commonConstants.cjs';
import { ReadState } from './constants.cjs';
import 'react/jsx-runtime';

declare const sliceName = "users";
type User = User$1 & TenantInfo & {
    tenants?: TenantsIdName;
};
type UserSession = {
    expiresAt?: string;
    token: string;
};
type CustomColumn = {
    attribute: {
        name: string;
        scope: string;
    };
    size: number;
};
type FilterOption = {
    key: string;
    operator: FilterOperator;
    scope: string;
    value: string;
};
type GlobalSettings = {
    [x: string]: any;
    id_attribute?: {
        attribute: string;
        scope: string;
    };
    previousFilters: FilterOption[];
    previousPhases: DeploymentPhase[][];
    retries: number;
};
type Column = {
    id: string;
    key: string;
    name: string;
    scope: string;
    title: string;
};
type UserSettings = {
    [x: string]: any;
    columnSelection: Column[];
    feedbackCollectedAt?: string;
    mode?: 'light' | 'dark';
    onboarding: Partial<{
        address: string;
        approach: 'physical' | 'virtual';
        complete: boolean;
        demoArtifactPort: number;
        deviceType: string[] | string;
        progress: string;
        showTips: null | boolean;
        showTipsDialog: boolean;
    }>;
    tooltips?: object;
    trackingConsentGiven?: boolean;
};
type UserSliceState = {
    activationCode?: string;
    byId: Record<string, User>;
    currentSession?: UserSession | object;
    currentUser: string | null;
    customColumns: CustomColumn[];
    globalSettings: GlobalSettings;
    permissionSetsById: Record<string, PermissionSet>;
    qrCode: string | null;
    rolesById: Record<string, Role>;
    rolesInitialized: boolean;
    settingsInitialized: boolean;
    showConnectDeviceDialog: boolean;
    showFeedbackDialog: boolean;
    showStartupNotification: boolean;
    tooltips: {
        byId: Record<string, {
            readState: ReadState;
        }>;
    };
    userSettings: UserSettings;
    userSettingsInitialized: boolean;
};
declare const initialState: UserSliceState;
declare const usersSlice: _reduxjs_toolkit.Slice<UserSliceState, {
    receivedQrCode: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<string | null>) => void;
    successfullyLoggedIn: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<UserSession>) => void;
    receivedUserList: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<Record<string, User>>) => void;
    receivedActivationCode: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<string>) => void;
    receivedUser: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<User>) => void;
    removedUser: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<string>) => void;
    updatedUser: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<Partial<User> & {
        id: string;
    }>) => void;
    receivedPermissionSets: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<Record<string, PermissionSet>>) => void;
    receivedRoles: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<Record<string, Role>>) => void;
    finishedRoleInitialization: (state: immer.WritableDraft<UserSliceState>, action: {
        payload: any;
        type: string;
    }) => void;
    createdRole: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<Role>) => void;
    removedRole: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<string>) => void;
    setCustomColumns: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<CustomColumn[]>) => void;
    setGlobalSettings: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<GlobalSettings>) => void;
    setUserSettings: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<UserSettings>) => void;
    setTooltipState: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<{
        id: string;
        readState: ReadState;
    }>) => void;
    setTooltipsState: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<UserSliceState["tooltips"]["byId"]>) => void;
    setShowFeedbackDialog: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<boolean>) => void;
    setShowConnectingDialog: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<boolean>) => void;
    setShowStartupNotification: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<boolean>) => void;
}, "users", "users", _reduxjs_toolkit.SliceSelectors<UserSliceState>>;
declare const actions: _reduxjs_toolkit.CaseReducerActions<{
    receivedQrCode: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<string | null>) => void;
    successfullyLoggedIn: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<UserSession>) => void;
    receivedUserList: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<Record<string, User>>) => void;
    receivedActivationCode: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<string>) => void;
    receivedUser: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<User>) => void;
    removedUser: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<string>) => void;
    updatedUser: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<Partial<User> & {
        id: string;
    }>) => void;
    receivedPermissionSets: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<Record<string, PermissionSet>>) => void;
    receivedRoles: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<Record<string, Role>>) => void;
    finishedRoleInitialization: (state: immer.WritableDraft<UserSliceState>, action: {
        payload: any;
        type: string;
    }) => void;
    createdRole: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<Role>) => void;
    removedRole: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<string>) => void;
    setCustomColumns: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<CustomColumn[]>) => void;
    setGlobalSettings: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<GlobalSettings>) => void;
    setUserSettings: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<UserSettings>) => void;
    setTooltipState: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<{
        id: string;
        readState: ReadState;
    }>) => void;
    setTooltipsState: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<UserSliceState["tooltips"]["byId"]>) => void;
    setShowFeedbackDialog: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<boolean>) => void;
    setShowConnectingDialog: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<boolean>) => void;
    setShowStartupNotification: (state: immer.WritableDraft<UserSliceState>, action: PayloadAction<boolean>) => void;
}, "users">;
declare const _default: redux.Reducer<UserSliceState>;

export { type CustomColumn, type GlobalSettings, type User, type UserSession, type UserSettings, actions, _default as default, initialState, sliceName, usersSlice };
