import { Actor } from './Actor.cjs';
import { AuditLogObject } from './AuditLogObject.cjs';
import './Artifact.cjs';
import './ArtifactInfo.cjs';
import './Update.cjs';
import './ArtifactTypeInfo.cjs';
import './UpdateFile.cjs';
import './Deployment.cjs';
import './DeploymentPhase.cjs';
import './DeploymentStatistics.cjs';
import './DeploymentStatusStatistics.cjs';
import './Filter.cjs';
import './FilterPredicate.cjs';
import './Device.cjs';
import './DeviceStatus.cjs';
import './Tenant.cjs';
import './TenantV1.cjs';
import './Addon.cjs';
import './Plan.cjs';
import './Features.cjs';
import './TenantAdditionalInfo.cjs';
import './TenantApiLimits.cjs';
import './ApiLimits.cjs';
import './ApiBurst.cjs';
import './ApiQuota.cjs';
import './User.cjs';

/**
 * Audit log entry
 */
type AuditLog = {
    actor: Actor;
    time: string;
    action: AuditLog.action;
    object: AuditLogObject;
    change?: string;
};
declare namespace AuditLog {
    enum action {
        CREATE = "create",
        UPDATE = "update",
        DELETE = "delete",
        ABORT = "abort",
        REJECT = "reject",
        DECOMMISSION = "decommission",
        OPEN_TERMINAL = "open_terminal",
        CLOSE_TERMINAL = "close_terminal",
        OPEN_PORTFORWARD = "open_portforward",
        CLOSE_PORTFORWARD = "close_portforward",
        DOWNLOAD_FILE = "download_file",
        UPLOAD_FILE = "upload_file",
        SET_CONFIGURATION = "set_configuration",
        DEPLOY_CONFIGURATION = "deploy_configuration",
        UPLOAD = "upload"
    }
}

export { AuditLog };
