<?php

class AuditLogService
{
    /**
     * @param array $data
     * @return false|string
     *
     * Returns string with created audit logs id, otherwise false.
     *
     * This function does not throw any exceptions (logs only) to prevent
     * the main functionality not being affected.
     */
    public static function register(array $data): false|string
    {
        try {
            $auditLog = AuditLogDto::fromArray($data);

            if (!in_array($auditLog->action, AuditLogActions::ALLOWED_ACTIONS)) {
                throw new BadAuditLogActionException("Audit log action: {$auditLog->action} is not allowed");
            }

            if (!in_array($auditLog->objectType, AuditLogObjectTypes::ALLOWED_TYPES)) {
                throw new BadAuditLogObjectTypeException("Audit log entity type: {$auditLog->objectType} is not allowed");
            }

            $auditLogModel = new AuditLogModel();
            return $auditLogModel->create($auditLog->toArray());
        } catch (Exception $exception) {
            syslog(
                LOG_ERR,
                "An error occurred while writing to audit log. Err.:" . $exception->getTraceAsString()
            );
            return false;
        }
    }
}
