<?php


/**
 * @uri /host-groups/my/ 0
 */
class MyHostGroups extends CfProtectedResource
{
    private $myHostGroupsModel;

    public function __construct($parameters)
    {
        parent::__construct($parameters);

        $this->myHostGroupsModel = new MyHostGroupsModel($this->username);
    }


    public function get($request)
    {
        $response = new Response($request);
        $response->code = Response::OK;
        $args = $_GET;

        if (isset($args['sortColumn']) && !in_array($args['sortColumn'], PersonalHostGroupEntity::sortableColumns())) {
            throw new InvalidArgumentException("sortColumn `{$args['sortColumn']}` is not allowed.");
        }

        $response->body = json_encode($this->myHostGroupsModel->list($args, [], ['owner' => $this->username]));
        return $response;
    }

}
