<?php

require_once APPPATH . '/libraries/Cf_REST_Controller.php';
class Actions extends Cf_REST_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->username = $this->session->userdata('username');
        $this->load->model('actions_model');
    }

    public function report_collection_post()
    {
        $hostkey = $this->param('hostkey');
        if (!$hostkey) {
            respond_not_acceptable('hostkey is a required argument');
        }
        $this->actions_model->triggerReportCollection($hostkey);
        respond_ok();
    }

    public function agent_run_post()
    {
        $hostkey = $this->param('hostkey');
        if (!$hostkey) {
            respond_not_acceptable('hostkey is a required argument');
        }
        $this->actions_model->triggerAgentRun($hostkey);
        respond_ok();
    }

    public function hub_key_get()
    {
        $this->load->model('api_rest_model');
        $info = $this->api_rest_model->get_api_details();
        $key = $info['hub']['hostkey'] ?? null;
        respond_ok($key);
    }
}
