/*jslint node: true */
/*jslint browser: true*/
/*jslint nomen: true*/
/*jslint plusplus: true */
/*global dashboardApp, angular, $*/

'use strict';

dashboardApp.factory('dashboardHelper',
            ['$rootScope', '$location', '$q', 'dashboardService',
    function ($rootScope,   $location,   $q,   dashboardService) {
            var helper = {};


            helper.getdashboards = function (dashId) {
                return dashboardService.getdashboards(dashId).then(
                    function (result) {
                        return result.data;
                    },
                    function (error) {
                        // show error only if dash id is set
                        if (dashId) {
                            $rootScope.$emit('getDashboards_Fail_Event', error.data);
                        }
                    }
                );
            };

            helper.getselecteddashboard = function () {
                return dashboardService.getselecteddashboard().then(
                    function (result) {
                        return result.data;
                    },
                    function (error) {
                        $rootScope.$emit('getDashboards_Fail_Event', error.data);
                    }
                );
            };

            helper.setselecteddashboard = function (dashId) {
                return dashboardService.setselecteddashboard(dashId).then(
                    function (result) {
                        return result.data;
                    },
                    function (error) {
                        $rootScope.$emit('getDashboards_Fail_Event', error.data);
                    }
                );
            };

            helper.savedashboard = function (dashObj) {
                return dashboardService.savedashboard(dashObj);
            };

            helper.cloneDashboard = function (dashObj) {
                return dashboardService.cloneDashboard(dashObj);
            };

            helper.removedashboard = function (dashId) {
                return dashboardService.removedashboard(dashId).then(
                    function (result) {
                        // then remove it from user selections:
                        return dashboardService.resetselecteddashboards(dashId).then(
                            function (result) {
                                return result.data;
                            },
                            function (error) {
                              console.log("error reset ", error);
                            }
                        );

                    },
                    function (error) {
                        // show error only if widget id is set
                        if (dashId) {
                            $rootScope.$emit('deleteDashboard_Fail_Event', error.data);
                        }
                    }
                );
            };

            helper.addwidget = function (widgetId) {
              return dashboardService.addwidget(widgetId).then(
                  function (result) {
                    return result.data;
                  },
                  function (error) {
                   // show error only if widget id is set
                      if (widgetId) {
                          $rootScope.$emit('saveWidget_Fail_Event', error.data);
                      }
                  }
              );
            };

            helper.deletewidget = function (widgetId) {
              return dashboardService.deletewidget(widgetId).then(
                  function (result) {
                    return result.data;
                  },
                  function (error) {
                   // show error only if widget id is set
                      if (widgetId) {
                          $rootScope.$emit('deleteWidget_Fail_Event', error.data);
                      }
                  }
              );
            };

            helper.reorderwidgets = function (widgets, dashId) {
              return dashboardService.reorderwidgets(widgets, dashId).then(
                  function (result) {
                    return result.data;
                  },
                  function (error) {
                   // show error
                    $rootScope.$emit('deleteWidget_Fail_Event', error.data);
                  }
              );
            };

            helper.getUserRoles = function () {
                return dashboardService.getUserRoles().then(
                    function (result) {
                        return result.data;
                    }
                );
            };

            helper.getdashboardwithname = function(dashname, overwrite) {
              return dashboardService.getdashboards().then(
                 function (result) {
                      var found = false;
                      result.data.forEach(function(dashboard) {
                          if ((dashboard.name.toLowerCase() === dashname.toLowerCase()) && !overwrite) {
                              found = true;
                          }
                      });
                      return found;
                  },
                  function (error) {
                      // error handled on calling function
                      $rootScope.$emit('getDashboards_Fail_Event', error.data);
                  }
              );
            };

            helper.getcurrentdashowner = function(dashboard = null) {
              return dashboardService.getselecteddashboard().then(
                  function (result) {
                      var currentUser = [];
                      currentUser.username = result.data[0]['username'];
                      currentUser.dash = dashboard || result.data[0]['dashboard'];
                      return dashboardService.getdashboards(currentUser.dash).then(
                          function (result) {
                              if (result.data[0].username === currentUser.username) {
                                currentUser.editable = true;
                                return currentUser;
                              } else {
                                currentUser.editable = false;
                                return currentUser;
                              }
                          },
                          function (error) {
                              // error handled on calling function
                              $rootScope.$emit('getDashboards_Fail_Event', error.data);
                          }
                      );
                  },
                  function (error) {
                      // error handled on calling function
                      $rootScope.$emit('getDashboards_Fail_Event', error.data);
                  }
              );
            }

            return helper;
        }]);