/*jslint node: true */
/*jslint browser: true*/
/*jslint nomen: true*/
/*jslint plusplus: true */
/*global dashboardApp, angular, $*/

'use strict';

dashboardApp.factory('fileChangesWidgetHelper',
    ['$q', 'fileChangesService', '$window',
        function ($q, fileChangesService, $window) {
            var helper = {};

            helper.goToFileChangesReport = function (daterange, changeType) {
                sessionStorage.removeItem('sql');
                var url = MP_SITE_URL + "/reports/file_integrity_monitoring";
                if (daterange !== undefined || angular.equals({}, daterange)) {
                    url += "?from=" + daterange.from + "&to=" + daterange.to;
                }

                if (changeType !== undefined && changeType.length > 0) {
                    url += "&changeType=" + changeType;
                }

                $window.location.href = url;
            };

            helper.getChangesTypeByName = function (name) {
                let mapedTypes = {
                    'diff': 'Change in content (with file diff)',
                    'contentChange': 'Change in content (based on file hash)',
                    'fileStats': 'Change in file stats'
                }

                return Object.keys(mapedTypes).find(key => mapedTypes[key] === name);
            };

            helper.chartConfig = {

                chart: {
                    type: 'column',
                    backgroundColor: 'transparent',
                    events: {
                        click: function (e) {
                            helper.goToFileChangesReport()
                        }
                    }
                },
                colors: [widgetColors.mainColor(), '#F5821F', '#FEDB3E'],
                exporting: {
                    enabled: false
                },
                plotOptions: {
                    column: {
                        borderWidth: 0,
                        stacking: 'normal',
                        allowPointSelect: false,
                        cursor: 'pointer',
                        point: {
                            events: {
                                click: function () {
                                    var daterange = {};
                                    daterange.from = moment().startOf('day').subtract((6 - this.x), 'days');
                                    daterange.to = moment().startOf('day').subtract((5 - this.x), 'days').subtract('1', 'milliseconds'); // remove a ms to keep within day
                                    let changeType = helper.getChangesTypeByName(this.series.name);
                                    helper.goToFileChangesReport(daterange, changeType);
                                }
                            }
                        }
                    }
                },
                tooltip: {
                    headerFormat: '<b>{point.x}</b><br/>',
                    formatter: function () {
                        return this.series.name + ': ' + this.y;
                    }
                },
                legend: false,

                series: [],
                title: {
                    text: ''
                },
                subtitle: {
                    text: ''
                },
                xAxis: {
                    categories: [],
                    title: {
                        text: null
                    },
                    allowDecimals: false
                },
                yAxis: {
                    allowDecimals: false,
                    min: 0,
                    title: {
                        text: 'File changes'
                    }
                },
                credits: {
                    enabled: false
                },
                loading: false
            };


            helper.getFileChangeStats = function (data) {
                let promise = fileChangesService.getFileChangesStats(data).then(
                    function (result) {
                        return result;
                    }
                );

                return promise
            };

            helper.setChartData = function (changeStats, dates) {
                helper.chartConfig.series = changeStats;
                helper.chartConfig.xAxis.categories = dates;
            };

            return helper;
        }]);
