"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/DeviceIdentity.tsx
var DeviceIdentity_exports = {};
__export(DeviceIdentity_exports, {
  DeviceIdentityDisplay: () => DeviceIdentityDisplay,
  default: () => DeviceIdentity_default,
  defaultTextRender: () => defaultTextRender,
  getDeviceIdentityText: () => getDeviceIdentityText
});
module.exports = __toCommonJS(DeviceIdentity_exports);
var import_react3 = require("react");
var import_react_redux = require("react-redux");
var import_mui2 = require("tss-react/mui");
var import_selectors = require("@northern.tech/store/selectors");
var import_helpers = require("@northern.tech/utils/helpers");

// ../../assets/img/gateway-connection.svg
var gateway_connection_default = "./gateway-connection-TS7NBQVB.svg";

// ../../assets/img/gateway.svg
var gateway_default = "./gateway-XAJR5DH4.svg";

// src/DeviceNameInput.tsx
var import_react2 = require("react");
var import_material2 = require("@mui/material");
var import_mui = require("tss-react/mui");
var import_store = require("@northern.tech/store/store");
var import_thunks = require("@northern.tech/store/thunks");

// src/Confirm.tsx
var import_react = require("react");
var import_icons_material = require("@mui/icons-material");
var import_material = require("@mui/material");
var import_jsx_runtime = require("react/jsx-runtime");
var EditButton = ({ onClick, disabled = false }) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.Button, { onClick, size: "small", disabled, startIcon: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_icons_material.Edit, {}), style: { padding: 5 }, children: "Edit" });
var ConfirmationButtons = ({ onConfirm, onCancel }) => /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { className: "flexbox", children: [
  /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.IconButton, { onClick: onConfirm, size: "small", "aria-label": "confirm", children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_icons_material.Check, { color: "disabled" }) }),
  /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.IconButton, { onClick: onCancel, size: "small", "aria-label": "cancel", children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_icons_material.Close, { color: "disabled" }) })
] });

// src/DeviceNameInput.tsx
var import_jsx_runtime2 = require("react/jsx-runtime");
var useStyles = (0, import_mui.makeStyles)()((theme) => ({
  icon: {
    fontSize: "1.25rem"
  },
  input: {
    color: theme.palette.text.primary,
    fontSize: "0.8125rem"
  }
}));
var DeviceNameInput = ({ device, isHovered }) => {
  const [isEditing, setIsEditing] = (0, import_react2.useState)(false);
  const [value, setValue] = (0, import_react2.useState)("");
  const { classes } = useStyles();
  const inputRef = (0, import_react2.useRef)(void 0);
  const dispatch = (0, import_store.useAppDispatch)();
  const { id = "", tags = {} } = device;
  const { name = "" } = tags;
  (0, import_react2.useEffect)(() => {
    if (!isEditing && name !== value) {
      setValue(name);
    }
  }, [device, isEditing, name, value]);
  (0, import_react2.useEffect)(() => {
    if (!isEditing || !inputRef.current) {
      return;
    }
    inputRef.current.focus();
  }, [isEditing]);
  const onSubmit = () => dispatch((0, import_thunks.setDeviceTags)({ deviceId: id, tags: { ...tags, name: value } })).then(() => setIsEditing(false));
  const onCancel = () => {
    setValue(name);
    setIsEditing(false);
  };
  const onStartEdit = (e) => {
    e.stopPropagation();
    setIsEditing(true);
  };
  const onInputClick = (e) => e.stopPropagation();
  return /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
    import_material2.OutlinedInput,
    {
      id: `${device.id}-id-input`,
      className: classes.input,
      disabled: !isEditing,
      inputRef,
      value,
      placeholder: `${id.substring(0, 6)}...`,
      onClick: onInputClick,
      onChange: ({ target: { value: value2 } }) => setValue(value2),
      type: "text",
      endAdornment: (isHovered || isEditing) && /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_material2.InputAdornment, { position: "end", children: isEditing ? /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(ConfirmationButtons, { onCancel, onConfirm: onSubmit }) : /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(EditButton, { onClick: onStartEdit }) })
    }
  );
};
var DeviceNameInput_default = DeviceNameInput;

// src/DeviceIdentity.tsx
var import_jsx_runtime3 = require("react/jsx-runtime");
var useStyles2 = (0, import_mui2.makeStyles)()((theme) => ({
  container: {
    gridTemplateColumns: "1fr max-content",
    columnGap: theme.spacing()
  },
  gatewayIcon: {
    color: theme.palette.grey[400],
    width: "max-content",
    marginRight: theme.spacing()
  }
}));
var propertyNameMap = {
  inventory: "attributes",
  identity: "identity_data",
  system: "system",
  monitor: "monitor",
  tags: "tags"
};
var defaultTextRender = ({ column, device }) => {
  const propertyName = propertyNameMap[column.attribute.scope] ?? column.attribute.scope;
  const accessorTarget = device[propertyName] ?? device;
  const attributeValue = accessorTarget[column.attribute.name] || device[column.attribute.name];
  return (typeof attributeValue === "object" ? JSON.stringify(attributeValue) : attributeValue) ?? "-";
};
var getDeviceIdentityText = ({ device = {}, idAttribute }) => {
  const { id = "", identity_data = {}, tags = {} } = device;
  const { status, ...remainingIds } = identity_data;
  const nonIdKey = Object.keys(remainingIds)[0];
  if (!idAttribute || idAttribute === "id" || idAttribute === "Device ID") {
    return id;
  } else if (typeof idAttribute === "string" || !Object.keys(idAttribute).length) {
    return identity_data[idAttribute] ?? identity_data[nonIdKey] ?? id;
  }
  const { attribute, scope } = idAttribute;
  if (attribute === "name" && scope === "tags") {
    return tags[attribute] ?? `${id.substring(0, 6)}...`;
  }
  return defaultTextRender({ column: { attribute: { name: attribute, scope } }, device });
};
var DeviceIdComponent = ({ style = {}, value }) => /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("div", { style, children: value });
var attributeComponentMap = {
  default: DeviceIdComponent,
  name: DeviceNameInput_default
};
var adornments = [
  {
    component: gateway_connection_default,
    isApplicable: ({ attributes = {} }) => !(0, import_helpers.stringToBoolean)(attributes.mender_is_gateway) && !!attributes.mender_gateway_system_id
  },
  { component: gateway_default, isApplicable: ({ attributes = {} }) => (0, import_helpers.stringToBoolean)(attributes.mender_is_gateway) }
];
var DeviceIdentityDisplay = (props) => {
  const { device = {}, isEditable = true, hasAdornment = true } = props;
  const idAttribute = (0, import_react_redux.useSelector)(import_selectors.getIdAttribute);
  const { attribute, scope } = idAttribute;
  const stateDevice = (0, import_react_redux.useSelector)((state) => (0, import_selectors.getDeviceById)(state, device.id));
  const idValue = getDeviceIdentityText({ device: { ...device, ...stateDevice }, idAttribute });
  const { classes } = useStyles2();
  let Component = attributeComponentMap.default;
  if (attribute === "name" && scope === "tags") {
    Component = isEditable ? attributeComponentMap.name : Component;
  }
  const { attributes = {} } = device;
  const EndAdornment = (0, import_react3.useMemo)(
    () => adornments.find((item) => item.isApplicable(device))?.component,
    // eslint-disable-next-line react-hooks/exhaustive-deps
    [attributes.mender_is_gateway, attributes.mender_gateway_system_id]
  );
  return (
    // due to the specificity of the deviceListRow child class, applying the display styling through the container class doesn't work, thus the inline style in addition here
    /* @__PURE__ */ (0, import_jsx_runtime3.jsxs)("div", { className: classes.container, style: { display: "grid" }, children: [
      /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(Component, { ...props, value: idValue }),
      hasAdornment && EndAdornment && /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(EndAdornment, { className: classes.gatewayIcon })
    ] })
  );
};
var DeviceIdentity_default = DeviceIdentityDisplay;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  DeviceIdentityDisplay,
  defaultTextRender,
  getDeviceIdentityText
});
//# sourceMappingURL=DeviceIdentity.cjs.map